/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.blocks.base.CarvedCoconut;
import com.mystic.atlantis.blocks.base.EquipableCarvedCoconut;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;

public class Coconut
extends DirectionalBlock {
    public static final MapCodec<Coconut> CODEC = Coconut.simpleCodec(Coconut::new);

    public Coconut(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.CHERRY_WOOD).requiresCorrectToolForDrops().strength(3.0f, 6.0f));
        this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (itemstack.canPerformAction(ItemAbilities.SHEARS_CARVE)) {
            if (!pLevel.isClientSide) {
                Direction direction = pHit.getDirection();
                Direction direction1 = direction.getAxis() == Direction.Axis.Y ? pPlayer.getDirection().getOpposite() : direction;
                pLevel.playSound(null, pPos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.setBlock(pPos, (BlockState)((EquipableCarvedCoconut)((Object)BlockInit.CARVED_COCONUT.get())).defaultBlockState().setValue((Property)CarvedCoconut.FACING, (Comparable)direction1), 11);
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5 + (double)direction1.getStepX() * 0.65, (double)pPos.getY() + 0.1, (double)pPos.getZ() + 0.5 + (double)direction1.getStepZ() * 0.65, ItemStack.EMPTY);
                itementity.setDeltaMovement(0.05 * (double)direction1.getStepX() + pLevel.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.getStepZ() + pLevel.random.nextDouble() * 0.02);
                pLevel.addFreshEntity((Entity)itementity);
                itemstack.hurtAndBreak(1, (LivingEntity)pPlayer, pPlayer.getEquipmentSlotForItem(itemstack));
                pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.SHEAR, pPos);
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useItemOn(itemstack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }
}

