/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class CrystalTransferenceBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public CrystalTransferenceBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(4.5f).mapColor(MapColor.COLOR_LIGHT_BLUE).lightLevel(state -> 5).sound(SoundType.AMETHYST).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (this.isSubmergedInWater(pLevel, pPos)) {
            return Math.max(0, (Integer)pState.getValue((Property)POWER)) - 1;
        }
        return 0;
    }

    public void neighborChanged(BlockState targetState, Level level, BlockPos targetPos, Block targetBlock, BlockPos fromPos, boolean notify) {
        super.neighborChanged(targetState, level, targetPos, targetBlock, fromPos, notify);
        this.updatePower(targetState, level, targetPos);
    }

    public boolean isSubmergedInWater(BlockGetter getter, BlockPos targetPos) {
        return getter.getBlockState(targetPos.east()).is(Blocks.WATER) || getter.getBlockState(targetPos.west()).is(Blocks.WATER) || getter.getBlockState(targetPos.north()).is(Blocks.WATER) || getter.getBlockState(targetPos.south()).is(Blocks.WATER) || getter.getBlockState(targetPos.above()).is(Blocks.WATER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{POWER}));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(state, worldIn, pos);
    }

    public void updatePower(BlockState state, Level world, BlockPos pos) {
        if (!world.isClientSide) {
            int pow = world.getBestNeighborSignal(pos);
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(Mth.clamp((int)pow, (int)0, (int)15))), 7);
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }
}

