/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.blocks.base.FireMelonSpikedFruitBlock;
import com.mystic.atlantis.blocks.base.NymphDoorBlock;
import com.mystic.atlantis.init.BlockInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireMelonFruitBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<FireMelonFruitBlock> CODEC = FireMelonFruitBlock.simpleCodec(FireMelonFruitBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final BooleanProperty SPIKED = BooleanProperty.create((String)"spiked");
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.box((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), Block.box((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)12.0, (double)11.0), Block.box((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.box((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)12.0, (double)11.0), Block.box((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)12.0, (double)7.0), Block.box((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)12.0, (double)15.0), Block.box((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)};

    public FireMelonFruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(NymphDoorBlock.WATERLOGGED, (Comparable)Boolean.TRUE));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.direct((Object)Blocks.AIR);
        return HolderSet.direct((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return reader.isWaterAt(targetPos);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos targetPos) {
        BlockState targetState = reader.getBlockState(targetPos.relative((Direction)state.getValue((Property)FACING)));
        if (this.isWaterAt(reader, targetPos)) {
            return targetState.is((Block)BlockInit.FIRE_MELON_STEM.get());
        }
        return false;
    }

    public VoxelShape getShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        int age = (Integer)targetState.getValue((Property)AGE);
        switch ((Direction)targetState.getValue((Property)FACING)) {
            case SOUTH: {
                return SOUTH_AABB[age];
            }
            default: {
                return NORTH_AABB[age];
            }
            case WEST: {
                return WEST_AABB[age];
            }
            case EAST: 
        }
        return EAST_AABB[age];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] lookingDirections;
        BlockState targetState = this.defaultBlockState();
        Level reader = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        for (Direction direction : lookingDirections = context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(targetState = (BlockState)targetState.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)reader, clickedPos)) continue;
            return targetState;
        }
        return null;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(NymphDoorBlock.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public BlockState updateShape(BlockState targetState, Direction targetDir, BlockState neighbourState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighbourPos) {
        return targetDir == targetState.getValue((Property)FACING) && !targetState.canSurvive((LevelReader)accessor, targetPos) ? Blocks.WATER.defaultBlockState() : super.updateShape(targetState, targetDir, neighbourState, accessor, targetPos, neighbourPos);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        if ((Integer)targetState.getValue((Property)AGE) == 0) {
            level.setBlock(targetPos, ((FireMelonSpikedFruitBlock)((Object)BlockInit.FIRE_MELON_FRUIT_SPIKED.get())).withPropertiesOf(targetState), 4);
        } else {
            level.setBlock(targetPos, (BlockState)targetState.setValue((Property)AGE, (Comparable)((Integer)targetState.getValue((Property)AGE))), 0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE, NymphDoorBlock.WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

