/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.blocks.base.NymphDoorBlock;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;

public class FireMelonSpikedFruitBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<FireMelonSpikedFruitBlock> CODEC = FireMelonSpikedFruitBlock.simpleCodec(FireMelonSpikedFruitBlock::new);
    public static final IntegerProperty AGE_4;
    public static final IntegerProperty AGE;
    public static final BooleanProperty SPIKED;
    protected static final VoxelShape[] EAST_AABB;
    protected static final VoxelShape[] WEST_AABB;
    protected static final VoxelShape[] NORTH_AABB;
    protected static final VoxelShape[] SOUTH_AABB;

    public FireMelonSpikedFruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SPIKED, (Comparable)Boolean.valueOf(true))).setValue(NymphDoorBlock.WATERLOGGED, (Comparable)Boolean.TRUE));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState targetState) {
        return (Integer)targetState.getValue((Property)AGE) < 4;
    }

    public void randomTick(BlockState targetState, ServerLevel level, BlockPos targetPos, RandomSource random) {
        int age = (Integer)targetState.getValue((Property)AGE);
        if (age < 4 && CommonHooks.canCropGrow((Level)level, (BlockPos)targetPos, (BlockState)targetState, (level.random.nextInt(4) == 0 ? 1 : 0) != 0)) {
            level.setBlock(targetPos, (BlockState)targetState.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)targetPos, (BlockState)targetState);
        }
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.direct((Object)Blocks.AIR);
        return HolderSet.direct((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.getBlockState(targetPos).is(this.getAir());
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(NymphDoorBlock.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        BlockState relativeState = reader.getBlockState(targetPos.relative((Direction)targetState.getValue((Property)FACING)));
        if (this.isWaterAt(reader, targetPos)) {
            return relativeState.is((Block)BlockInit.FIRE_MELON_STEM.get());
        }
        return false;
    }

    public VoxelShape getShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        switch ((Direction)targetState.getValue((Property)FACING)) {
            case SOUTH: {
                return SOUTH_AABB[0];
            }
            default: {
                return NORTH_AABB[0];
            }
            case WEST: {
                return WEST_AABB[0];
            }
            case EAST: 
        }
        return EAST_AABB[0];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState targetState = this.defaultBlockState();
        Level reader = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        for (Direction curLookingDirection : context.getNearestLookingDirections()) {
            if (!curLookingDirection.getAxis().isHorizontal() || !(targetState = (BlockState)targetState.setValue((Property)FACING, (Comparable)curLookingDirection)).canSurvive((LevelReader)reader, clickedPos)) continue;
            return targetState;
        }
        return null;
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighbourState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighbourPos) {
        return curDir == targetState.getValue((Property)FACING) && !targetState.canSurvive((LevelReader)accessor, targetPos) ? Blocks.WATER.defaultBlockState() : super.updateShape(targetState, curDir, neighbourState, accessor, targetPos, neighbourPos);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        level.setBlock(targetPos, (BlockState)targetState.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)targetState.getValue((Property)AGE) + 1)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE, SPIKED, NymphDoorBlock.WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public InteractionResult useWithoutItem(BlockState targetState, Level level, BlockPos targetPos, Player player, BlockHitResult result) {
        ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHandStack.canPerformAction(ItemAbilities.SHEARS_CARVE) && ((Boolean)targetState.getValue((Property)SPIKED)).booleanValue()) {
            if (!level.isClientSide) {
                Direction resultDir = result.getDirection();
                Direction oppositeDir = resultDir.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : resultDir;
                level.playSound(null, targetPos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(targetPos, (BlockState)targetState.setValue((Property)SPIKED, (Comparable)Boolean.valueOf(false)), 11);
                ItemEntity fireMelonSpikeItemEntity = new ItemEntity(level, (double)targetPos.getX() + 0.5 + (double)oppositeDir.getStepX() * 0.65, (double)targetPos.getY() + 0.1, (double)targetPos.getZ() + 0.5 + (double)oppositeDir.getStepZ() * 0.65, new ItemStack((ItemLike)ItemInit.FIRE_MELON_SPIKE.get(), 1));
                fireMelonSpikeItemEntity.setDeltaMovement(0.05 * (double)oppositeDir.getStepX() + level.random.nextDouble() * 0.02, 0.05, 0.05 * (double)oppositeDir.getStepZ() + level.random.nextDouble() * 0.02);
                level.addFreshEntity((Entity)fireMelonSpikeItemEntity);
                mainHandStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, targetPos);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(targetState, level, targetPos, player, result);
    }

    static {
        AGE = AGE_4 = IntegerProperty.create((String)"age", (int)0, (int)4);
        SPIKED = BooleanProperty.create((String)"spiked");
        EAST_AABB = new VoxelShape[]{Block.box((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), Block.box((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)12.0, (double)11.0), Block.box((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)};
        WEST_AABB = new VoxelShape[]{Block.box((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)12.0, (double)11.0), Block.box((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)};
        NORTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)12.0, (double)7.0), Block.box((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)};
        SOUTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)12.0, (double)15.0), Block.box((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)};
    }
}

