/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.inventory.LinguisticMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class LinguisticBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<LinguisticBlock> CODEC = LinguisticBlock.simpleCodec(LinguisticBlock::new);
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.linguistic");

    public LinguisticBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public InteractionResult useWithoutItem(BlockState targetState, Level level, BlockPos targetPos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(targetState.getMenuProvider(level, targetPos));
        player.awardStat(Stats.INTERACT_WITH_LOOM);
        return InteractionResult.CONSUME;
    }

    public MenuProvider getMenuProvider(BlockState targetState, Level arg2, BlockPos arg3) {
        return new SimpleMenuProvider((id, inventory, accessLevel) -> new LinguisticMenu(id, inventory, ContainerLevelAccess.create((Level)arg2, (BlockPos)arg3)), CONTAINER_TITLE);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

