/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LuminescentPrismarine
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public LuminescentPrismarine(BlockBehaviour.Properties settings) {
        super(settings.strength(2.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public BlockState rotate(BlockState targetState, Rotation currentRot) {
        return switch (currentRot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)targetState.getValue(AXIS)) {
                    case X: {
                        yield (BlockState)targetState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)targetState.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield targetState;
            }
            default -> targetState;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }
}

