/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.plants.Seabloom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NymphDoorBlock
extends DoorBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;

    public NymphDoorBlock(BlockBehaviour.Properties settings) {
        super(BlockSetType.OAK, settings.sound(SoundType.WOOD).noOcclusion().requiresCorrectToolForDrops().strength(3.0f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isPathfindable(BlockState targetState, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)targetState.getValue((Property)OPEN);
            case PathComputationType.WATER -> (Boolean)targetState.getValue(WATERLOGGED);
        };
    }

    public InteractionResult useWithoutItem(BlockState targetState, Level level, BlockPos targetPos, Player player, BlockHitResult result) {
        InteractionResult superResult = super.useWithoutItem(targetState, level, targetPos, player, result);
        if (superResult.consumesAction()) {
            level.scheduleTick(targetPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return superResult;
    }

    public void setPlacedBy(Level level, BlockPos targetPos, BlockState targetState, LivingEntity placer, ItemStack curStack) {
        BlockPos above = targetPos.above();
        level.setBlock(above, (BlockState)((BlockState)targetState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(above).getType() == Fluids.WATER)), 3);
    }

    public void neighborChanged(BlockState targetState, Level world, BlockPos targetPos, Block targetBlock, BlockPos fromPos, boolean notify) {
        boolean hasNeighbourSignal = world.hasNeighborSignal(targetPos) || world.hasNeighborSignal(targetPos.relative(targetState.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN));
        super.neighborChanged(targetState, world, targetPos, targetBlock, fromPos, notify);
        if (hasNeighbourSignal && !world.isClientSide && ((Boolean)targetState.getValue(WATERLOGGED)).booleanValue()) {
            world.scheduleTick(targetPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean isWater = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        BlockState targetState = super.getStateForPlacement(ctx);
        if (targetState == null) {
            return null;
        }
        if (isWater) {
            return (BlockState)targetState.setValue(WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return targetState;
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        if (((Boolean)targetState.getValue(WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(targetPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        BlockState newState = super.updateShape(targetState, curDir, neighborState, accessor, targetPos, neighborPos);
        return newState;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public BlockState playerWillDestroy(Level level, BlockPos targetPos, BlockState targetState, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)targetState.getValue((Property)HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (belowState = level.getBlockState(belowPos = targetPos.below())).is(targetState.getBlock()) && belowState.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(belowPos, level.getFluidState(belowPos).getType() == Fluids.WATER ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, belowPos, Block.getId((BlockState)belowState));
        }
        return super.playerWillDestroy(level, targetPos, targetState, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }
}

