/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.datagen.EnchantmentInit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class OceanLanternBlock
extends Block {
    public OceanLanternBlock(BlockBehaviour.Properties settings) {
        super(settings.strength(2.0f, 10.0f).lightLevel(state -> 10).requiresCorrectToolForDrops().sound(SoundType.GLASS));
    }

    public void playerDestroy(Level level, Player player, BlockPos targetPos, BlockState targetState, @Nullable BlockEntity targetTileEntity, ItemStack curStack) {
        super.playerDestroy(level, player, targetPos, targetState, targetTileEntity, curStack);
        if (EnchantmentHelper.getEnchantmentLevel(EnchantmentInit.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), (LivingEntity)player) == 0) {
            level.removeBlock(targetPos, false);
        }
    }
}

