/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.base.NymphDoorBlock;
import com.mystic.atlantis.datagen.EnchantmentInit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PearlBlock
extends HalfTransparentBlock
implements SimpleWaterloggedBlock {
    public PearlBlock(BlockBehaviour.Properties settings) {
        super(settings.strength(2.0f, 5.0f).requiresCorrectToolForDrops().lightLevel(state -> 5).noOcclusion().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(NymphDoorBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    public boolean useShapeForLightOcclusion(BlockState targetState) {
        return true;
    }

    public int getLightBlock(BlockState targetState, BlockGetter getter, BlockPos targetPos) {
        return 125;
    }

    public void playerDestroy(Level level, Player player, BlockPos targetPos, BlockState targetState, @Nullable BlockEntity targetTileEntity, ItemStack curStack) {
        super.playerDestroy(level, player, targetPos, targetState, targetTileEntity, curStack);
        if (EnchantmentHelper.getTagEnchantmentLevel(EnchantmentInit.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), (ItemStack)curStack) == 0) {
            level.removeBlock(targetPos, false);
            return;
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NymphDoorBlock.WATERLOGGED});
    }
}

