/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.particles.ModParticleTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushBubbleColumnBlock
extends Block
implements BucketPickup {
    public static final DirectionProperty PUSH = BlockStateProperties.FACING;
    public static final IntegerProperty DECAY = IntegerProperty.create((String)"decay", (int)0, (int)30);

    public PushBubbleColumnBlock(BlockBehaviour.Properties settings) {
        super(settings.replaceable());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DECAY, (Comparable)Integer.valueOf(0)));
    }

    public void entityInside(BlockState targetState, Level level, BlockPos targetPos, Entity targetEntity) {
        BlockState aboveState = level.getBlockState(targetPos.above());
        if (aboveState.isAir()) {
            this.onBubbleColumnSurfaceCollision(targetEntity, (Direction)targetState.getValue((Property)PUSH));
            if (!level.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)targetPos.getX() + level.random.nextDouble(), (double)(targetPos.getY() + 1), (double)targetPos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, (double)targetPos.getX() + level.random.nextDouble(), (double)(targetPos.getY() + 1), (double)targetPos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.02);
                }
            }
        } else {
            this.onBubbleColumnCollision(targetEntity, (Direction)targetState.getValue((Property)PUSH));
        }
    }

    public static void update(ServerLevel level, BlockPos pos) {
        block0: for (Direction direction : Direction.values()) {
            BlockPos.MutableBlockPos bubblePos = pos.mutable();
            for (int i = 1; i < (Integer)AtlantisConfig.CONFIG.maxDistanceOfPushBubbleColumn.get(); ++i) {
                bubblePos.move(direction);
                BlockState previousState = level.getBlockState(bubblePos.relative(direction.getOpposite()));
                FluidState previousFluidState = level.getFluidState(bubblePos.relative(direction.getOpposite()));
                BlockState targetState = level.getBlockState((BlockPos)bubblePos);
                BlockState newState = PushBubbleColumnBlock.getBubbleState(previousState, previousFluidState, targetState, direction);
                if (newState == null) continue block0;
                level.setBlock((BlockPos)bubblePos, newState, 3);
            }
        }
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockState targetState) {
        return Fluids.WATER.getSource(false);
    }

    private static boolean isStillWater(BlockState state) {
        return state.is(Blocks.WATER) && state.getFluidState().getAmount() >= 8 && state.getFluidState().isSource();
    }

    private static BlockState getBubbleState(BlockState previousState, FluidState fluidState, BlockState targetState, Direction curDir) {
        if (targetState.is((Block)BlockInit.BUBBLE_MAGMA.get())) {
            return null;
        }
        if (previousState.is((Block)BlockInit.BUBBLE_MAGMA.get())) {
            if (PushBubbleColumnBlock.isStillWater(targetState) || targetState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
                return (BlockState)((BlockState)((PushBubbleColumnBlock)((Object)BlockInit.PUSH_BUBBLE_COLUMN.get())).defaultBlockState().setValue((Property)PUSH, (Comparable)curDir)).setValue((Property)DECAY, (Comparable)((Integer)AtlantisConfig.CONFIG.maxDistanceOfPushBubbleColumn.get()));
            }
        } else if (previousState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
            if ((Integer)previousState.getValue((Property)DECAY) == 0) {
                return Blocks.WATER.defaultBlockState();
            }
            if (!((Direction)previousState.getValue((Property)PUSH)).equals((Object)curDir)) {
                return null;
            }
            if (PushBubbleColumnBlock.isStillWater(targetState) || targetState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
                return (BlockState)((BlockState)((PushBubbleColumnBlock)((Object)BlockInit.PUSH_BUBBLE_COLUMN.get())).defaultBlockState().setValue((Property)PUSH, (Comparable)curDir)).setValue((Property)DECAY, (Comparable)Integer.valueOf((Integer)previousState.getValue((Property)DECAY) - 1));
            }
        } else if ((fluidState.isEmpty() || PushBubbleColumnBlock.isStillWater(previousState)) && (PushBubbleColumnBlock.isStillWater(targetState) || targetState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()))) {
            return Blocks.WATER.defaultBlockState();
        }
        return null;
    }

    public void animateTick(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        double x = targetPos.getX();
        double y = targetPos.getY();
        double z = targetPos.getZ();
        switch ((Direction)targetState.getValue((Property)PUSH)) {
            case UP: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_UP.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
                break;
            }
            case DOWN: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_DOWN.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_NORTH.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_SOUTH.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_EAST.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.addAlwaysVisibleParticle((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_WEST.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
            }
        }
        if (random.nextInt(200) == 0) {
            level.playLocalSound(x, y, z, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion pExplosion) {
        if (!level.isClientSide()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor level, BlockPos targetPos, BlockPos neighborPos) {
        level.scheduleTick(targetPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        if (!this.canSurvive(targetState, (LevelReader)level, targetPos) && !neighborState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()) && PushBubbleColumnBlock.isStillWater(neighborState)) {
            level.scheduleTick(targetPos, (Block)this, 1);
        }
        return super.updateShape(targetState, curDir, neighborState, level, targetPos, neighborPos);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        Direction pushDir = (Direction)targetState.getValue((Property)PUSH);
        BlockState relativeState = reader.getBlockState(targetPos.relative(pushDir.getOpposite()));
        if (relativeState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()) && ((Direction)relativeState.getValue((Property)PUSH)).equals((Object)pushDir)) {
            return (Integer)relativeState.getValue((Property)DECAY) >= 0;
        }
        return relativeState.is((Block)BlockInit.BUBBLE_MAGMA.get());
    }

    public VoxelShape getShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState targetState) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DECAY, PUSH});
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos targetPos, BlockState targetState) {
        level.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)Items.WATER_BUCKET);
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public void onBubbleColumnSurfaceCollision(Entity targetEntity, Direction dragDir) {
        this.adjustEntityMovement(targetEntity, dragDir, (Double)AtlantisConfig.CONFIG.magmaAcceleration.get(), (Double)AtlantisConfig.CONFIG.magmaThreshold.get());
    }

    public void adjustEntityMovement(Entity entity, Direction dragDir, double magnitude, double limit) {
        Vec3 dMovement = entity.getDeltaMovement();
        magnitude *= (double)dragDir.getAxisDirection().getStep();
        limit *= (double)dragDir.getAxisDirection().getStep();
        switch (dragDir.getAxis()) {
            case X: {
                entity.setDeltaMovement(this.getAdjustedMagLimit(dragDir.getAxisDirection(), magnitude + dMovement.x, limit), dMovement.y, dMovement.z);
                break;
            }
            case Y: {
                entity.setDeltaMovement(dMovement.x, this.getAdjustedMagLimit(dragDir.getAxisDirection(), magnitude + dMovement.y, limit), dMovement.z);
                break;
            }
            case Z: {
                entity.setDeltaMovement(dMovement.x, dMovement.y, this.getAdjustedMagLimit(dragDir.getAxisDirection(), magnitude + dMovement.z, limit));
            }
        }
    }

    public double getAdjustedMagLimit(Direction.AxisDirection curAxisDir, double magnitude, double limit) {
        if (curAxisDir == Direction.AxisDirection.POSITIVE) {
            return Math.max(magnitude, limit);
        }
        return Math.min(magnitude, limit);
    }

    public void onBubbleColumnCollision(Entity targetEntity, Direction dragDir) {
        this.adjustEntityMovement(targetEntity, dragDir, 0.06, 0.7);
        targetEntity.fallDistance = 0.0f;
    }
}

