/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.blockentities.plants;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.blocks.blockentities.plants.GeneralPlantBlockEntity;
import com.mystic.atlantis.blocks.plants.Seabloom;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class GeneralPlantBlock<T extends GeneralPlantBlockEntity<?>>
extends BushBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    private final Supplier<BlockEntityType<T>> type;

    public GeneralPlantBlock(Supplier<BlockEntityType<T>> type) {
        super(BlockBehaviour.Properties.of().noOcclusion().noCollission().sound(SoundType.GRASS).strength(0.3f, 0.5f).randomTicks());
        this.type = type;
        this.defaultBlockState().setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.TRUE);
    }

    public boolean canPlaceOn(BlockState targetState) {
        return targetState.getBlock() == Blocks.GRAVEL || targetState.getBlock() == Blocks.SANDSTONE || targetState.getBlock() == Blocks.GRASS_BLOCK || targetState.getBlock() == Blocks.DIRT || targetState.getBlock() == Blocks.SAND;
    }

    public boolean canPlaceBlockAt(LevelReader reader, BlockPos targetPos) {
        BlockState belowState = reader.getBlockState(targetPos.below());
        if (reader.getBlockState(targetPos.above()).is(Blocks.WATER)) {
            return true;
        }
        return !this.canPlaceOn(belowState);
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(Seabloom.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public RenderShape getRenderShape(BlockState targetState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Seabloom.WATERLOGGED});
    }

    protected MapCodec<? extends BushBlock> codec() {
        return GeneralPlantBlock.simpleCodec(properties -> new GeneralPlantBlock<T>(this.type));
    }

    protected boolean mayPlaceOn(BlockState targetState, BlockGetter getter, BlockPos targetPos) {
        return !targetState.getCollisionShape(getter, targetPos).getFaceShape(Direction.UP).isEmpty() || targetState.isFaceSturdy(getter, targetPos, Direction.UP);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        BlockPos below = targetPos.below();
        if (this.isWaterAt(reader, targetPos)) {
            return this.mayPlaceOn(reader.getBlockState(below), (BlockGetter)reader, below);
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState targetPos = context.getLevel().getBlockState(context.getClickedPos());
        if (targetPos.is((Block)this)) {
            return targetPos;
        }
        FluidState targetFluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean isWater = targetFluidState.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.getBlockState(targetPos).is(this.getAir()) || !this.canPlaceBlockAt(reader, targetPos);
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.direct((Object)Blocks.AIR);
        return HolderSet.direct((Holder[])new Holder[]{airHolderSet});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.type.get().create(pos, state);
    }
}

