/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.plants;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.init.BlockInit;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NymphSaplingBlock
extends SaplingBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public NymphSaplingBlock(BlockBehaviour.Properties settings) {
        super(TreeGrower.OAK, settings.randomTicks().strength(0.2f, 0.4f).sound(SoundType.GRASS).noCollission().noOcclusion());
        ComposterBlock.COMPOSTABLES.put((Object)this, 0.3f);
        ((BlockState)this.defaultBlockState().setValue(WATERLOGGED, (Comparable)Boolean.TRUE)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0));
    }

    public boolean useShapeForLightOcclusion(BlockState targetState) {
        return true;
    }

    protected boolean mayPlaceOn(BlockState targetState, BlockGetter worldIn, BlockPos targetPos) {
        return !targetState.getCollisionShape(worldIn, targetPos).getFaceShape(Direction.UP).isEmpty() || targetState.isFaceSturdy(worldIn, targetPos, Direction.UP);
    }

    public boolean canSurvive(BlockState targetState, LevelReader world, BlockPos targetPos) {
        BlockPos below = targetPos.below();
        if (this.isWaterAt(world, targetPos)) {
            return this.mayPlaceOn(world.getBlockState(below), (BlockGetter)world, below);
        }
        return false;
    }

    public VoxelShape getShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState targetState = context.getLevel().getBlockState(context.getClickedPos());
        if (targetState.is((Block)this)) {
            return targetState;
        }
        FluidState targetFluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean isWater = targetFluidState.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    private void growTree(ServerLevel level, ChunkGenerator generator, BlockPos targetPos, BlockState targetState, RandomSource random) {
        if (level.registryAccess().registry(Registries.CONFIGURED_FEATURE).isPresent()) {
            ConfiguredFeature configuredAtlanteanTreeFeature = (ConfiguredFeature)((Registry)level.registryAccess().registry(Registries.CONFIGURED_FEATURE).get()).get(Atlantis.id("atlantean_tree_configured"));
            BlockState legacyTargetState = level.getFluidState(targetPos).createLegacyBlock();
            level.setBlock(targetPos, legacyTargetState, 4);
            if (configuredAtlanteanTreeFeature != null) {
                if (configuredAtlanteanTreeFeature.place((WorldGenLevel)level, generator, random, targetPos)) {
                    if (level.getBlockState(targetPos) == legacyTargetState) {
                        level.sendBlockUpdated(targetPos, targetState, legacyTargetState, 2);
                    }
                } else {
                    level.setBlock(targetPos, targetState, 4);
                }
            }
        }
    }

    public void advanceTree(ServerLevel level, BlockPos targetPos, BlockState targetState, RandomSource random) {
        if ((Integer)targetState.getValue((Property)STAGE) == 0) {
            level.setBlock(targetPos, (BlockState)targetState.cycle((Property)STAGE), 4);
        } else {
            this.growTree(level, level.getChunkSource().getGenerator(), targetPos, targetState, random);
        }
    }

    public boolean onTreeGrow(BlockState targetState, LevelReader reader, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource random, BlockPos targetPos, TreeConfiguration config) {
        return true;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, STAGE});
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.direct((Object)Blocks.AIR);
        return HolderSet.direct((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.getBlockState(targetPos).is(this.getAir()) || !this.canPlaceBlockAt(reader, targetPos);
    }

    public boolean canPlaceOn(BlockState targetState) {
        return targetState.getBlock() == BlockInit.SEABED.get() || targetState.getBlock() == Blocks.GRAVEL || targetState.getBlock() == Blocks.SANDSTONE || targetState.getBlock() == Blocks.GRASS_BLOCK || targetState.getBlock() == Blocks.DIRT || targetState.getBlock() == Blocks.SAND;
    }

    public boolean canPlaceBlockAt(LevelReader reader, BlockPos targetPos) {
        BlockState targetState = reader.getBlockState(targetPos.below());
        if (reader.getBlockState(targetPos.above()).is(Blocks.WATER)) {
            return this.canPlaceOn(targetState);
        }
        return false;
    }
}

