/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.shells;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class OysterShellBlock
extends RotatedPillarBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public OysterShellBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.BONE_BLOCK));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public BlockState rotate(BlockState targetState, Rotation currentRot) {
        switch (currentRot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)targetState.getValue(AXIS)) {
                    case Direction.Axis.X -> (BlockState)targetState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)targetState.setValue(AXIS, (Comparable)Direction.Axis.X);
                    default -> targetState;
                };
            }
        }
        return targetState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }
}

