/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumBulbBlock;
import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.datagen.AtlantisMainProvider;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class AtlantisBlockStateProvider
extends AtlantisMainProvider.Proxied {
    public AtlantisBlockStateProvider(AtlantisMainProvider provider) {
        super(provider);
    }

    @Override
    public void registerStatesAndModels() {
        BlockType.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(this::registerBlockFamily);
        BlockInit.ANCIENT_CUPRUM.values().forEach(this::registerTrialGroup);
        BlockInit.COLORED_SHELL_BLOCKS.forEach((color, block) -> this.tintedCube((Block)block.get(), String.valueOf(color) + "_shell_block", "block/colored_shell_faces", "block/colored_shell_faces", "block/colored_shell_front", "block/colored_shell_faces", "block/colored_shell_side", "block/colored_shell_side"));
        BlockInit.CRACKED_SHELL_BLOCKS.forEach((color, block) -> this.tintedCube((Block)block.get(), "cracked_" + String.valueOf(color) + "_shell", "block/colored_shell_faces_cracked", "block/colored_shell_faces_cracked", "block/colored_shell_front_cracked", "block/colored_shell_faces_cracked", "block/colored_shell_side_cracked", "block/colored_shell_side_cracked"));
        BlockInit.MOSSY_SHELL_BLOCKS.forEach((color, block) -> this.tintedOverlayBlock((Block)block.get(), "mossy_" + String.valueOf(color) + "_shell_block", "block/colored_shell_faces", "block/colored_shell_faces", "block/colored_shell_front", "block/colored_shell_faces", "block/colored_shell_side", "block/colored_shell_side", "block/mossy_shell_faces_overlay", "block/mossy_shell_faces_overlay", "block/mossy_shell_front_overlay", "block/mossy_shell_faces_overlay", "block/mossy_shell_side_overlay", "block/mossy_shell_side_overlay"));
        BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.forEach((color, block) -> this.tintedOverlayBlock((Block)block.get(), "cracked_mossy_" + String.valueOf(color) + "_shell", "block/colored_shell_faces_cracked", "block/colored_shell_faces_cracked", "block/colored_shell_front_cracked", "block/colored_shell_faces_cracked", "block/colored_shell_side_cracked", "block/colored_shell_side_cracked", "block/mossy_shell_faces_overlay", "block/mossy_shell_faces_overlay", "block/mossy_shell_front_overlay", "block/mossy_shell_faces_overlay", "block/mossy_shell_side_overlay", "block/mossy_shell_side_overlay"));
        BlockInit.DYED_LINGUISTICS.forEach((glyph, registryObjectMap) -> registryObjectMap.forEach((color, block) -> {
            if (glyph.equals((Object)LinguisticGlyph.BLANK)) {
                this.tintedCube((Block)block.get(), String.valueOf(color) + "_linguistic_glyph", "block/blank/blank_top", "block/blank/blank_bottom", "block/blank/blank_side", "block/blank/blank_side", "block/blank/blank_side", "block/blank/blank_side");
            } else if (glyph.equals((Object)LinguisticGlyph.S) || glyph.equals((Object)LinguisticGlyph.N)) {
                this.tintedCube((Block)block.get(), String.valueOf(color) + "_linguistic_glyph" + String.valueOf(glyph), "block/blank/blank" + String.valueOf(glyph) + "_top", "block/blank/blank_bottom", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side");
            } else {
                this.tintedCube((Block)block.get(), String.valueOf(color) + "_linguistic_glyph" + String.valueOf(glyph), "block/blank/blank_top" + String.valueOf(glyph), "block/blank/blank_bottom", "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph));
            }
        }));
        BlockInit.NON_LINGUISTICS.forEach((glyph, block) -> {
            if (glyph.equals((Object)LinguisticGlyph.BLANK)) {
                this.tintedCube((Block)block.get(), "linguistic_glyph" + String.valueOf(glyph), "block/blank/blank_top", "block/blank/blank_bottom", "block/blank/blank_side", "block/blank/blank_side", "block/blank/blank_side", "block/blank/blank_side");
            } else if (glyph.equals((Object)LinguisticGlyph.S) || glyph.equals((Object)LinguisticGlyph.N)) {
                this.tintedCube((Block)block.get(), "linguistic_glyph" + String.valueOf(glyph), "block/blank/blank" + String.valueOf(glyph) + "_top", "block/blank/blank_bottom", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side", "block/blank/blank" + String.valueOf(glyph) + "_side");
            } else {
                this.tintedCube((Block)block.get(), "linguistic_glyph" + String.valueOf(glyph), "block/blank/blank_top" + String.valueOf(glyph), "block/blank/blank_bottom", "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph), "block/blank/blank_side" + String.valueOf(glyph));
            }
        });
        this.tintedCube((Block)BlockInit.WATERFALL_BLOCK.get(), "waterfall_block", "block/waterfall_block_top", "block/waterfall_block_bottom", "block/waterfall_block_front", "block/waterfall_block_side", "block/waterfall_block_side", "block/waterfall_block_side");
        this.tintedCube((Block)BlockInit.WAVE_BLOCK.get(), "wave_block", "block/wave_block_top", "block/wave_block_top", "block/wave_block_side", "block/wave_block_side", "block/wave_block_side", "block/wave_block_side");
        this.registerBlockItem((Block)BlockInit.ALGAE_BLOCK.get());
        this.tintedCube((Block)BlockInit.CRYSTAL_TRANSFERENCE_BLOCK.get(), "crystal_transference_block", "block/crystal_transference_block_top", "block/crystal_transference_block_bottom", "block/crystal_transference_block_side", "block/crystal_transference_block_side", "block/crystal_transference_block_side", "block/crystal_transference_block_side");
        this.tintedCube((Block)BlockInit.COCONUT.get(), "coconut", "block/coconut_side", "block/coconut_side", "block/coconut", "block/coconut_side", "block/coconut_side", "block/coconut_side");
        this.tintedCube((Block)BlockInit.CARVED_COCONUT.get(), "carved_coconut", "block/coconut_side", "block/coconut_side", "block/carved_coconut", "block/coconut_side", "block/coconut_side", "block/coconut_side");
        this.tintedCube((Block)BlockInit.SATIRE_LANTERN.get(), "satire_lantern", "block/coconut_side", "block/coconut_side", "block/satire_lantern", "block/coconut_side", "block/coconut_side", "block/coconut_side");
        this.tintedCube((Block)BlockInit.PALM_LOG.get(), "palm_log", "block/palm_log_top", "block/palm_log_top", "block/palm_log", "block/palm_log", "block/palm_log", "block/palm_log");
        this.tintedCube((Block)BlockInit.STRIPPED_PALM_LOG.get(), "stripped_palm_log", "block/stripped_palm_log_top", "block/stripped_palm_log_top", "block/stripped_palm_log", "block/stripped_palm_log", "block/stripped_palm_log", "block/stripped_palm_log");
        this.tintedCube((Block)BlockInit.NYMPH_LOG.get(), "nymph_log", "block/nymph_log_top", "block/nymph_log_top", "block/nymph_log", "block/nymph_log", "block/nymph_log", "block/nymph_log");
        this.tintedCube((Block)BlockInit.STRIPPED_NYMPH_LOG.get(), "stripped_nymph_log", "block/stripped_nymph_log_top", "block/stripped_nymph_log_top", "block/stripped_nymph_log", "block/stripped_nymph_log", "block/stripped_nymph_log", "block/stripped_nymph_log");
        this.registerSign((StandingSignBlock)BlockInit.PALM_SIGN.get(), (WallSignBlock)BlockInit.PALM_WALL_SIGN.get(), (Block)BlockInit.PALM_PLANKS.block().get());
        this.registerSign((StandingSignBlock)BlockInit.NYMPH_SIGN.get(), (WallSignBlock)BlockInit.NYMPH_WALL_SIGN.get(), (Block)BlockInit.NYMPH_PLANKS.block().get());
        this.tintedCube((Block)BlockInit.OYSTER_SHELL_BLOCK.get(), "oyster_shell_block", "block/oyster_shell_faces", "block/oyster_shell_faces", "block/oyster_shell_side", "block/oyster_shell_side", "block/oyster_shell_side", "block/oyster_shell_side");
        this.tintedCube((Block)BlockInit.MOSSY_NAUTILUS_SHELL.get(), "mossy_nautilus_shell", "block/mossy_nautilus_shell_faces", "block/mossy_nautilus_shell_faces", "block/mossy_nautilus_shell_front", "block/mossy_nautilus_shell_faces", "block/mossy_nautilus_shell_side", "block/mossy_nautilus_shell_side");
        this.tintedCube((Block)BlockInit.MOSSY_OYSTER_SHELL.get(), "mossy_oyster_shell", "block/mossy_oyster_shell_faces", "block/mossy_oyster_shell_faces", "block/mossy_oyster_shell_side", "block/mossy_oyster_shell_side", "block/mossy_oyster_shell_side", "block/mossy_oyster_shell_side");
        this.tintedCube((Block)BlockInit.CRACKED_MOSSY_NAUTILUS_SHELL.get(), "cracked_mossy_nautilus_shell", "block/cracked_mossy_nautilus_shell_faces", "block/cracked_mossy_nautilus_shell_faces", "block/cracked_mossy_nautilus_shell_front", "block/cracked_mossy_nautilus_shell_faces", "block/cracked_mossy_nautilus_shell_side", "block/cracked_mossy_nautilus_shell_side");
        this.tintedCube((Block)BlockInit.NAUTILUS_SHELL_BLOCK.get(), "nautilus_shell_block", "block/nautilus_shell_faces", "block/nautilus_shell_faces", "block/nautilus_shell_front", "block/nautilus_shell_faces", "block/nautilus_shell_faces", "block/nautilus_shell_side");
        this.tintedCube((Block)BlockInit.CRACKED_NAUTILUS_SHELL.get(), "cracked_nautilus_shell", "block/cracked_nautilus_shell_faces", "block/cracked_nautilus_shell_faces", "block/cracked_nautilus_shell_front", "block/cracked_nautilus_shell_faces", "block/cracked_nautilus_shell_faces", "block/cracked_nautilus_shell_side");
        this.tintedCube((Block)BlockInit.CRACKED_OYSTER_SHELL.get(), "cracked_oyster_shell", "block/cracked_oyster_shell_faces", "block/cracked_oyster_shell_faces", "block/cracked_oyster_shell_side", "block/cracked_oyster_shell_side", "block/cracked_oyster_shell_side", "block/cracked_oyster_shell_side");
        this.tintedCube((Block)BlockInit.CRACKED_MOSSY_OYSTER_SHELL.get(), "cracked_mossy_oyster_shell", "block/cracked_mossy_oyster_shell_faces", "block/cracked_mossy_oyster_shell_faces", "block/cracked_mossy_oyster_shell_side", "block/cracked_mossy_oyster_shell_side", "block/cracked_mossy_oyster_shell_side", "block/cracked_mossy_oyster_shell_side");
        this.tintedCube((Block)BlockInit.SODIUM_BOMB.get(), "sodium_bomb", "block/sodium_bomb_top", "block/sodium_bomb_bottom", "block/sodium_bomb_side", "block/sodium_bomb_side", "block/sodium_bomb_side", "block/sodium_bomb_side");
        this.registerBlockItem((Block)BlockInit.SEASALT_CHUNK.get());
        this.registerBlockItem((Block)BlockInit.SUNKEN_GRAVEL.get());
        this.registerBlockItem((Block)BlockInit.CRACKED_GLOWSTONE.get());
        this.registerBlockItem((Block)BlockInit.DEAD_GLOWSTONE.get());
        this.registerBlockItem((Block)BlockInit.ALGAE_DETRITUS_STONE.get());
        this.registerBlockItem((Block)BlockInit.DETRITUS_SANDSTONE.get());
        this.registerBlockItem((Block)BlockInit.LUMINESCENT_PRISMARINE.get());
        this.registerBlockItem((Block)BlockInit.BUBBLE_MAGMA.get());
        this.simpleBlock((Block)BlockInit.PALM_LEAVES.get(), (ModelFile)new ModelFile.ExistingModelFile(Atlantis.id("block/palm_leaves"), this.itemModels().existingFileHelper));
        this.registerBlockItem((Block)BlockInit.NYMPH_LEAVES.get());
        this.registerBlockItem((Block)BlockInit.AQUAMARINE_ORE.get());
        this.registerBlockItem((Block)BlockInit.DEEPSLATE_AQUAMARINE_ORE.get());
        this.registerBlockItem((Block)BlockInit.SEABED.get());
        this.registerBlockItem((Block)BlockInit.OCEAN_LANTERN.get());
        this.registerBlockItem((Block)BlockInit.SURGE_LANTERN.get());
        this.registerBlockItem((Block)BlockInit.ATLANTEAN_CORE.get());
        this.registerBlockItem((Block)BlockInit.BLOCK_OF_AQUAMARINE.get());
        this.registerBlockItem((Block)BlockInit.CHISELED_GOLDEN_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.CHISELED_GOLDEN_AQUAMARINE.get());
        this.registerBlockItem((Block)BlockInit.BLACK_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.BLUE_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.BROWN_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.CYAN_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.GRAY_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.GREEN_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.LIGHT_BLUE_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.LIGHT_GRAY_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.LIME_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.MAGENTA_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.ORANGE_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.PINK_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.PURPLE_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.RED_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.WHITE_PEARL_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.YELLOW_PEARL_BLOCK.get());
        this.simpleCross((Block)BlockInit.SEABLOOM.get(), "seabloom", "block/seabloom");
        this.simpleCross((Block)BlockInit.RED_SEABLOOM.get(), "red_seabloom", "block/red_seabloom");
        this.simpleCross((Block)BlockInit.YELLOW_SEABLOOM.get(), "yellow_seabloom", "block/yellow_seabloom");
        this.simpleCross((Block)BlockInit.PURPLE_SEASHROOM.get(), "purple_seashroom", "block/purple_seashroom");
        this.simpleCross((Block)BlockInit.YELLOW_SEASHROOM.get(), "yellow_seashroom", "block/yellow_seashroom");
        this.registerBlockItem((Block)BlockInit.AQUATIC_POWER_STONE.get());
        this.registerBlockItem((Block)BlockInit.HARDENED_CALCITE_BLOCK.get());
        this.simpleBlock((Block)BlockInit.PUSH_BUBBLE_COLUMN.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("block/air")));
        this.registerBlockItem((Block)BlockInit.CHISELED_AQUAMARINE_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get());
        this.registerBlockItem((Block)BlockInit.ANCIENT_CUPRUM_ORE.get());
        this.registerBlockItem((Block)BlockInit.DEEPSLATE_ANCIENT_CUPRUM_ORE.get());
        this.simpleCross((Block)BlockInit.NYMPH_SAPLING.get(), "nymph_sapling", "block/nymph_sapling");
        this.simpleCross((Block)BlockInit.PALM_SAPLING.get(), "palm_sapling", "block/palm_sapling");
        this.tintedCube((Block)BlockInit.COQUINA.get(), "coquina", "block/coquina_top", "block/coquina_top", "block/coquina", "block/coquina", "block/coquina", "block/coquina");
        this.tintedCube((Block)BlockInit.LINGUISTIC_TABLE.get(), "linguistic_table", "block/linguistic_table_top", "block/linguistic_table_bottom", "block/linguistic_table_side_1", "block/linguistic_table_side", "block/linguistic_table_side_0", "block/linguistic_table_side");
        this.tintedCube((Block)BlockInit.WRITING_TABLE.get(), "writing_table", "block/writing_table_top", "block/nymph_planks", "block/writing_table_side", "block/writing_table_side_2", "block/writing_table_side_0", "block/writing_table_side_1");
        this.simpleBlock((Block)BlockInit.ORICHALCUM_BLOCK.get());
    }

    private void registerTrialGroup(TrailsGroup group) {
        this.registerBlockItem((Block)group.block().get());
        this.registerBlockItem((Block)group.chiseled().get());
        this.registerBlockItem((Block)group.cut().get());
        this.registerSlab((SlabBlock)group.cut_slab().get(), (Block)group.cut().get());
        this.registerStairs((StairBlock)group.cut_stairs().get(), (Block)group.cut().get());
        this.registerTrapDoor((TrapDoorBlock)group.trapdoor().get());
        this.registerDoor((DoorBlock)group.door().get());
        this.registerBlockItem((Block)group.grate().get());
        this.registerBulb((Block)group.bulb().get());
        this.registerBlockItem((Block)group.waxed_block().get(), (Block)group.block().get());
        this.registerBlockItem((Block)group.waxed_chiseled().get(), (Block)group.chiseled().get());
        this.registerBlockItem((Block)group.waxed_cut().get(), (Block)group.cut().get());
        this.registerSlab((SlabBlock)group.waxed_cut_slab().get(), (Block)group.cut().get());
        this.registerStairs((StairBlock)group.waxed_cut_stairs().get(), (Block)group.cut().get());
        this.registerTrapDoor((TrapDoorBlock)group.waxed_trapdoor().get(), (Block)group.trapdoor().get());
        this.registerDoor((DoorBlock)group.waxed_door().get(), (DoorBlock)group.door().get());
        this.registerBlockItem((Block)group.waxed_grate().get(), (Block)group.grate().get());
        this.registerBulb((Block)group.waxed_bulb().get(), (Block)group.bulb().get());
    }

    private void registerBulb(Block block) {
        this.registerBulb(block, block);
    }

    private void registerBulb(Block bulb, Block texture) {
        ResourceLocation unlit = this.blockTexture(texture).withSuffix("_unlit");
        ResourceLocation lit = this.blockTexture(texture).withSuffix("_lit");
        ResourceLocation unlit_powered = this.blockTexture(texture).withSuffix("_unlit_powered");
        ResourceLocation lit_powered = this.blockTexture(texture).withSuffix("_lit_powered");
        this.getVariantBuilder(bulb).partialState().with((Property)WeatheringCuprumBulbBlock.LIT, (Comparable)Boolean.valueOf(false)).with((Property)WeatheringCuprumBulbBlock.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile(unlit))}).partialState().with((Property)WeatheringCuprumBulbBlock.LIT, (Comparable)Boolean.valueOf(false)).with((Property)WeatheringCuprumBulbBlock.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile(unlit_powered))}).partialState().with((Property)WeatheringCuprumBulbBlock.LIT, (Comparable)Boolean.valueOf(true)).with((Property)WeatheringCuprumBulbBlock.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile(lit))}).partialState().with((Property)WeatheringCuprumBulbBlock.LIT, (Comparable)Boolean.valueOf(true)).with((Property)WeatheringCuprumBulbBlock.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile(lit_powered))});
        this.simpleBlockItem(bulb, (ModelFile)new ModelFile.UncheckedModelFile(unlit));
    }

    private void registerBlockFamily(BlockFamily family) {
        this.registerBlockItem(family.getBaseBlock());
        family.getVariants().keySet().forEach(variant -> this.processVariant((BlockFamily.Variant)variant, family));
    }

    private void registerBlockItem(Block block) {
        this.registerBlockItem(block, block);
    }

    private void simpleCross(Block block, String name, String texture) {
        this.simpleBlock(block, (ModelFile)this.models().cross(name, this.modLoc(texture)));
    }

    private void registerBlockItem(Block block, Block texture) {
        this.simpleBlockWithItem(block, this.cubeAll(texture));
    }

    private void processVariant(BlockFamily.Variant variant, BlockFamily family) {
        Block original = family.getBaseBlock();
        Block variantTarget = (Block)family.getVariants().get(variant);
        switch (variant) {
            case BUTTON: {
                this.registerButton(variantTarget, original);
                break;
            }
            case CHISELED: 
            case CRACKED: 
            case CUT: {
                this.simpleBlockWithItem(variantTarget, this.cubeAll(variantTarget));
                break;
            }
            case DOOR: {
                this.registerDoor((DoorBlock)variantTarget);
                break;
            }
            case FENCE_GATE: {
                this.registerGate((FenceGateBlock)variantTarget, (FenceBlock)family.get(BlockFamily.Variant.FENCE), original);
                break;
            }
            case FENCE: {
                this.registerFence((FenceBlock)variantTarget, original);
                break;
            }
            case SIGN: {
                this.registerSign((StandingSignBlock)variantTarget, (WallSignBlock)family.get(BlockFamily.Variant.WALL_SIGN), original);
                break;
            }
            case SLAB: {
                this.registerSlab((SlabBlock)variantTarget, original);
                break;
            }
            case STAIRS: {
                this.registerStairs((StairBlock)variantTarget, original);
                break;
            }
            case PRESSURE_PLATE: {
                this.registerPressurePlate((PressurePlateBlock)variantTarget, original);
                break;
            }
            case TRAPDOOR: {
                this.registerTrapDoor((TrapDoorBlock)variantTarget, original);
                break;
            }
            case WALL: {
                this.registerWall((WallBlock)variantTarget, original);
            }
        }
    }

    private void registerStairs(StairBlock stairs, Block texturedBlock) {
        ResourceLocation texture = ModelLocationUtils.getModelLocation((Block)texturedBlock);
        this.stairsBlock(stairs, texture);
        this.simpleBlockItem((Block)stairs, (ModelFile)this.itemModels().stairs("block/" + this.key((Block)stairs).getPath(), texture, texture, texture));
    }

    private void registerSlab(SlabBlock slab, Block texturedBlock) {
        ResourceLocation texture = ModelLocationUtils.getModelLocation((Block)texturedBlock);
        this.slabBlock(slab, texture, texture);
        this.simpleBlockItem((Block)slab, (ModelFile)this.itemModels().slab("block/" + this.key((Block)slab).getPath(), texture, texture, texture));
    }

    private void registerWall(WallBlock wall, Block texturedBlock) {
        ResourceLocation texture = ModelLocationUtils.getModelLocation((Block)texturedBlock);
        this.wallBlock(wall, texture);
        this.simpleBlockItem((Block)wall, (ModelFile)this.itemModels().wallInventory("block/" + this.key((Block)wall).getPath(), texture));
    }

    private void registerFence(FenceBlock fence, Block block) {
        ResourceLocation texture = block == null ? ModelLocationUtils.getModelLocation((Block)fence) : ModelLocationUtils.getModelLocation((Block)block);
        this.fenceBlock(fence, texture);
        this.simpleBlockItem((Block)fence, (ModelFile)this.itemModels().fenceInventory("block/" + this.key((Block)fence).getPath(), texture));
    }

    private void registerGate(FenceGateBlock gate, FenceBlock fence, Block block) {
        ResourceLocation texture;
        if (block == null) {
            ResourceLocation fenceId = this.key((Block)fence);
            texture = ModelLocationUtils.getModelLocation((Block)fence);
            this.simpleBlockItem((Block)gate, (ModelFile)this.itemModels().fenceGate("block/" + fenceId.getPath(), texture));
        } else {
            ResourceLocation gateId = this.key((Block)gate);
            texture = ModelLocationUtils.getModelLocation((Block)block);
            this.simpleBlockItem((Block)gate, (ModelFile)this.itemModels().fenceGate("block/" + gateId.getPath(), texture));
        }
        this.fenceGateBlock(gate, texture);
    }

    private void registerDoor(DoorBlock door) {
        this.registerDoor(door, door);
    }

    private void registerDoor(DoorBlock door, DoorBlock texturedBlock) {
        ResourceLocation blockId = this.key((Block)texturedBlock);
        this.doorBlockWithRenderType(door, ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath() + "_bottom")), ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath() + "_top")), "cutout");
    }

    private void registerPressurePlate(PressurePlateBlock pressurePlate, Block texturedBlock) {
        ResourceLocation texture = ModelLocationUtils.getModelLocation((Block)texturedBlock);
        this.pressurePlateBlock(pressurePlate, texture);
        this.itemModels().pressurePlate(this.key((Block)pressurePlate).getPath(), texture);
    }

    private void registerButton(Block button, Block texturedBlock) {
        ResourceLocation buttonId = this.key(button);
        ResourceLocation textureBlockId = this.key(texturedBlock);
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)textureBlockId.getNamespace(), (String)("block/" + textureBlockId.getPath()));
        this.buttonBlock((ButtonBlock)button, texture);
        this.itemModels().buttonInventory(buttonId.getPath(), texture);
    }

    private void registerTrapDoor(TrapDoorBlock trapDoor, Block texturedBlock) {
        ResourceLocation texture = ModelLocationUtils.getModelLocation((Block)texturedBlock);
        ResourceLocation trapDoorId = this.key((Block)trapDoor);
        this.trapdoorBlockWithRenderType(trapDoor, texture, true, "cutout");
        this.itemModels().trapdoorBottom(trapDoorId.getPath(), texture);
    }

    private void registerTrapDoor(TrapDoorBlock trapDoor) {
        this.registerTrapDoor(trapDoor, (Block)trapDoor);
    }

    private void registerSign(StandingSignBlock sign, WallSignBlock wallsign, Block plank) {
        this.signBlock(sign, wallsign, this.blockTexture(plank));
    }

    private void tintedCube(Block block, String name, String up, String down, String north, String south, String west, String east) {
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/tinted_cube"))).texture("up", this.modLoc(up))).texture("down", this.modLoc(down))).texture("north", this.modLoc(north))).texture("south", this.modLoc(south))).texture("west", this.modLoc(west))).texture("east", this.modLoc(east))).addModel();
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }

    private void tintedOverlayBlock(Block block, String name, String baseUp, String baseDown, String baseNorth, String baseSouth, String baseWest, String baseEast, String overlayUp, String overlayDown, String overlayNorth, String overlaySouth, String overlayWest, String overlayEast) {
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/tinted_overlay_cube"))).texture("base_up", this.modLoc(baseUp))).texture("base_down", this.modLoc(baseDown))).texture("base_north", this.modLoc(baseNorth))).texture("base_south", this.modLoc(baseSouth))).texture("base_west", this.modLoc(baseWest))).texture("base_east", this.modLoc(baseEast))).texture("overlay_up", this.modLoc(overlayUp))).texture("overlay_down", this.modLoc(overlayDown))).texture("overlay_north", this.modLoc(overlayNorth))).texture("overlay_south", this.modLoc(overlaySouth))).texture("overlay_west", this.modLoc(overlayWest))).texture("overlay_east", this.modLoc(overlayEast)));
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }
}

