/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class AtlantisLootTableProvider
extends LootTableProvider {
    public AtlantisLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, Set.of(), List.of(), lookup);
    }

    @NotNull
    public List<LootTableProvider.SubProviderEntry> getTables() {
        return List.of(new LootTableProvider.SubProviderEntry(this::blocks, LootContextParamSets.BLOCK));
    }

    private LootTableSubProvider blocks(HolderLookup.Provider provider) {
        Holder.Reference silkTouch = provider.asGetterLookup().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
        ItemEnchantmentsPredicate.Enchantments silkTouchPredicate = ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)silkTouch, MinMaxBounds.Ints.ANY)));
        return consumer -> {
            for (TrailsGroup trailsGroup : BlockInit.ANCIENT_CUPRUM.values()) {
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.block().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.bulb().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.grate().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.cut().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.cut_slab().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.cut_stairs().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.chiseled().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.door().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.trapdoor().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_block().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_bulb().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_grate().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_cut().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_cut_slab().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_cut_stairs().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_chiseled().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_door().get(), consumer);
                AtlantisLootTableProvider.dropSelf((Block)trailsGroup.waxed_trapdoor().get(), consumer);
            }
            for (DeferredBlock deferredBlock : BlockInit.COLORED_SHELL_BLOCKS.values()) {
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)deferredBlock.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            }
            for (DeferredBlock deferredBlock : BlockInit.MOSSY_SHELL_BLOCKS.values()) {
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)deferredBlock.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            }
            for (DeferredBlock deferredBlock : BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.values()) {
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)deferredBlock.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            }
            for (DeferredBlock deferredBlock : BlockInit.CRACKED_SHELL_BLOCKS.values()) {
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)deferredBlock.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            }
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_ACACIA.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BIRCH.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_OAK.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_DARK_OAK.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_JUNGLE.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_SPRUCE.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CHERRY.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_BAMBOO.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_MANGROVE.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_CRIMSON.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANCIENT_WARPED.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_LOG.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.STRIPPED_NYMPH_LOG.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_LOG.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.STRIPPED_PALM_LOG.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_PLANKS.button().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.block().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.door().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.fence().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.fenceGate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.slab().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.stairs().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.trapDoor().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.pressurePlate().get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_PLANKS.button().get(), consumer);
            for (Object color : DyeColor.values()) {
                BlockType blockType = BlockInit.SEA_GLASS_PATTERNS.get(color);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.block().get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.slab().get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.stairs().get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.pressurePlate().get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.button().get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouched((Block)blockType.wall().get(), consumer, silkTouchPredicate);
            }
            for (Map map : BlockInit.DYED_LINGUISTICS.values()) {
                map.forEach((dyeColor, block) -> AtlantisLootTableProvider.dropSelf((Block)block.get(), consumer));
            }
            for (DeferredBlock deferredBlock : BlockInit.NON_LINGUISTICS.values()) {
                AtlantisLootTableProvider.dropSelf((Block)deferredBlock.get(), consumer);
            }
            for (Object color : DyeColor.values()) {
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.MOSSY_SHELL_BLOCKS.get(color).get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(color).get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_SHELL_BLOCKS.get(color).get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
                AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.COLORED_SHELL_BLOCKS.get(color).get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            }
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ALGAE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ALGAE_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ALGAE_DETRITUS_STONE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ANEMONE.get(), consumer);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.FIRE_MELON_TOP.get(), (Item)ItemInit.FIRE_MELON_SPIKE.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropLeaves((Block)BlockInit.NYMPH_LEAVES.get(), (Block)BlockInit.NYMPH_SAPLING.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_SAPLING.get(), consumer);
            AtlantisLootTableProvider.dropLeaves((Block)BlockInit.PALM_LEAVES.get(), (Block)BlockInit.PALM_SAPLING.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_SAPLING.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_COMPARATOR.get(), consumer);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.SURGE_LANTERN.get(), Items.PRISMARINE_CRYSTALS, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SUNKEN_GRAVEL.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_TRIPWIRE_HOOK.get(), consumer);
            AtlantisLootTableProvider.dropItemFromBlock((Block)BlockInit.AQUATIC_POWER_TRIPWIRE.get(), (Item)ItemInit.AQUAIEL_STRING.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_TORCH.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_STONE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_REPEATER.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_LEVER.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.AQUATIC_POWER_LAMP.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.NYMPH_SIGN.get(), consumer);
            AtlantisLootTableProvider.dropAlternativeBlock((Block)BlockInit.NYMPH_WALL_SIGN.get(), (Block)BlockInit.NYMPH_SIGN.get(), consumer);
            AtlantisLootTableProvider.dropAlternativeBlock((Block)BlockInit.PALM_WALL_SIGN.get(), (Block)BlockInit.PALM_SIGN.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PALM_SIGN.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BLOCK_OF_AQUAMARINE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BLUE_LILY.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PINK_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BLACK_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PURPLE_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BLUE_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BROWN_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.YELLOW_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.RED_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.WHITE_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.LIGHT_BLUE_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.LIGHT_GRAY_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CYAN_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.GREEN_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.ORANGE_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.GRAY_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.LIME_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.MAGENTA_PEARL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BUBBLE_MAGMA.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.BURNT_DEEP.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.HARDENED_CALCITE_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CARVED_COCONUT.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CHISELED_AQUAMARINE_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CHISELED_GOLDEN_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CHISELED_GOLDEN_AQUAMARINE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.COCONUT.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.COCONUT_SLICE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.COQUINA.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CRACKED_GLOWSTONE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.DEAD_GLOWSTONE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.CRYSTAL_TRANSFERENCE_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.WATERFALL_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.WAVE_BLOCK.get(), consumer);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.DEEPSLATE_AQUAMARINE_ORE.get(), (Item)ItemInit.AQUAMARINE_GEM.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.DEEPSLATE_ANCIENT_CUPRUM_ORE.get(), (Item)ItemInit.RAW_ANCIENT_CUPRUM.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.DETRITUS_SANDSTONE.get(), consumer);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.AQUAMARINE_ORE.get(), (Item)ItemInit.AQUAMARINE_GEM.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.ANCIENT_CUPRUM_ORE.get(), (Item)ItemInit.RAW_ANCIENT_CUPRUM.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.LINGUISTIC_TABLE.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.WRITING_TABLE.get(), consumer);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.NAUTILUS_SHELL_BLOCK.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_NAUTILUS_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_MOSSY_NAUTILUS_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.MOSSY_NAUTILUS_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.OYSTER_SHELL_BLOCK.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_OYSTER_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CRACKED_MOSSY_OYSTER_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.MOSSY_OYSTER_SHELL.get(), (Item)ItemInit.BROKEN_SHELLS.get(), consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.OCEAN_LANTERN.get(), Items.PRISMARINE_CRYSTALS, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.TUBEN_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.BELEN_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.TOPER_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.SNOWN_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.HORPEN_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.CELEN_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelfIfSilkTouchedOrItem((Block)BlockInit.OBEMO_POT.get(), Items.CLAY_BALL, consumer, silkTouchPredicate);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.PURPLE_SEASHROOM.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.YELLOW_SEASHROOM.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SEABLOOM.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.RED_SEABLOOM.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.YELLOW_SEABLOOM.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SEASALT_CHUNK.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SEABED.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SATIRE_LANTERN.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.SODIUM_BOMB.get(), consumer);
            AtlantisLootTableProvider.dropSelf((Block)BlockInit.TUBER_UP.get(), consumer);
        };
    }

    private static void dropSelfIfSilkTouched(Block block, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder, ItemEnchantmentsPredicate.Enchantments silkTouch) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)silkTouch))))));
    }

    private static void dropSelfIfSilkTouchedOrItem(Block block, Item item, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder, ItemEnchantmentsPredicate.Enchantments silkTouch) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)silkTouch)))).add(LootItem.lootTableItem((ItemLike)item).when(ExplosionCondition.survivesExplosion()))));
    }

    private static void dropLeaves(Block block, Block block2, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder, ItemEnchantmentsPredicate.Enchantments silkTouchPredicate) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)silkTouchPredicate)))).add(LootItem.lootTableItem((ItemLike)block2).when(ExplosionCondition.survivesExplosion())).add(LootItem.lootTableItem((ItemLike)Items.STICK).when(ExplosionCondition.survivesExplosion()))));
    }

    private static void dropSelf(Block block, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }

    private static void dropItemFromBlock(Block block, Item item, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)item).when(ExplosionCondition.survivesExplosion())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    private static void dropAlternativeBlock(Block block, Block block2, BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
        builder.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block2).when(ExplosionCondition.survivesExplosion())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block2))));
    }
}

