/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.CuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprum;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumDoorBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumFullBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumGrateBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumSlabBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumStairsBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumTrapdoorBlock;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.recipes.WritingRecipe;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import org.jetbrains.annotations.NotNull;

public class AtlantisRecipeProvider
extends RecipeProvider {
    private static CompletableFuture<HolderLookup.Provider> lookup;

    public AtlantisRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, lookup);
        AtlantisRecipeProvider.lookup = lookup;
    }

    protected void buildRecipes(@NotNull RecipeOutput out) {
        List<Item> list = ItemInit.getScrolls();
        Ingredient ingredient = Ingredient.of((ItemLike[])((ItemLike[])list.toArray(Item[]::new)));
        for (Item result : list) {
            AtlantisRecipeProvider.glyphScroll(out, (ItemLike)result, ingredient);
        }
        for (WeatheringCuprum.WeatherState state : WeatheringCuprum.WeatherState.values()) {
            TrailsGroup group = BlockInit.ANCIENT_CUPRUM.get((Object)state);
            AtlantisRecipeProvider.registerGroup(group, out);
            if (WeatheringCuprum.WeatherState.UNAFFECTED != ((WeatheringCuprumFullBlock)group.block().get()).getAge()) continue;
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.block().get()), (float)0.7f, (int)200).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.block().get()))).save(out, Atlantis.id(((WeatheringCuprumFullBlock)group.block().get()).getDescriptionId().replace("block.atlantis.", "") + "_smelting"));
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.block().get()), (float)0.7f, (int)100).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.block().get()))).save(out, Atlantis.id(((WeatheringCuprumFullBlock)group.block().get()).getDescriptionId().replace("block.atlantis.", "") + "_blasting"));
        }
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_BAMBOO, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_ACACIA, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_SPRUCE, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_BIRCH, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_CRIMSON, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_WARPED, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_JUNGLE, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_OAK, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_DARK_OAK, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_MANGROVE, out);
        AtlantisRecipeProvider.registerWood(BlockInit.ANCIENT_CHERRY, out);
        AtlantisRecipeProvider.registerWood(BlockInit.NYMPH_PLANKS, out);
        AtlantisRecipeProvider.registerWood(BlockInit.PALM_PLANKS, out);
        AtlantisRecipeProvider.registerSeaGlass(out);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:algae"), (int)9).requires(AtlantisRecipeProvider.i("atlantis:algae_block")).unlockedBy("has_algae-1", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:algae_block"))).save(out, Atlantis.id("algae-1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:algae"), (int)4).pattern(" B ").pattern("BAB").pattern(" B ").define(Character.valueOf('B'), AtlantisRecipeProvider.i("minecraft:kelp")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:sand")).unlockedBy("has_algae-2", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:kelp"))).save(out, Atlantis.id("algae-2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:algae_block"), (int)1).pattern("WWW").pattern("WWW").pattern("WWW").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_algae_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:algae"))).save(out, Atlantis.id("algae_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:algae_detritus_stone"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:algae")).requires(AtlantisRecipeProvider.i("atlantis:detritus_sandstone")).unlockedBy("has_algae_detritus_stone", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:algae"))).save(out, Atlantis.id("algae_detritus_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_acacia_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:acacia_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_acacia_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:acacia_planks"))).save(out, Atlantis.id("ancient_acacia_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_bamboo_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:bamboo_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_bamboo_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:bamboo_planks"))).save(out, Atlantis.id("ancient_bamboo_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_birch_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:birch_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_birch_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:birch_planks"))).save(out, Atlantis.id("ancient_birch_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_cherry_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:cherry_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_cherry_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:cherry_planks"))).save(out, Atlantis.id("ancient_cherry_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_crimson_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:crimson_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_crimson_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:crimson_planks"))).save(out, Atlantis.id("ancient_crimson_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_dark_oak_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:dark_oak_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_dark_oak_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:dark_oak_planks"))).save(out, Atlantis.id("ancient_dark_oak_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_jungle_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:jungle_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_jungle_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:jungle_planks"))).save(out, Atlantis.id("ancient_jungle_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_mangrove_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:mangrove_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_mangrove_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:mangrove_planks"))).save(out, Atlantis.id("ancient_mangrove_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_oak_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:oak_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_oak_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:oak_planks"))).save(out, Atlantis.id("ancient_oak_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_spruce_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:spruce_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_spruce_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:spruce_planks"))).save(out, Atlantis.id("ancient_spruce_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_warped_planks"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:warped_planks")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:algae")).unlockedBy("has_ancient_warped_planks", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:warped_planks"))).save(out, Atlantis.id("ancient_warped_planks"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquaiel_string"), (int)2).requires(AtlantisRecipeProvider.i("minecraft:string")).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_aquaiel_string", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:string"))).save(out, Atlantis.id("aquaiel_string"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_axe"), (int)1).pattern("II ").pattern("IC ").pattern(" C ").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_axe", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_axe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_block"), (int)1).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("aquamarine_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_chestplate"), (int)1).pattern("I I").pattern("III").pattern("III").define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_chestplate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("aquamarine_chestplate"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:aquamarine_ore")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"), (float)0.3f, (int)140).unlockedBy("has_aquamarine_gem_blasting", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_ore"))).save(out, Atlantis.id("aquamarine_gem_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:aquamarine_ore")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"), (float)0.3f, (int)180).unlockedBy("has_aquamarine_gem_smelting", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_ore"))).save(out, Atlantis.id("aquamarine_gem_smelting"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_hammer"), (int)1).pattern("SSS").pattern("SWS").pattern(" W ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_hammer", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_hammer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_helmet"), (int)1).pattern("III").pattern("I I").pattern("   ").define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_helmet", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("aquamarine_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_hoe"), (int)1).pattern("II ").pattern(" C ").pattern(" C ").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_hoe", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_hoe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_leggings"), (int)1).pattern("III").pattern("I I").pattern("I I").define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_leggings", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("aquamarine_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_pickaxe"), (int)1).pattern("III").pattern(" C ").pattern(" C ").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_pickaxe", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_shovel"), (int)1).pattern(" I ").pattern(" C ").pattern(" C ").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_shovel", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_shovel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_sword"), (int)1).pattern(" I ").pattern(" I ").pattern(" C ").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aquamarine_sword", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquamarine_sword"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_comparator"), (int)1).pattern(" S ").pattern("SWS").pattern("EEE").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquatic_power_torch")).define(Character.valueOf('E'), AtlantisRecipeProvider.i("minecraft:stone")).unlockedBy("has_aquatic_power_comparator", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_stone"))).save(out, Atlantis.id("aquatic_power_comparator"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_dust"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:redstone")).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_aquatic_power_dust", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:redstone"))).save(out, Atlantis.id("aquatic_power_dust"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_lamp"), (int)1).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:glowstone")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquatic_power_dust")).unlockedBy("has_aquatic_power_lamp", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:glowstone"))).save(out, Atlantis.id("aquatic_power_lamp"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_lever"), (int)2).requires(AtlantisRecipeProvider.i("minecraft:lever")).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_aquatic_power_lever", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:lever"))).save(out, Atlantis.id("aquatic_power_lever"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_repeater"), (int)1).pattern("EWE").pattern("SSS").pattern("   ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:aquatic_power_dust")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:stone")).define(Character.valueOf('E'), AtlantisRecipeProvider.i("atlantis:aquatic_power_torch")).unlockedBy("has_aquatic_power_repeater", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_dust"))).save(out, Atlantis.id("aquatic_power_repeater"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_stone"), (int)1).pattern("ESE").pattern("SWS").pattern("ESE").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:iron_ingot")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).define(Character.valueOf('E'), AtlantisRecipeProvider.i("atlantis:aquatic_power_dust")).unlockedBy("has_aquatic_power_stone", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:iron_ingot"))).save(out, Atlantis.id("aquatic_power_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_torch"), (int)1).pattern(" S ").pattern(" W ").pattern("   ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquatic_power_dust")).unlockedBy("has_aquatic_power_torch", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("aquatic_power_torch"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquatic_power_tripwire_hook"), (int)2).requires(AtlantisRecipeProvider.i("minecraft:tripwire_hook")).requires(AtlantisRecipeProvider.i("atlantis:aquatic_power_dust")).unlockedBy("has_aquatic_power_tripwire_hook", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:tripwire_hook"))).save(out, Atlantis.id("aquatic_power_tripwire_hook"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_boots"), (int)1).pattern("   ").pattern("I I").pattern("I I").define(Character.valueOf('I'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_aqumarine_boots", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("aqumarine_boots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_amulet"), (int)1).pattern("SSS").pattern("SWS").pattern("SSS").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:fire_charge")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).unlockedBy("has_atlantean_amulet", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:fire_charge"))).save(out, Atlantis.id("atlantean_amulet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("minecraft:stick"), (int)2).pattern(" SW").pattern("S W").pattern(" SW").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:aquaiel_string")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:stick")).unlockedBy("has_atlantean_bow", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquaiel_string"))).save(out, Atlantis.id("atlantean_bow"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_core"), (int)1).pattern("CIC").pattern("IOI").pattern("CIC").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:cobblestone")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("minecraft:iron_ingot")).define(Character.valueOf('O'), AtlantisRecipeProvider.i("atlantis:ocean_lantern")).unlockedBy("has_atlantean_core", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:cobblestone"))).save(out, Atlantis.id("atlantean_core"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_crystal"), (int)8).pattern("SSS").pattern("SWS").pattern("SSS").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:gold_nugget")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_atlantean_crystal", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:gold_nugget"))).save(out, Atlantis.id("atlantean_crystal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_portal_frame"), (int)1).pattern("SOS").pattern("OWO").pattern("SOS").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:atlantean_core")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:drop_of_atlantis")).define(Character.valueOf('O'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_atlantean_portal_frame", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_core"))).save(out, Atlantis.id("atlantean_portal_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_sign"), (int)2).pattern("SSS").pattern("SSS").pattern(" W ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:nymph_planks")).unlockedBy("has_atlantean_sign", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("atlantean_sign"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_spear"), (int)1).pattern("  S").pattern(" W ").pattern("W  ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:iron_ingot")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).unlockedBy("has_atlantean_spear", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:iron_ingot"))).save(out, Atlantis.id("atlantean_spear"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:belen_pot"), (int)1).pattern("TNT").pattern("TNT").pattern("ANA").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_belen_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("belen_pot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:black_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_black_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:black_dye"))).save(out, Atlantis.id("black_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:black_dye")).unlockedBy("has_black_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("black_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:black_sea_glass")).unlockedBy("has_black_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:black_sea_glass")).unlockedBy("has_black_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:black_sea_glass")).unlockedBy("has_black_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:black_sea_glass")).unlockedBy("has_black_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:black_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_black_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:black_dye"))).save(out, Atlantis.id("black_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:blue_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_blue_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:blue_dye"))).save(out, Atlantis.id("blue_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:blue_dye")).unlockedBy("has_blue_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("blue_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:blue_sea_glass")).unlockedBy("has_blue_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:blue_sea_glass")).unlockedBy("has_blue_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:blue_sea_glass")).unlockedBy("has_blue_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:blue_sea_glass")).unlockedBy("has_blue_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:blue_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_blue_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:blue_dye"))).save(out, Atlantis.id("blue_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:brown_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_brown_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:brown_dye"))).save(out, Atlantis.id("brown_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:brown_dye")).unlockedBy("has_brown_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("brown_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:brown_sea_glass")).unlockedBy("has_brown_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_sea_glass")).unlockedBy("has_brown_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_sea_glass")).unlockedBy("has_brown_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_sea_glass")).unlockedBy("has_brown_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:brown_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_brown_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:brown_dye"))).save(out, Atlantis.id("brown_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_boots"), (int)1).pattern("   ").pattern("# #").pattern("# #").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_wrought_patches")).unlockedBy("has_brown_wrought_boots", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_patches"))).save(out, Atlantis.id("brown_wrought_boots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_chestplate"), (int)1).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_wrought_patches")).unlockedBy("has_brown_wrought_chestplate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_patches"))).save(out, Atlantis.id("brown_wrought_chestplate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_helmet"), (int)1).pattern("###").pattern("# #").pattern("   ").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_wrought_patches")).unlockedBy("has_brown_wrought_helmet", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_patches"))).save(out, Atlantis.id("brown_wrought_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_leggings"), (int)1).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:brown_wrought_patches")).unlockedBy("has_brown_wrought_leggings", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_patches"))).save(out, Atlantis.id("brown_wrought_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_wrought_patches"), (int)6).pattern("#L#").pattern("LPL").pattern("#L#").define(Character.valueOf('#'), AtlantisRecipeProvider.i("minecraft:vine")).define(Character.valueOf('L'), AtlantisRecipeProvider.i("minecraft:leather")).define(Character.valueOf('P'), AtlantisRecipeProvider.i("minecraft:paper")).unlockedBy("has_brown_wrought_patches", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:vine"))).save(out, Atlantis.id("brown_wrought_patches"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:bubble_magma"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).requires(AtlantisRecipeProvider.i("minecraft:magma_block")).unlockedBy("has_bubble_magma", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_stone"))).save(out, Atlantis.id("bubble_magma"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:celen_pot"), (int)1).pattern("ANT").pattern("NNN").pattern("ANT").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_celen_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("celen_pot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:chiseled_aquamarine_block"), (int)2).requires(AtlantisRecipeProvider.i("atlantis:aquamarine_block")).requires(AtlantisRecipeProvider.i("atlantis:aquamarine_block")).unlockedBy("has_chiseled_aquamarine_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_block"))).save(out, Atlantis.id("chiseled_aquamarine_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:chiseled_golden_aquamarine"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:chiseled_golden_block")).requires(AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_chiseled_golden_aquamarine", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:chiseled_golden_block"))).save(out, Atlantis.id("chiseled_golden_aquamarine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:chiseled_golden_block"), (int)2).requires(AtlantisRecipeProvider.i("minecraft:gold_block")).requires(AtlantisRecipeProvider.i("minecraft:gold_block")).unlockedBy("has_chiseled_golden_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:gold_block"))).save(out, Atlantis.id("chiseled_golden_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:coconut_slice"), (int)2).requires(AtlantisRecipeProvider.i("atlantis:coconut")).unlockedBy("has_coconut_slice", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:coconut"))).save(out, Atlantis.id("coconut_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cracked_glowstone"), (int)2).pattern(" W ").pattern("WSW").pattern(" W ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:glowstone")).unlockedBy("has_cracked_glowstone", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_stone"))).save(out, Atlantis.id("cracked_glowstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:crystal_transference_block"), (int)1).pattern("RAR").pattern("IRI").pattern("AIA").define(Character.valueOf('R'), AtlantisRecipeProvider.i("minecraft:redstone_block")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("minecraft:iron_ingot")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).unlockedBy("has_crystal_transference_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:redstone_block"))).save(out, Atlantis.id("crystal_transference_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:cyan_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_cyan_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:cyan_dye"))).save(out, Atlantis.id("cyan_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:cyan_dye")).unlockedBy("has_cyan_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("cyan_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")).unlockedBy("has_cyan_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")).unlockedBy("has_cyan_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")).unlockedBy("has_cyan_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")).unlockedBy("has_cyan_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:cyan_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_cyan_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:cyan_dye"))).save(out, Atlantis.id("cyan_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:dead_glowstone"), (int)3).pattern("   ").pattern("WSW").pattern("   ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:sunken_gravel")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:cracked_glowstone")).unlockedBy("has_dead_glowstone", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel"))).save(out, Atlantis.id("dead_glowstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:drop_of_atlantis"), (int)2).pattern("OSO").pattern("SWS").pattern("OSO").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ancient_cuprum_ingot")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).define(Character.valueOf('O'), AtlantisRecipeProvider.i("minecraft:gold_nugget")).unlockedBy("has_drop_of_atlantis", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ancient_cuprum_ingot"))).save(out, Atlantis.id("drop_of_atlantis"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:fire_melon_jelly_bottle"), (int)3).requires(AtlantisRecipeProvider.i("atlantis:jellyfish_jelly_bottle")).requires(AtlantisRecipeProvider.i("atlantis:fire_melon_fruit")).unlockedBy("has_fire_melon_fruit_jelly", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:jellyfish_jelly_bottle"))).save(out, Atlantis.id("fire_melon_fruit_jelly"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:gray_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_gray_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:gray_dye"))).save(out, Atlantis.id("gray_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:gray_dye")).unlockedBy("has_gray_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("gray_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:gray_sea_glass")).unlockedBy("has_gray_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:gray_sea_glass")).unlockedBy("has_gray_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:gray_sea_glass")).unlockedBy("has_gray_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:gray_sea_glass")).unlockedBy("has_gray_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:gray_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_gray_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:gray_dye"))).save(out, Atlantis.id("gray_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:green_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_green_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:green_dye"))).save(out, Atlantis.id("green_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:green_dye")).unlockedBy("has_green_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("green_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:green_sea_glass")).unlockedBy("has_green_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:green_sea_glass")).unlockedBy("has_green_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:green_sea_glass")).unlockedBy("has_green_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:green_sea_glass")).unlockedBy("has_green_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:green_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_green_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:green_dye"))).save(out, Atlantis.id("green_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:hardened_calcite_block"), (int)4).pattern("SS ").pattern("SS ").pattern("   ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:calcite")).unlockedBy("has_hardened_calcite_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:calcite"))).save(out, Atlantis.id("hardened_calcite_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:horpen_pot"), (int)1).pattern("TAT").pattern("NNN").pattern("TAT").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_horpen_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("horpen_pot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:light_blue_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_light_blue_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:light_blue_dye"))).save(out, Atlantis.id("light_blue_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:light_blue_dye")).unlockedBy("has_light_blue_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")).unlockedBy("has_light_blue_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")).unlockedBy("has_light_blue_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")).unlockedBy("has_light_blue_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")).unlockedBy("has_light_blue_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:light_blue_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_light_blue_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:light_blue_dye"))).save(out, Atlantis.id("light_blue_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:light_gray_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_light_gray_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:light_gray_dye"))).save(out, Atlantis.id("light_gray_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:light_gray_dye")).unlockedBy("has_light_gray_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")).unlockedBy("has_light_gray_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")).unlockedBy("has_light_gray_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")).unlockedBy("has_light_gray_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")).unlockedBy("has_light_gray_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:light_gray_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_light_gray_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:light_gray_dye"))).save(out, Atlantis.id("light_gray_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:lime_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_lime_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:lime_dye"))).save(out, Atlantis.id("lime_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:lime_dye")).unlockedBy("has_lime_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("lime_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:lime_sea_glass")).unlockedBy("has_lime_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:lime_sea_glass")).unlockedBy("has_lime_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:lime_sea_glass")).unlockedBy("has_lime_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:lime_sea_glass")).unlockedBy("has_lime_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:lime_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_lime_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:lime_dye"))).save(out, Atlantis.id("lime_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:linguistic_table"), (int)1).pattern("XYX").pattern("YZY").pattern("XYX").define(Character.valueOf('X'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).define(Character.valueOf('Y'), AtlantisRecipeProvider.i("atlantis:nymph_planks")).define(Character.valueOf('Z'), AtlantisRecipeProvider.i("minecraft:crafting_table")).unlockedBy("has_linguistic_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("linguistic_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:linguistic_glyph"), (int)2).pattern("XX").pattern("XX").define(Character.valueOf('X'), AtlantisRecipeProvider.i("atlantis:luminescent_prismarine")).unlockedBy("has_linguistic_glyph", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:luminescent_prismarine"))).save(out, Atlantis.id("linguistic_glyph"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:linguistic_glyph_scroll"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:ink_sac")).requires(AtlantisRecipeProvider.i("minecraft:paper")).requires(AtlantisRecipeProvider.i("atlantis:fire_melon_spike")).unlockedBy("has_linguistic_glyph_scroll", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:ink_sac"))).save(out, Atlantis.id("linguistic_glyph_scroll"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:luminescent_prismarine"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:prismarine")).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_luminescent_prismarine", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:prismarine"))).save(out, Atlantis.id("luminescent_prismarine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:magenta_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_magenta_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:magenta_dye"))).save(out, Atlantis.id("magenta_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:magenta_dye")).unlockedBy("has_magenta_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("magenta_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")).unlockedBy("has_magenta_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")).unlockedBy("has_magenta_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")).unlockedBy("has_magenta_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")).unlockedBy("has_magenta_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:magenta_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_magenta_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:magenta_dye"))).save(out, Atlantis.id("magenta_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:black_dye")).requires(AtlantisRecipeProvider.i("minecraft:black_dye")).requires(AtlantisRecipeProvider.i("minecraft:white_dye")).requires(AtlantisRecipeProvider.i("minecraft:white_dye")).requires(AtlantisRecipeProvider.i("minecraft:gray_dye")).requires(AtlantisRecipeProvider.i("minecraft:gray_dye")).unlockedBy("has_monochromatic_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")).unlockedBy("has_monochromatic_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")).unlockedBy("has_monochromatic_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")).unlockedBy("has_monochromatic_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")).unlockedBy("has_monochromatic_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:red_dye")).requires(AtlantisRecipeProvider.i("minecraft:orange_dye")).requires(AtlantisRecipeProvider.i("minecraft:yellow_dye")).requires(AtlantisRecipeProvider.i("minecraft:lime_dye")).requires(AtlantisRecipeProvider.i("minecraft:green_dye")).requires(AtlantisRecipeProvider.i("minecraft:blue_dye")).requires(AtlantisRecipeProvider.i("minecraft:magenta_dye")).requires(AtlantisRecipeProvider.i("minecraft:purple_dye")).unlockedBy("has_multicolor_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")).unlockedBy("has_multicolor_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")).unlockedBy("has_multicolor_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")).unlockedBy("has_multicolor_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")).unlockedBy("has_multicolor_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("minecraft:nautilus_shell"), (int)9).requires(AtlantisRecipeProvider.i("atlantis:nautilus_shell_block")).unlockedBy("has_nautilus_shell", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:nautilus_shell_block"))).save(out, Atlantis.id("nautilus_shell"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:nautilus_shell_block"), (int)1).pattern("WWW").pattern("WWW").pattern("WWW").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:nautilus_shell")).unlockedBy("has_nautilus_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:nautilus_shell"))).save(out, Atlantis.id("nautilus_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_boat"), (int)1).pattern("   ").pattern("S S").pattern("SSS").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:nymph_planks")).unlockedBy("has_nymph_boat", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_planks"))).save(out, Atlantis.id("nymph_boat"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_planks"), (int)4).requires(AtlantisRecipeProvider.i("atlantis:nymph_log")).unlockedBy("has_nymph_log", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_log"))).save(out, Atlantis.id("nymph_log"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:obemo_pot"), (int)1).pattern("ANT").pattern("TNT").pattern("TNA").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_obemo_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("obemo_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_lantern"), (int)2).pattern("   ").pattern("SWS").pattern("   ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:sea_lantern")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:iron_ingot")).unlockedBy("has_ocean_lantern", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:sea_lantern"))).save(out, Atlantis.id("ocean_lantern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_stone"), (int)4).pattern(" S ").pattern("SBS").pattern(" S ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:stone")).define(Character.valueOf('B'), AtlantisRecipeProvider.i("minecraft:water_bucket")).unlockedBy("has_ocean_stone", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stone"))).save(out, Atlantis.id("ocean_stone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:orange_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_orange_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:orange_dye"))).save(out, Atlantis.id("orange_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:orange_dye")).unlockedBy("has_orange_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("orange_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:orange_sea_glass")).unlockedBy("has_orange_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:orange_sea_glass")).unlockedBy("has_orange_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:orange_sea_glass")).unlockedBy("has_orange_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:orange_sea_glass")).unlockedBy("has_orange_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:orange_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_orange_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:orange_dye"))).save(out, Atlantis.id("orange_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orb_of_atlantis"), (int)1).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:drop_of_atlantis")).unlockedBy("has_orb_of_atlantis", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_crystal"))).save(out, Atlantis.id("orb_of_atlantis"));
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_axe", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_axe", "atlantis:orichalcum_ingot", "atlantis:orichalcum_axe");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_boots", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_boots", "atlantis:orichalcum_ingot", "atlantis:orichalcum_boots");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_chestplate", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_chestplate", "atlantis:orichalcum_ingot", "atlantis:orichalcum_chestplate");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_hammer", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_hammer", "atlantis:orichalcum_ingot", "atlantis:orichalcum_hammer");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_helmet", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_helmet", "atlantis:orichalcum_ingot", "atlantis:orichalcum_helmet");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_hoe", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_hoe", "atlantis:orichalcum_ingot", "atlantis:orichalcum_hoe");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_leggings", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_leggings", "atlantis:orichalcum_ingot", "atlantis:orichalcum_leggings");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_pickaxe", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_pickaxe", "atlantis:orichalcum_ingot", "atlantis:orichalcum_pickaxe");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_shovel", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_shovel", "atlantis:orichalcum_ingot", "atlantis:orichalcum_shovel");
        AtlantisRecipeProvider.smithingTransform(out, "orichalcum_sword", "atlantis:orichalcum_upgrade_smithing_template", "atlantis:aquamarine_sword", "atlantis:orichalcum_ingot", "atlantis:orichalcum_sword");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:black_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_slab_from_black_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:black_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:black_sea_glass"))).save(out, Atlantis.id("black_sea_glass_wall_from_black_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:blue_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_slab_from_blue_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:blue_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:blue_sea_glass"))).save(out, Atlantis.id("blue_sea_glass_wall_from_blue_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:brown_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_slab_from_brown_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:brown_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:brown_sea_glass"))).save(out, Atlantis.id("brown_sea_glass_wall_from_brown_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_slab_from_cyan_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:cyan_sea_glass"))).save(out, Atlantis.id("cyan_sea_glass_wall_from_cyan_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:gray_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_slab_from_gray_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:gray_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:gray_sea_glass"))).save(out, Atlantis.id("gray_sea_glass_wall_from_gray_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:green_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_slab_from_green_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:green_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:green_sea_glass"))).save(out, Atlantis.id("green_sea_glass_wall_from_green_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_slab_from_light_blue_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_blue_sea_glass"))).save(out, Atlantis.id("light_blue_sea_glass_wall_from_light_blue_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_slab_from_light_gray_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:light_gray_sea_glass"))).save(out, Atlantis.id("light_gray_sea_glass_wall_from_light_gray_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:lime_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_slab_from_lime_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:lime_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:lime_sea_glass"))).save(out, Atlantis.id("lime_sea_glass_wall_from_lime_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_slab_from_magenta_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:magenta_sea_glass"))).save(out, Atlantis.id("magenta_sea_glass_wall_from_magenta_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_slab_from_monochromatic_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:monochromatic_sea_glass"))).save(out, Atlantis.id("monochromatic_sea_glass_wall_from_monochromatic_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_slab_from_multicolor_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:multicolor_sea_glass"))).save(out, Atlantis.id("multicolor_sea_glass_wall_from_multicolor_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orange_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_slab_from_orange_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orange_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orange_sea_glass"))).save(out, Atlantis.id("orange_sea_glass_wall_from_orange_sea_glass_stonecutting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orichalcum_blend")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_ingot"), (float)0.7f, (int)100).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend"))).save(out, Atlantis.id("orichalcum_ignot_from_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orichalcum_blend")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_ingot"), (float)0.7f, (int)200).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend"))).save(out, Atlantis.id("orichalcum_ignot_from_smelting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orichalcum_blend")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_ingot"), (float)0.7f, (int)100).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend"))).save(out, Atlantis.id("orichalcum_ingot_from_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:orichalcum_blend")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_ingot"), (float)0.7f, (int)200).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend"))).save(out, Atlantis.id("orichalcum_ingot_from_smelting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:pink_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_slab_from_pink_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:pink_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_wall_from_pink_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:purple_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_slab_from_purple_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:purple_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_wall_from_purple_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:red_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_slab_from_red_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:red_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_wall_from_red_sea_glass_stonecutting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:sunken_gravel")}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"), (float)0.5f, (int)100).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel"))).save(out, Atlantis.id("sea_glass_from_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:sunken_gravel")}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"), (float)0.5f, (int)50).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel"))).save(out, Atlantis.id("sea_glass_from_smelting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_slab_from_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_wall_from_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:white_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_slab_from_white_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:white_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_wall_from_white_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_slab"), (int)2).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_slab_from_yellow_sea_glass_stonecutting"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_wall"), (int)1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_wall_from_yellow_sea_glass_stonecutting"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:shrimp")}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)AtlantisRecipeProvider.i("atlantis:cooked_shrimp"), (float)0.5f, (int)300).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:shrimp")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:shrimp"))).save(out, Atlantis.id("shrimp_from_campfire_cooking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:shrimp")}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)AtlantisRecipeProvider.i("atlantis:cooked_shrimp"), (float)0.5f, (int)50).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i("atlantis:shrimp")), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:shrimp"))).save(out, Atlantis.id("shrimp_from_smoking"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_blend"), (int)3).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_copper")).requires(AtlantisRecipeProvider.i("minecraft:raw_gold")).requires(AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).unlockedBy("has_orichalcum_blend", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:raw_copper"))).save(out, Atlantis.id("orichalcum_blend"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_block"), (int)1).pattern("XX").pattern("XX").define(Character.valueOf('X'), AtlantisRecipeProvider.i("atlantis:orichalcum_ingot")).unlockedBy("has_orichalcum_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_ingot"))).save(out, Atlantis.id("orichalcum_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:orichalcum_upgrade_smithing_template"), (int)2).pattern("SCS").pattern("SWS").pattern("SSS").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:aquamarine_gem")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:orichalcum_ingot")).define(Character.valueOf('C'), AtlantisRecipeProvider.i("atlantis:orichalcum_upgrade_smithing_template")).unlockedBy("has_orichalcum_upgrade_smithing_template", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:aquamarine_gem"))).save(out, Atlantis.id("orichalcum_upgrade_smithing_template"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:palm_boat"), (int)1).pattern("   ").pattern("S S").pattern("SSS").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:palm_planks")).unlockedBy("has_palm_boat", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:palm_planks"))).save(out, Atlantis.id("palm_boat"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:palm_planks"), (int)4).requires(AtlantisRecipeProvider.i("atlantis:palm_log")).unlockedBy("has_palm_log", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:palm_log"))).save(out, Atlantis.id("palm_log"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:palm_sign"), (int)2).pattern("SSS").pattern("SSS").pattern(" W ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:stick")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:palm_planks")).unlockedBy("has_palm_sign", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:stick"))).save(out, Atlantis.id("palm_sign"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:pink_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_pink_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:pink_dye"))).save(out, Atlantis.id("pink_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:pink_dye")).unlockedBy("has_pink_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("pink_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:pink_sea_glass")).unlockedBy("has_pink_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:pink_sea_glass")).unlockedBy("has_pink_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:pink_sea_glass")).unlockedBy("has_pink_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:pink_sea_glass")).unlockedBy("has_pink_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:pink_sea_glass"))).save(out, Atlantis.id("pink_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:pink_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:pink_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_pink_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:pink_dye"))).save(out, Atlantis.id("pink_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:purple_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_purple_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:purple_dye"))).save(out, Atlantis.id("purple_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:purple_dye")).unlockedBy("has_purple_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("purple_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:purple_sea_glass")).unlockedBy("has_purple_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:purple_sea_glass")).unlockedBy("has_purple_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:purple_sea_glass")).unlockedBy("has_purple_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:purple_sea_glass")).unlockedBy("has_purple_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:purple_sea_glass"))).save(out, Atlantis.id("purple_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:purple_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:purple_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_purple_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:purple_dye"))).save(out, Atlantis.id("purple_shell_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:red_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_red_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:red_dye"))).save(out, Atlantis.id("red_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:red_dye")).unlockedBy("has_red_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("red_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:red_sea_glass")).unlockedBy("has_red_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:red_sea_glass")).unlockedBy("has_red_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:red_sea_glass")).unlockedBy("has_red_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:red_sea_glass")).unlockedBy("has_red_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:red_sea_glass"))).save(out, Atlantis.id("red_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:red_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:red_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_red_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:red_dye"))).save(out, Atlantis.id("red_shell_block"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:salty_seawater_bucket")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:seasalt"), (float)0.25f, (int)150).unlockedBy("has_salt_from_smelting", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:salty_seawater_bucket"))).save(out, Atlantis.id("salt_from_smelting"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:satire_lantern"), (int)1).pattern("A").pattern("B").define(Character.valueOf('A'), AtlantisRecipeProvider.i("atlantis:carved_coconut")).define(Character.valueOf('B'), AtlantisRecipeProvider.i("minecraft:torch")).unlockedBy("has_satire_lantern", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:carved_coconut"))).save(out, Atlantis.id("satire_lantern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:seasalt_chunk"), (int)1).pattern("SS ").pattern("SS ").pattern("   ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:seasalt")).unlockedBy("has_seasalt_chunk", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:seasalt"))).save(out, Atlantis.id("seasalt_chunk"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).unlockedBy("has_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:sea_glass")).unlockedBy("has_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:sea_glass")).unlockedBy("has_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:sea_glass")).unlockedBy("has_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("sea_glass_wall"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i("atlantis:shrimp")}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:cooked_shrimp"), (float)0.5f, (int)200).unlockedBy("has_shrimp_from_smelting", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:shrimp"))).save(out, Atlantis.id("shrimp_from_smelting"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:snown_pot"), (int)1).pattern("TNA").pattern("NNN").pattern("TNA").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_snown_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("snown_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sodium_bomb"), (int)1).pattern(" S ").pattern("STS").pattern(" S ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:sodium_nugget")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:tnt")).unlockedBy("has_sodium_bomb", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sodium_nugget"))).save(out, Atlantis.id("sodium_bomb"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:nymph_planks"), (int)4).requires(AtlantisRecipeProvider.i("atlantis:stripped_nymph_log")).unlockedBy("has_stripped_atlantean_log", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:stripped_nymph_log"))).save(out, Atlantis.id("stripped_atlantean_log"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:palm_planks"), (int)4).requires(AtlantisRecipeProvider.i("atlantis:stripped_palm_log")).unlockedBy("has_stripped_palm_log", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:stripped_palm_log"))).save(out, Atlantis.id("stripped_palm_log"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:submarine"), (int)1).pattern(" IC").pattern("IIC").pattern("CCV").define(Character.valueOf('C'), AtlantisRecipeProvider.i("minecraft:raw_iron_block")).define(Character.valueOf('I'), AtlantisRecipeProvider.i("minecraft:glass")).define(Character.valueOf('V'), AtlantisRecipeProvider.i("atlantis:orb_of_atlantis")).unlockedBy("has_submarine", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:raw_iron_block"))).save(out, Atlantis.id("submarine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:sunken_gravel"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:ocean_stone")).requires(AtlantisRecipeProvider.i("minecraft:gravel")).unlockedBy("has_sunken_gravel", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_stone"))).save(out, Atlantis.id("sunken_gravel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:surge_lantern"), (int)2).pattern("   ").pattern("WSW").pattern("   ").define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ocean_lantern")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_surge_lantern", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:ocean_lantern"))).save(out, Atlantis.id("surge_lantern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:toper_pot"), (int)1).pattern("ANA").pattern("TNT").pattern("TNT").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_toper_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("toper_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:tuben_pot"), (int)1).pattern("TNT").pattern("ANA").pattern("TNT").define(Character.valueOf('N'), AtlantisRecipeProvider.i("atlantis:broken_shells")).define(Character.valueOf('T'), AtlantisRecipeProvider.i("minecraft:brick")).define(Character.valueOf('A'), AtlantisRecipeProvider.i("minecraft:clay")).unlockedBy("has_tuben_pot", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:broken_shells"))).save(out, Atlantis.id("tuben_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:waterfall_block"), (int)3).pattern("CWC").pattern("CWC").pattern("CCC").define(Character.valueOf('C'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_waterfall_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_crystal"))).save(out, Atlantis.id("waterfall_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:water_pill"), (int)1).pattern("WSW").pattern("SWS").pattern("WSW").define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:sugar")).define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:kelp")).unlockedBy("has_water_pill", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:sugar"))).save(out, Atlantis.id("water_pill"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:wave_block"), (int)3).pattern("CWC").pattern("WCW").pattern("CWC").define(Character.valueOf('C'), AtlantisRecipeProvider.i("atlantis:atlantean_crystal")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_wave_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:atlantean_crystal"))).save(out, Atlantis.id("wave_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_shell_block"), (int)2).pattern(" O ").pattern("SWS").pattern(" O ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:white_dye")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("minecraft:stone")).define(Character.valueOf('O'), AtlantisRecipeProvider.i("atlantis:ocean_stone")).unlockedBy("has_white_colored_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:white_dye"))).save(out, Atlantis.id("white_colored_shell_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_pearl_block"), (int)2).pattern(" S ").pattern("SWS").pattern(" S ").define(Character.valueOf('S'), AtlantisRecipeProvider.i("minecraft:white_dye")).define(Character.valueOf('W'), AtlantisRecipeProvider.i("atlantis:hardened_calcite_block")).unlockedBy("has_white_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:white_dye"))).save(out, Atlantis.id("white_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:white_dye")).unlockedBy("has_white_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("white_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:white_sea_glass")).unlockedBy("has_white_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:white_sea_glass")).unlockedBy("has_white_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:white_sea_glass")).unlockedBy("has_white_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:white_sea_glass")).unlockedBy("has_white_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:white_sea_glass"))).save(out, Atlantis.id("white_sea_glass_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:writing_table"), (int)1).pattern("XXX").pattern("YZY").pattern("XXX").define(Character.valueOf('X'), AtlantisRecipeProvider.i("atlantis:fire_melon_spike")).define(Character.valueOf('Y'), AtlantisRecipeProvider.i("minecraft:book")).define(Character.valueOf('Z'), AtlantisRecipeProvider.i("minecraft:crafting_table")).unlockedBy("has_writing_table", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:fire_melon_spike"))).save(out, Atlantis.id("writing_table"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_pearl_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:yellow_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_pearl_block")).unlockedBy("has_yellow_pearl_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:yellow_dye"))).save(out, Atlantis.id("yellow_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:sea_glass")).requires(AtlantisRecipeProvider.i("minecraft:yellow_dye")).unlockedBy("has_yellow_sea_glass", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:sea_glass"))).save(out, Atlantis.id("yellow_sea_glass"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_button"), (int)1).requires(AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")).unlockedBy("has_yellow_sea_glass_button", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_pressure_plate"), (int)1).pattern("##").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")).unlockedBy("has_yellow_sea_glass_pressure_plate", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_pressure_plate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_slab"), (int)6).pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")).unlockedBy("has_yellow_sea_glass_slab", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass_wall"), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), AtlantisRecipeProvider.i("atlantis:yellow_sea_glass")).unlockedBy("has_yellow_sea_glass_wall", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_sea_glass"))).save(out, Atlantis.id("yellow_sea_glass_wall"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AtlantisRecipeProvider.i("atlantis:yellow_shell_block"), (int)1).requires(AtlantisRecipeProvider.i("minecraft:yellow_dye")).requires(AtlantisRecipeProvider.i("atlantis:white_shell_block")).unlockedBy("has_yellow_shell_block", AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i("minecraft:yellow_dye"))).save(out, Atlantis.id("yellow_shell_block"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()), (float)0.7f, (int)200).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()))).save(out, Atlantis.id(((Item)ItemInit.ANCIENT_CUPRUM_INGOT.get()).getDescriptionId().replace("item.atlantis.", "") + "_smelting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()), (float)0.7f, (int)100).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()))).save(out, Atlantis.id(((Item)ItemInit.ANCIENT_CUPRUM_INGOT.get()).getDescriptionId().replace("item.atlantis.", "") + "_blasting"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.RAW_ANCIENT_CUPRUM.get()))).save(out, Atlantis.id(((Block)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK.get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
    }

    private static void registerWood(BlockType blockType, RecipeOutput out) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.button().get())).requires((ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((ButtonBlock)blockType.button().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.door().get()), (int)6).pattern("## ").pattern("## ").pattern("## ").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((DoorBlock)blockType.door().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.trapDoor().get()), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((TrapDoorBlock)blockType.trapDoor().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.slab().get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((SlabBlock)blockType.slab().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.stairs().get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((StairBlock)blockType.stairs().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.fence().get()), (int)3).pattern("#W#").pattern("#W#").define(Character.valueOf('W'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((FenceBlock)blockType.fence().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.fenceGate().get()), (int)1).pattern("#W#").pattern("#W#").define(Character.valueOf('W'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((FenceGateBlock)blockType.fenceGate().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)blockType.pressurePlate().get()), (int)1).pattern("## ").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((PressurePlateBlock)blockType.pressurePlate().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
    }

    private static void registerSeaGlass(RecipeOutput out) {
        for (DyeColor color : DyeColor.values()) {
            BlockType blockType = BlockInit.SEA_GLASS_PATTERNS.get(color);
            BlockType base = BlockInit.SEA_GLASS_LIST.get(color);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)base.stairs().get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)base.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((Block)base.block().get()).asItem()), AtlantisRecipeProvider.has((ItemLike)((Block)base.block().get()).asItem())).save(out, Atlantis.id(((StairBlock)base.stairs().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.block().get()), (int)4).pattern("## ").pattern("## ").pattern("   ").define(Character.valueOf('#'), (ItemLike)base.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((Block)base.block().get()).asItem()), AtlantisRecipeProvider.has((ItemLike)((Block)base.block().get()).asItem())).save(out, Atlantis.id(((Block)blockType.block().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.button().get())).requires((ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((ButtonBlock)blockType.button().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.slab().get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((SlabBlock)blockType.slab().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.stairs().get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((StairBlock)blockType.stairs().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockType.wall().get()), (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((WallBlock)blockType.wall().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)blockType.pressurePlate().get()), (int)1).pattern("## ").define(Character.valueOf('#'), (ItemLike)blockType.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)blockType.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)blockType.block().get()))).save(out, Atlantis.id(((PressurePlateBlock)blockType.pressurePlate().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        }
    }

    private static void registerGroup(TrailsGroup group, RecipeOutput out) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.bulb().get()), (int)1).pattern(" # ").pattern("#X#").pattern(" R ").define(Character.valueOf('#'), (ItemLike)group.block().get()).define(Character.valueOf('X'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumBulbBlock)group.bulb().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.block().get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)group.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumFullBlock)group.block().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.cut().get()), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)group.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumFullBlock)group.cut().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.cut_slab().get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)group.cut().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumSlabBlock)group.cut_slab().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.cut_stairs().get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)group.cut().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumStairsBlock)group.cut_stairs().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.chiseled().get()), (int)1).pattern(" # ").pattern(" # ").pattern("   ").define(Character.valueOf('#'), (ItemLike)group.cut_slab().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumFullBlock)group.chiseled().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.door().get()), (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumDoorBlock)group.door().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.trapdoor().get()), (int)2).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumTrapdoorBlock)group.trapdoor().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.grate().get()), (int)3).pattern(" # ").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)group.block().get()).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.ANCIENT_CUPRUM_INGOT.get()))).save(out, Atlantis.id(((WeatheringCuprumGrateBlock)group.grate().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_block().get()), (int)1).requires((ItemLike)group.block().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.block().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.block().get()))).save(out, Atlantis.id(((Block)group.waxed_block().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_cut().get()), (int)1).requires((ItemLike)group.cut().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.cut().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.cut().get()))).save(out, Atlantis.id(((Block)group.waxed_cut().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_chiseled().get()), (int)1).requires((ItemLike)group.chiseled().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.chiseled().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.chiseled().get()))).save(out, Atlantis.id(((Block)group.waxed_chiseled().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_cut_slab().get()), (int)1).requires((ItemLike)group.cut_slab().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.cut_slab().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.cut_slab().get()))).save(out, Atlantis.id(((SlabBlock)group.waxed_cut_slab().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_cut_stairs().get()), (int)1).requires((ItemLike)group.cut_stairs().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.cut_stairs().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.cut_stairs().get()))).save(out, Atlantis.id(((StairBlock)group.waxed_cut_stairs().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.waxed_door().get()), (int)1).requires((ItemLike)group.door().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.door().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.door().get()))).save(out, Atlantis.id(((DoorBlock)group.waxed_door().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.waxed_trapdoor().get()), (int)1).requires((ItemLike)group.trapdoor().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.trapdoor().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.trapdoor().get()))).save(out, Atlantis.id(((TrapDoorBlock)group.waxed_trapdoor().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)group.waxed_grate().get()), (int)1).requires((ItemLike)group.grate().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.grate().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.grate().get()))).save(out, Atlantis.id(((Block)group.waxed_grate().get()).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)group.waxed_bulb().get()), (int)1).requires((ItemLike)group.bulb().get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)group.bulb().get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)group.bulb().get()))).save(out, Atlantis.id(((CuprumBulbBlock)((Object)group.waxed_bulb().get())).getDescriptionId().replace("block.atlantis.", "") + "_recipe"));
    }

    private static void glyphScroll(RecipeOutput out, ItemLike result, Ingredient material) {
        AtlantisRecipeProvider.writing(material, RecipeCategory.MISC, result, 1).unlockedBy(AtlantisRecipeProvider.getHasName((ItemLike)((ItemLike)ItemInit.LINGUISTIC_GLYPH_SCROLL.get())), AtlantisRecipeProvider.has((ItemLike)((ItemLike)ItemInit.LINGUISTIC_GLYPH_SCROLL.get()))).save(out, AtlantisRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)((ItemLike)ItemInit.LINGUISTIC_GLYPH_SCROLL.get())) + "_writing");
    }

    public static SingleItemRecipeBuilder writing(Ingredient ingredient, RecipeCategory category, ItemLike result, int count) {
        return new SingleItemRecipeBuilder(category, WritingRecipe::new, ingredient, result, count);
    }

    private static ItemLike i(String id) {
        HolderLookup.Provider lookupRegister = lookup.getNow(null);
        if (lookupRegister == null) {
            throw new IllegalStateException("HolderLookup not ready yet");
        }
        ResourceLocation rl = ResourceLocation.parse((String)id);
        ResourceKey key = Registries.ITEM;
        HolderLookup.RegistryLookup registryLookup = lookupRegister.lookupOrThrow(key);
        ResourceKey itemKey = ResourceKey.create((ResourceKey)key, (ResourceLocation)rl);
        return (ItemLike)registryLookup.getOrThrow(itemKey).value();
    }

    private static void smithingTransform(RecipeOutput out, String name, String template, String base, String addition, String result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i(template)}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i(base)}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtlantisRecipeProvider.i(addition)}), (RecipeCategory)RecipeCategory.COMBAT, (Item)AtlantisRecipeProvider.i(result).asItem()).unlocks(AtlantisRecipeProvider.getHasName((ItemLike)AtlantisRecipeProvider.i(base)), AtlantisRecipeProvider.has((ItemLike)AtlantisRecipeProvider.i(base))).save(out, Atlantis.id(name + "_smithing"));
    }
}

