/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.datagen.PlacedFeatureInit;
import com.mystic.atlantis.init.AtlantisEntityInit;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class BiomeInit {
    public static final ResourceKey<Biome> ATLANTEAN_GARDEN_KEY = BiomeInit.key("atlantean_garden");
    public static final ResourceKey<Biome> ATLANTEAN_ISLANDS_BIOME_KEY = BiomeInit.key("atlantean_islands_biome");
    public static final ResourceKey<Biome> ATLANTIS_BIOME_KEY = BiomeInit.key("atlantis_biome");
    public static final ResourceKey<Biome> COCONUT_ISLES_KEY = BiomeInit.key("coconut_isles");
    public static final ResourceKey<Biome> GOO_LAGOONS_KEY = BiomeInit.key("goo_lagoons");
    public static final ResourceKey<Biome> AQUAIEL_JELLYFISH_FIELDS_KEY = BiomeInit.key("aquariel_jellyfish_fields");
    public static final ResourceKey<Biome> VOLCANIC_DARKSEA_KEY = BiomeInit.key("volcanic_darksea");
    private final BootstrapContext<Biome> context;

    public static ResourceKey<Biome> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Atlantis.id(name));
    }

    public BiomeInit(BootstrapContext<Biome> context) {
        this.context = context;
        HolderGetter holdergetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter holdergetter1 = context.lookup(Registries.CONFIGURED_CARVER);
        this.register(ATLANTEAN_GARDEN_KEY, new Biome.BiomeBuilder().temperature(0.4f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 3)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 4)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 4, 6)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.GARDEN_FOLIAGE_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.NYMPH_TREE_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(ATLANTEAN_ISLANDS_BIOME_KEY, new Biome.BiomeBuilder().temperature(0.5f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 4, 6)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 25, 4, 6)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 3)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 4)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 4, 6)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.RAW_GENERATION, PlacedFeatureInit.ISLANDS_PLACED).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, PlacedFeatureInit.SALT_ROCK_GEODE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(ATLANTIS_BIOME_KEY, new Biome.BiomeBuilder().temperature(0.5f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 2, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 2, 2)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, PlacedFeatureInit.SALT_ROCK_GEODE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(COCONUT_ISLES_KEY, new Biome.BiomeBuilder().temperature(0.7f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.COCONUT_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 2, 2)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.PALM_TREE_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(GOO_LAGOONS_KEY, new Biome.BiomeBuilder().temperature(0.5f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 2, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 2, 2)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.SALTY_SEA_LAKE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(AQUAIEL_JELLYFISH_FIELDS_KEY, new Biome.BiomeBuilder().temperature(0.5f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 2, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), 25, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.LEVIATHAN.get(), 25, 2, 2)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
        this.register(VOLCANIC_DARKSEA_KEY, new Biome.BiomeBuilder().temperature(0.4f).downfall(0.0f).hasPrecipitation(false).specialEffects(new BiomeSpecialEffects.Builder().skyColor(27571).fogColor(59110).waterColor(6072508).waterFogColor(6072508).grassColorOverride(0x66FF00).foliageColorOverride(5373696).ambientMoodSound(new AmbientMoodSettings(Holder.direct((Object)SoundEvents.AMBIENT_UNDERWATER_LOOP), 6000, 8, 2.0)).build()).mobSpawnSettings(new MobSpawnSettings.Builder().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 25, 2, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), 25, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.STARFISH.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), 25, 2, 4)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtlantisEntityInit.LEVIATHAN.get(), 25, 2, 2)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 2, 2)).build()).generationSettings(new BiomeGenerationSettings.Builder(holdergetter, holdergetter1).addFeature(GenerationStep.Decoration.RAW_GENERATION, PlacedFeatureInit.VOLCANOES_PLACED).addFeature(GenerationStep.Decoration.RAW_GENERATION, PlacedFeatureInit.GLOWSTONES_PLACED).addFeature(GenerationStep.Decoration.LAKES, PlacedFeatureInit.JETSTREAM_LAKE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COPPER_LARGE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_ANDESITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_CLAY).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_COAL_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIAMOND_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_DIORITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GOLD_EXTRA).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_GRANITE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_IRON_MIDDLE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_LAPIS_BURIED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_REDSTONE_LOWER).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.ORE_TUFF).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.ANCIENT_CUPRUM_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.AQUAMARINE_PLACED).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, PlacedFeatureInit.SUNKEN_GRAVEL_PLACED).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SIMPLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureInit.SEABLOOM_PLACED).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, CavePlacements.UNDERWATER_MAGMA).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, CavePlacements.FOSSIL_UPPER).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacedFeatureInit.SHELL_BLOCK_PLACED).build()).build());
    }

    private void register(ResourceKey<Biome> key, Biome biome) {
        this.context.register(key, (Object)biome);
    }
}

