/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.init.BlockInit;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseSettingsInit {
    private static HolderGetter<NormalNoise.NoiseParameters> noiseRegistry = null;
    private static HolderGetter<DensityFunction> functionRegistry = null;

    public NoiseSettingsInit(BootstrapContext<NoiseGeneratorSettings> context) {
        noiseRegistry = context.lookup(Registries.NOISE);
        functionRegistry = context.lookup(Registries.DENSITY_FUNCTION);
        context.register(AtlantisDimensions.ATLANTIS_DIMENSION_NOISE_SETTING, (Object)new NoiseGeneratorSettings(new NoiseSettings(-64, 512, 1, 2), Blocks.STONE.defaultBlockState(), (BlockState)Blocks.WATER.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(0)), new NoiseRouter(NoiseSettingsInit.noise(NoiseSettingsInit.parameters((ResourceKey<NormalNoise.NoiseParameters>)Noises.AQUIFER_BARRIER), 1.0, 0.5), NoiseSettingsInit.noise(NoiseSettingsInit.parameters((ResourceKey<NormalNoise.NoiseParameters>)Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), 1.0, 0.67), NoiseSettingsInit.noise(NoiseSettingsInit.parameters((ResourceKey<NormalNoise.NoiseParameters>)Noises.AQUIFER_FLUID_LEVEL_SPREAD), 1.0, 0.7142857142857143), DensityFunctions.zero(), NoiseSettingsInit.shiftedNoise2d(NoiseSettingsInit.parameters((ResourceKey<NormalNoise.NoiseParameters>)Noises.TEMPERATURE)), NoiseSettingsInit.shiftedNoise2d(NoiseSettingsInit.parameters((ResourceKey<NormalNoise.NoiseParameters>)Noises.VEGETATION)), NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.CONTINENTS), NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.EROSION), NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.DEPTH), NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.RIDGES), DensityFunctions.zero(), DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.64), (DensityFunction)DensityFunctions.interpolated((DensityFunction)DensityFunctions.blendDensity((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)2.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)70, (int)0, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-2.77), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)2.0), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)70, (int)0, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-2.0), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)350, (int)450, (double)1.0, (double)0.0), (DensityFunction)NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.BASE_3D_NOISE_OVERWORLD))))))))))).squeeze(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero()), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NoiseSettingsInit.conditionalVerticalBlockPlacement("minecraft:bedrock_floor", -55, -54, Blocks.BEDROCK), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NoiseSettingsInit.conditionalVerticalBlockPlacement("atlantis:deepslate_layer", 4, 5, (BlockState)Blocks.DEEPSLATE.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X)), NoiseSettingsInit.conditionalVerticalBlockPlacement("atlantis:stone_layer", 33, 34, Blocks.STONE), NoiseSettingsInit.conditionalVerticalBlockPlacement("atlantis:detritus_sandstone_layer", 55, 56, (Block)BlockInit.DETRITUS_SANDSTONE.get()), NoiseSettingsInit.conditionalVerticalBlockPlacement("atlantis:sandstone_layer", 199, 200, Blocks.SANDSTONE), NoiseSettingsInit.conditionalVerticalBlockPlacement("atlantis:seabed_layer", 511, 512, (Block)BlockInit.SEABED.get())})}), List.of(), 512, false, true, true, false));
    }

    private static SurfaceRules.RuleSource block(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static DensityFunction noise(Holder<NormalNoise.NoiseParameters> parameter, double xz_scale, double y_scale) {
        return DensityFunctions.noise(parameter, (double)xz_scale, (double)y_scale);
    }

    private static SurfaceRules.RuleSource conditionalVerticalBlockPlacement(String name, int min, int max, BlockState state) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)name, (VerticalAnchor)VerticalAnchor.absolute((int)min), (VerticalAnchor)VerticalAnchor.absolute((int)max)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)state));
    }

    private static DensityFunction function(ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)functionRegistry.getOrThrow(key));
    }

    private static Holder<NormalNoise.NoiseParameters> parameters(ResourceKey<NormalNoise.NoiseParameters> key) {
        return noiseRegistry.getOrThrow(key);
    }

    private static SurfaceRules.RuleSource conditionalVerticalBlockPlacement(String name, int min, int max, Block block) {
        return NoiseSettingsInit.conditionalVerticalBlockPlacement(name, min, max, block.defaultBlockState());
    }

    private static DensityFunction shiftedNoise2d(Holder<NormalNoise.NoiseParameters> noise) {
        return DensityFunctions.shiftedNoise2d((DensityFunction)NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.SHIFT_X), (DensityFunction)NoiseSettingsInit.function((ResourceKey<DensityFunction>)NoiseRouterData.SHIFT_Z), (double)0.25, noise);
    }
}

