/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.JukeboxSongsInit;
import com.mystic.atlantis.datagen.AtlantisBlockModelProvider;
import com.mystic.atlantis.datagen.AtlantisBlockStateProvider;
import com.mystic.atlantis.datagen.AtlantisBlockTagsProvider;
import com.mystic.atlantis.datagen.AtlantisEnglishLanguageProvider;
import com.mystic.atlantis.datagen.AtlantisFluidTagsProvider;
import com.mystic.atlantis.datagen.AtlantisItemModelProvider;
import com.mystic.atlantis.datagen.AtlantisItemTagsProvider;
import com.mystic.atlantis.datagen.AtlantisLootTableProvider;
import com.mystic.atlantis.datagen.AtlantisMainProvider;
import com.mystic.atlantis.datagen.AtlantisRecipeProvider;
import com.mystic.atlantis.datagen.BiomeInit;
import com.mystic.atlantis.datagen.ConfiguredFeaturesInit;
import com.mystic.atlantis.datagen.EnchantmentInit;
import com.mystic.atlantis.datagen.NoiseSettingsInit;
import com.mystic.atlantis.datagen.PlacedFeatureInit;
import com.mystic.atlantis.datagen.ProcessorListInit;
import com.mystic.atlantis.datagen.StructureInit;
import com.mystic.atlantis.datagen.TemplatePoolInit;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.init.AtlantisModifierInit;
import com.mystic.atlantis.init.PaintingVariantsInit;
import java.util.OptionalLong;
import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class Providers {
    public static void init(IEventBus bus) {
        bus.addListener(Providers::dataGather);
    }

    public static void dataGather(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        DatapackBuiltinEntriesProvider registryProvider = new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), new RegistrySetBuilder().add(Registries.ENCHANTMENT, EnchantmentInit::new).add(Registries.CONFIGURED_FEATURE, ConfiguredFeaturesInit::new).add(Registries.PLACED_FEATURE, PlacedFeatureInit::new).add(Registries.BIOME, BiomeInit::new).add(Registries.LEVEL_STEM, AtlantisDimensions::new).add(Registries.DIMENSION_TYPE, context -> context.register(AtlantisDimensions.ATLANTIS_DIMENSION_TYPE_KEY, (Object)new DimensionType(OptionalLong.empty(), true, false, false, false, 1.0, true, true, -64, 512, 512, BlockTags.INFINIBURN_OVERWORLD, AtlantisDimensions.ATLANTIS_DIMENSION_EFFECT, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 0)))).add(Registries.PROCESSOR_LIST, ProcessorListInit::new).add(Registries.TEMPLATE_POOL, TemplatePoolInit::new).add(Registries.NOISE_SETTINGS, NoiseSettingsInit::new).add(Registries.STRUCTURE, StructureInit::new).add(Registries.PAINTING_VARIANT, PaintingVariantsInit::init).add(Registries.JUKEBOX_SONG, JukeboxSongsInit::new), Set.of("atlantis"));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new AtlantisModifierInit.DataProvider(event.getGenerator(), event.getLookupProvider(), "atlantis"));
        event.getGenerator().addProvider(true, (DataProvider)registryProvider);
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisBlockModelProvider(output, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisMainProvider(output, event.getExistingFileHelper(), AtlantisBlockStateProvider::new));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisItemModelProvider(output, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisEnglishLanguageProvider(output));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisLootTableProvider(output, event.getLookupProvider()));
        AtlantisBlockTagsProvider blockTags = new AtlantisBlockTagsProvider(output, event.getLookupProvider(), "atlantis");
        event.getGenerator().addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisItemTagsProvider(output, event.getLookupProvider(), blockTags, "atlantis"));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisFluidTagsProvider(output, event.getLookupProvider(), "atlantis", event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new AtlantisRecipeProvider(output, event.getLookupProvider()));
    }
}

