/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mojang.datafixers.util.Pair;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.datagen.ProcessorListInit;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TemplatePoolInit {
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_VILLAGE_DECOS = TemplatePoolInit.key("atlantean_village/decos");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_VILLAGE_HOUSE = TemplatePoolInit.key("atlantean_village/house");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_VILLAGE_ROADS = TemplatePoolInit.key("atlantean_village/roads");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_VILLAGE_START = TemplatePoolInit.key("atlantean_village/start");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_VILLAGE_TERMINATOR = TemplatePoolInit.key("atlantean_village/terminator");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_FOUNTAIN = TemplatePoolInit.key("atlantean_fountain");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_SPIRE = TemplatePoolInit.key("atlantean_spire");
    public static final ResourceKey<StructureTemplatePool> ATLANTEAN_TEMPLE = TemplatePoolInit.key("atlantean_temple");
    public static final ResourceKey<StructureTemplatePool> ATLANTIS_HOUSE_1 = TemplatePoolInit.key("atlantis_house_1");
    public static final ResourceKey<StructureTemplatePool> ATLANTIS_HOUSE_3 = TemplatePoolInit.key("atlantis_house_3");
    public static final ResourceKey<StructureTemplatePool> ATLANTIS_TOWER = TemplatePoolInit.key("atlantis_tower");
    public static final ResourceKey<StructureTemplatePool> OYSTER_STRUCTURE = TemplatePoolInit.key("oyster_structure");
    private final HolderGetter<StructureProcessorList> listRegistry;
    private HolderGetter<StructureTemplatePool> templateRegistry;
    private BootstrapContext<StructureTemplatePool> context;

    public static ResourceKey<StructureTemplatePool> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)Atlantis.id(name));
    }

    public TemplatePoolInit(BootstrapContext<StructureTemplatePool> context) {
        this.context = context;
        this.templateRegistry = context.lookup(Registries.TEMPLATE_POOL);
        this.listRegistry = context.lookup(Registries.PROCESSOR_LIST);
        this.register(ATLANTEAN_VILLAGE_DECOS, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_village/decos/lamp_1"), this.single("atlantis:atlantean_village/decos/lamp_2"), this.single("atlantis:atlantean_village/decos/lamp_3"), this.single("atlantis:atlantean_village/decos/lamp_4"), this.single("atlantis:atlantean_village/deco/beekeeper"), this.single("atlantis:atlantean_village/deco/copper_golem"), this.empty(5));
        this.register(ATLANTEAN_VILLAGE_HOUSE, ATLANTEAN_VILLAGE_DECOS, this.single("atlantis:atlantean_village/house/house_1", 20), this.single("atlantis:atlantean_village/house/house_2", 20), this.single("atlantis:atlantean_village/house/house_3", 20), this.single("atlantis:atlantean_village/house/house_4", 20), this.single("atlantis:atlantean_village/jobsite/butcher", 5), this.single("atlantis:atlantean_village/jobsite/cartographer", 5), this.single("atlantis:atlantean_village/jobsite/library", 5), this.single("atlantis:atlantean_village/jobsite/mason", 5), this.single("atlantis:atlantean_village/jobsite/pen", 5), this.single("atlantis:atlantean_village/jobsite/shepherd", 5), this.single("atlantis:atlantean_village/jobsite/smith", 5), this.single("atlantis:atlantean_village/jobsite/pen", 2), this.single("atlantis:atlantean_village/jobsite/farm", ProcessorListInit.ATLANTEAN_VILLAGE_FARM, 2), this.single("atlantis:atlantean_village/jobsite/engineer", 5), this.single("atlantis:atlantean_village/jobsite/garden", 5), this.single("atlantis:atlantean_village/jobsite/hunter", 5), this.single("atlantis:atlantean_village/jobsite/oceanographer", 5), this.single("atlantis:atlantean_village/jobsite/woodworker", 5), this.single("atlantis:atlantean_village/jobsite/chicken_coop", 2), this.single("atlantis:atlantean_village/jobsite/imengineer", 5), this.single("atlantis:atlantean_village/jobsite/hunter_trainer", 5), this.single("atlantis:atlantean_village/jobsite/restaurant", 5), this.single("atlantis:atlantean_village/jobsite/botanist", 5));
        this.register(ATLANTEAN_VILLAGE_TERMINATOR, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_village/roads/terminator", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS, 1, StructureTemplatePool.Projection.TERRAIN_MATCHING));
        this.register(ATLANTEAN_VILLAGE_ROADS, ATLANTEAN_VILLAGE_TERMINATOR, this.single("atlantis:atlantean_village/roads/straight", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS, 4), this.single("atlantis:atlantean_village/roads/t_1", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS), this.single("atlantis:atlantean_village/roads/t_2", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS), this.single("atlantis:atlantean_village/roads/t_3", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS), this.single("atlantis:atlantean_village/roads/bent_1", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS), this.single("atlantis:atlantean_village/roads/bent_2", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS), this.single("atlantis:atlantean_village/roads/inter", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS));
        this.register(ATLANTEAN_VILLAGE_START, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_village/town_center", ProcessorListInit.ATLANTEAN_VILLAGE_ROADS));
        this.register(ATLANTEAN_FOUNTAIN, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_fountain"));
        this.register(ATLANTEAN_TEMPLE, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_temple"));
        this.register(ATLANTEAN_SPIRE, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantean_spire"));
        this.register(ATLANTIS_HOUSE_1, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantis_house_1"));
        this.register(ATLANTIS_HOUSE_3, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantis_house_3"));
        this.register(ATLANTIS_TOWER, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:atlantis_tower"));
        this.register(OYSTER_STRUCTURE, (ResourceKey<StructureTemplatePool>)Pools.EMPTY, this.single("atlantis:oyster_structure"));
    }

    private Pair<StructurePoolElement, Integer> empty(int weight) {
        return new Pair((Object)((StructurePoolElement)EmptyPoolElement.empty().apply(StructureTemplatePool.Projection.RIGID)), (Object)weight);
    }

    @SafeVarargs
    private void register(ResourceKey<StructureTemplatePool> key, ResourceKey<StructureTemplatePool> fallback, Pair<StructurePoolElement, Integer> ... pairs) {
        this.context.register(key, (Object)new StructureTemplatePool(this.pool(fallback), List.of(pairs)));
    }

    private Pair<StructurePoolElement, Integer> single(String name) {
        return this.single(name, 1);
    }

    private Pair<StructurePoolElement, Integer> single(String name, ResourceKey<StructureProcessorList> processList, int weight, StructureTemplatePool.Projection projection) {
        return new Pair((Object)((StructurePoolElement)SinglePoolElement.single((String)name, (Holder)this.listRegistry.getOrThrow(processList)).apply(projection)), (Object)weight);
    }

    private Pair<StructurePoolElement, Integer> single(String name, ResourceKey<StructureProcessorList> processList, int weight) {
        return this.single(name, processList, weight, StructureTemplatePool.Projection.RIGID);
    }

    private Pair<StructurePoolElement, Integer> single(String name, int weight) {
        return new Pair((Object)((StructurePoolElement)SinglePoolElement.single((String)name).apply(StructureTemplatePool.Projection.RIGID)), (Object)weight);
    }

    private Pair<StructurePoolElement, Integer> single(String name, ResourceKey<StructureProcessorList> processList) {
        return new Pair((Object)((StructurePoolElement)SinglePoolElement.single((String)name, (Holder)this.listRegistry.getOrThrow(processList)).apply(StructureTemplatePool.Projection.RIGID)), (Object)1);
    }

    private Holder<StructureTemplatePool> pool(ResourceKey<StructureTemplatePool> key) {
        return this.templateRegistry.getOrThrow(key);
    }
}

