/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.dimension;

import com.mystic.atlantis.blocks.base.AtlanteanPortalBlock;
import com.mystic.atlantis.blocks.base.AtlanteanPortalFrame;
import com.mystic.atlantis.blocks.base.HardenedCalciteBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.POITypesInit;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class AtlanteanPortalForcer {
    private static final DirectionProperty FACING = AtlanteanPortalFrame.FACING;
    private static final BooleanProperty HAS_EYE = AtlanteanPortalFrame.HAS_EYE;
    protected final ServerLevel level;

    public AtlanteanPortalForcer(ServerLevel pLevel) {
        this.level = pLevel;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos pPos, boolean isInAtlantis, WorldBorder pWorldBorder) {
        PoiManager poimanager = this.level.getPoiManager();
        int i = isInAtlantis ? 16 : 128;
        poimanager.ensureLoadedAndValid((LevelReader)this.level, pPos, i);
        Optional<PoiRecord> optional = poimanager.getInSquare(p_230634_ -> POITypesInit.ATLANTEAN_PORTAL.get() == p_230634_.value(), pPos, i, PoiManager.Occupancy.ANY).filter(p_192981_ -> pWorldBorder.isWithinBounds(p_192981_.getPos())).filter(p_192990_ -> this.level.getBlockState(p_192990_.getPos()).hasProperty(AtlanteanPortalBlock.AXIS)).findFirst();
        return optional.map(p_192975_ -> {
            BlockPos blockpos = p_192975_.getPos();
            this.level.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.getBlockState(blockpos);
            return BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_192978_ -> this.level.getBlockState(p_192978_) == blockstate);
        });
    }

    public void teleportToPortal(BlockPos pos, boolean isInAtlantis, WorldBorder worldBorder, ServerPlayer player) {
        Optional<BlockUtil.FoundRectangle> optional;
        if (!this.findPortalAround(pos, isInAtlantis, worldBorder).equals(Optional.empty()) && (optional = this.findPortalAround(pos, isInAtlantis, worldBorder)).isPresent()) {
            BlockUtil.FoundRectangle blockutil$foundrectangle = optional.get();
            this.teleportPlayer(player, blockutil$foundrectangle);
        }
    }

    public void teleportToPortal(BlockPos pos, boolean isInAtlantis, WorldBorder worldBorder, Entity entity) {
        Optional<BlockUtil.FoundRectangle> optional;
        if (!this.findPortalAround(pos, isInAtlantis, worldBorder).equals(Optional.empty()) && (optional = this.findPortalAround(pos, isInAtlantis, worldBorder)).isPresent()) {
            BlockUtil.FoundRectangle blockutil$foundrectangle = optional.get();
            this.teleportEntity(entity, blockutil$foundrectangle);
        }
    }

    private void teleportEntity(Entity entity, BlockUtil.FoundRectangle blockutil$foundrectangle) {
        if (this.level == entity.level()) {
            entity.teleportTo((double)blockutil$foundrectangle.minCorner.getX() + 0.5, (double)blockutil$foundrectangle.minCorner.getY() + 1.5, (double)blockutil$foundrectangle.minCorner.getZ() + 0.5);
        } else {
            ServerLevel serverlevel = entity.getServer().getLevel(this.level.dimension());
            if (serverlevel == null) {
                return;
            }
            entity.teleportTo(serverlevel, (double)blockutil$foundrectangle.minCorner.getX() + 0.5, (double)blockutil$foundrectangle.minCorner.getY() + 1.5, (double)blockutil$foundrectangle.minCorner.getZ() + 0.5, RelativeMovement.ALL, entity.getYRot(), entity.getXRot());
        }
    }

    private void teleportPlayer(ServerPlayer player, BlockUtil.FoundRectangle blockutil$foundrectangle) {
        if (player.isSleeping()) {
            return;
        }
        if (this.level == player.level()) {
            player.connection.teleport((double)blockutil$foundrectangle.minCorner.getX() + 0.5, (double)blockutil$foundrectangle.minCorner.getY() + 1.5, (double)blockutil$foundrectangle.minCorner.getZ() + 0.5, player.getYRot(), player.getXRot());
        } else {
            ServerLevel serverlevel = player.getServer().getLevel(this.level.dimension());
            if (serverlevel == null) {
                return;
            }
            player.teleportTo(serverlevel, (double)blockutil$foundrectangle.minCorner.getX() + 0.5, (double)blockutil$foundrectangle.minCorner.getY() + 1.5, (double)blockutil$foundrectangle.minCorner.getZ() + 0.5, player.getYRot(), player.getXRot());
        }
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pPos, Direction.Axis pAxis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pAxis);
        double d0 = -1.0;
        BlockPos blockpos = pPos;
        double d1 = -1.0;
        BlockPos blockpos1 = pPos;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.spiralAround((BlockPos)pPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos1.getX(), blockpos$mutableblockpos1.getZ()));
            if (!worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1) || !worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1.move(direction, 1))) continue;
            blockpos$mutableblockpos1.move(direction.getOpposite(), 1);
            for (int l = j; l >= this.level.getMinBuildHeight(); --l) {
                blockpos$mutableblockpos1.setY(l);
                if (!this.canPortalReplaceBlock(blockpos$mutableblockpos1)) continue;
                int i1 = l;
                while (l > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockpos$mutableblockpos1.move(Direction.DOWN))) {
                    int j1;
                    if (l + 4 <= i && ((j1 = i1 - l) <= 0 || j1 >= 3)) {
                        blockpos$mutableblockpos1.setY(l);
                        if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 0)) {
                            double d2 = pPos.distSqr((Vec3i)blockpos$mutableblockpos1);
                            if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                                d0 = d2;
                                blockpos = blockpos$mutableblockpos1.immutable();
                            }
                            if (d0 == -1.0 && (d1 == -1.0 || d1 > d2)) {
                                d1 = d2;
                                blockpos1 = blockpos$mutableblockpos1.immutable();
                            }
                        }
                    }
                    --l;
                }
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
        }
        if (AtlantisDimensions.isAtlantisDimension((Level)this.level)) {
            this.makePortalOverworld(this.level, blockpos);
        } else {
            this.makePortalAtlantis(this.level, blockpos);
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pPos) {
        BlockState blockstate = this.level.getBlockState((BlockPos)pPos);
        return blockstate.canBeReplaced() && blockstate.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos pOriginalPos, BlockPos.MutableBlockPos pOffsetPos, Direction pDirection, int pOffsetScale) {
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 3; ++j) {
                pOffsetPos.setWithOffset((Vec3i)pOriginalPos, pDirection.getStepX() * i + pDirection.getStepX() * pOffsetScale, j, pDirection.getStepZ() * i + pDirection.getStepZ() * pOffsetScale);
                if (j < 0 && this.level.getBlockState((BlockPos)pOffsetPos).isSolid() && !this.level.getBlockState((BlockPos)pOffsetPos).is(Blocks.WATER)) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(pOffsetPos) || this.level.getBlockState((BlockPos)pOffsetPos).is(Blocks.WATER)) continue;
                return false;
            }
        }
        return true;
    }

    private void makePortalAtlantis(ServerLevel pServerLevel, BlockPos blockpos) {
        int i = blockpos.getX();
        int j = blockpos.getY() - 2;
        int k = blockpos.getZ();
        BlockPos.betweenClosed((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 5), (int)(k + 2)).forEach(p_207578_ -> pServerLevel.setBlockAndUpdate(p_207578_, Blocks.AIR.defaultBlockState()));
        AtlanteanPortalForcer.makePortalFrameAtlantis(pServerLevel, blockpos);
        BlockPos.betweenClosed((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(p_184101_ -> pServerLevel.setBlockAndUpdate(p_184101_, ((HardenedCalciteBlock)((Object)((Object)BlockInit.HARDENED_CALCITE_BLOCK.get()))).defaultBlockState()));
        BlockPos.betweenClosed((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 1), (int)(k + 1)).forEach(p_184101_ -> pServerLevel.setBlockAndUpdate(p_184101_, ((AtlanteanPortalBlock)((Object)((Object)BlockInit.ATLANTEAN_PORTAL.get()))).defaultBlockState()));
    }

    private void makePortalOverworld(ServerLevel pServerLevel, BlockPos blockpos) {
        int i = blockpos.getX();
        int j = blockpos.getY() - 2;
        int k = blockpos.getZ();
        BlockPos.betweenClosed((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 5), (int)(k + 2)).forEach(p_207578_ -> pServerLevel.setBlockAndUpdate(p_207578_, Blocks.WATER.defaultBlockState()));
        AtlanteanPortalForcer.makePortalFrameOverworld(pServerLevel, blockpos);
        BlockPos.betweenClosed((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(p_184101_ -> pServerLevel.setBlockAndUpdate(p_184101_, ((HardenedCalciteBlock)((Object)((Object)BlockInit.HARDENED_CALCITE_BLOCK.get()))).defaultBlockState()));
        BlockPos.betweenClosed((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 1), (int)(k + 1)).forEach(p_184101_ -> pServerLevel.setBlockAndUpdate(p_184101_, ((AtlanteanPortalBlock)((Object)((Object)BlockInit.ATLANTEAN_PORTAL.get()))).defaultBlockState()));
    }

    public static void makePortalFrameAtlantis(ServerLevel pServerLevel, BlockPos blockpos) {
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(0, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(0, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static void makePortalFrameOverworld(ServerLevel pServerLevel, BlockPos blockpos) {
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(0, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(0, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.setBlockAndUpdate(blockpos.offset(-1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }
}

