/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.dimension;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.datagen.BiomeInit;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class AtlantisDimensions {
    public static final DeferredRegister<MapCodec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((Registry)BuiltInRegistries.BIOME_SOURCE, (String)"atlantis");
    public static ResourceKey<Level> ATLANTIS_WORLD = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Atlantis.id("atlantis"));
    public static final ResourceKey<DimensionType> ATLANTIS_DIMENSION_TYPE_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)Atlantis.id("atlantis"));
    public static ResourceKey<LevelStem> ATLANTIS_DIMENSION_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)Atlantis.id("atlantis"));
    public static final ResourceLocation ATLANTIS_DIMENSION_EFFECT = Atlantis.id("atlantis");
    public static DimensionType ATLANTIS_TYPE;
    public static ResourceKey<NoiseGeneratorSettings> ATLANTIS_DIMENSION_NOISE_SETTING;
    public static ServerLevel ATLANTIS_DIMENSION;

    public static boolean isAtlantisDimension(Level world) {
        return world != null && world.dimension().equals(ATLANTIS_WORLD);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ATLANTIS_TYPE = (DimensionType)event.getServer().registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).get(ATLANTIS_DIMENSION_TYPE_KEY);
        ATLANTIS_DIMENSION = event.getServer().getLevel(ATLANTIS_WORLD);
    }

    public static void init(IEventBus bus) {
        BIOME_SOURCE.register(bus);
    }

    public AtlantisDimensions(BootstrapContext<LevelStem> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        HolderGetter holderGetter1 = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter holderGetter2 = context.lookup(Registries.NOISE_SETTINGS);
        context.register(ATLANTIS_DIMENSION_STEM, (Object)new LevelStem((Holder)holderGetter1.getOrThrow(ATLANTIS_DIMENSION_TYPE_KEY), (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.parameters((float)0.1f, (float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.GOO_LAGOONS_KEY)), Pair.of((Object)Climate.parameters((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.COCONUT_ISLES_KEY)), Pair.of((Object)Climate.parameters((float)0.3f, (float)0.2f, (float)0.1f, (float)0.2f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.ATLANTEAN_GARDEN_KEY)), Pair.of((Object)Climate.parameters((float)0.1f, (float)0.1f, (float)0.2f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.ATLANTIS_BIOME_KEY)), Pair.of((Object)Climate.parameters((float)0.1f, (float)0.1f, (float)0.1f, (float)0.2f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.AQUAIEL_JELLYFISH_FIELDS_KEY)), Pair.of((Object)Climate.parameters((float)0.2f, (float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.ATLANTEAN_ISLANDS_BIOME_KEY)), Pair.of((Object)Climate.parameters((float)0.1f, (float)0.2f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.getOrThrow(BiomeInit.VOLCANIC_DARKSEA_KEY))))), (Holder)holderGetter2.getOrThrow(ATLANTIS_DIMENSION_NOISE_SETTING))));
    }

    static {
        ATLANTIS_DIMENSION_NOISE_SETTING = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)Atlantis.id("atlantis"));
    }
}

