/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AquaielJellyfishEntity
extends WaterAnimal
implements GeoEntity,
Bucketable {
    protected static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AquaielJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(AquaielJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(AquaielJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation HOVER_ANIMATION = RawAnimation.begin().thenLoop("animation.jellyfish.hover");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.jellyfish.idle");
    private int randomTimer;
    private float tx;
    private float ty;
    private float tz;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AquaielJellyfishEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.randomTimer = this.getRandom().nextInt(61);
        this.setNoGravity(true);
    }

    public static AttributeSupplier.Builder createJellyfishAttributes() {
        return AquaielJellyfishEntity.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    public static boolean canSpawn(EntityType<AquaielJellyfishEntity> AquaielJellyfishEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 75 && 105 >= pos.getY() && serverWorldAccess.getBlockState(pos).is(Blocks.WATER);
    }

    public boolean isVisuallySwimming() {
        return true;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() == ItemInit.CRAB_LEGS.get()) {
            if (player instanceof ServerPlayer) {
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                this.createChild((ServerLevel)player.getCommandSenderWorld(), this);
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.getItemInHand(hand).getItem() == Items.WATER_BUCKET) {
            return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
        }
        if (player.getItemInHand(hand).getItem() == Items.HONEY_BOTTLE) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (!player.getAbilities().instabuild) {
                player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
                ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)((Item)ItemInit.JELLY_BOTTLE.get()).getDefaultInstance());
                player.setItemInHand(hand, itemStack2);
            } else {
                player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
                ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)((Item)ItemInit.JELLY_BOTTLE.get()).getDefaultInstance());
                player.setItemInHand(hand, itemStack2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new JellyFishRandomMovementGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.CRAB_LEGS.get()}), false));
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.entityData.set(VARIANT, (Object)(this.random.nextInt(100) > 50 ? 1 : 2));
        this.entityData.set(COLOR, (Object)this.random.nextInt(15));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void load(CompoundTag nbt) {
        this.setFromBucket(nbt.getBoolean("FromBucket"));
        this.entityData.set(VARIANT, (Object)nbt.getInt("Variant"));
        this.setColor(nbt.getInt("Color"));
        super.load(nbt);
    }

    public CompoundTag saveWithoutId(CompoundTag nbt) {
        nbt.putBoolean("FromBucket", this.fromBucket());
        nbt.putInt("Variant", ((Integer)this.entityData.get(VARIANT)).intValue());
        nbt.putInt("Color", this.getColor());
        return super.saveWithoutId(nbt);
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public ItemStack getBucketItemStack() {
        return ((Item)ItemInit.AQUAIEL_JELLYFISH_BUCKET.get()).getDefaultInstance();
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)nbt);
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(VARIANT, (Object)0);
        p_326499_.define(FROM_BUCKET, (Object)false);
        p_326499_.define(COLOR, (Object)this.random.nextInt(15));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && --this.randomTimer <= 0) {
            this.randomTimer = this.getRandom().nextInt(21);
            this.setDeltaMovement((double)this.tx * 1.2, (double)this.ty * 1.6, (double)this.tz * 1.2);
        }
        this.setTarget((LivingEntity)this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 10.0, true));
    }

    public void createChild(ServerLevel world, AquaielJellyfishEntity entity) {
        AquaielJellyfishEntity child = (AquaielJellyfishEntity)this.getType().create((Level)world);
        if (child != null) {
            child.setPosRaw(this.getX(), this.getY(), this.getZ());
            world.addFreshEntity((Entity)child);
        }
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public boolean canBeLeashed() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean isMovingSlowly() {
        return this.getDeltaMovement().x() != 0.0 && this.getDeltaMovement().y() != 0.0 && this.getDeltaMovement().z() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(HOVER_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void setMovementVector(float randomMotionVecX, float randomMotionVecY, float randomMotionVecZ) {
        this.tx = randomMotionVecX;
        this.ty = randomMotionVecY;
        this.tz = randomMotionVecZ;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    static class JellyFishRandomMovementGoal
    extends Goal {
        private final AquaielJellyfishEntity AquaielJellyfishEntity;

        public JellyFishRandomMovementGoal(AquaielJellyfishEntity arg2) {
            this.AquaielJellyfishEntity = arg2;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.AquaielJellyfishEntity.getNoActionTime();
            if (i > 100) {
                this.AquaielJellyfishEntity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.AquaielJellyfishEntity.getRandom().nextInt(JellyFishRandomMovementGoal.reducedTickDelay((int)50)) == 0 || !this.AquaielJellyfishEntity.wasTouchingWater || !this.AquaielJellyfishEntity.hasMovementVector()) {
                float f = this.AquaielJellyfishEntity.getRandom().nextFloat() * ((float)Math.PI * 2);
                float g = Mth.cos((float)f) * 0.2f;
                float h = -0.1f + this.AquaielJellyfishEntity.getRandom().nextFloat() * 0.2f;
                float j = Mth.sin((float)f) * 0.2f;
                this.AquaielJellyfishEntity.setMovementVector(g, h, j);
            }
        }
    }
}

