/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CoconutCrabEntity
extends Animal
implements NeutralMob,
GeoAnimatable {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<CoconutCrabEntity> mainController = new AnimationController((GeoAnimatable)this, "coconutCrabController", 2, this::mainPredicate);
    static final RawAnimation NUTON_ANIMATION = RawAnimation.begin().thenLoop("animation.coconut_crab.nuton");
    static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.walk");
    static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.idle");
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public CoconutCrabEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public static boolean canSpawn(EntityType<CoconutCrabEntity> crabEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 350 && 512 >= pos.getY();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public static AttributeSupplier.Builder createCoconutCrabAttributes() {
        return CoconutCrabEntity.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.6);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence();
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.hasCustomName();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326308_) {
        super.defineSynchedData(p_326308_);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
    }

    public CompoundTag saveWithoutId(CompoundTag nbt) {
        return super.saveWithoutId(nbt);
    }

    public boolean canBeLeashed() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{CoconutCrabEntity.class}));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), false));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CoconutCrabEntity)this).isAngryAt(arg_0)));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() == Blocks.SEAGRASS.asItem() && player instanceof ServerPlayer && this.isFood(Blocks.SEAGRASS.asItem().getDefaultInstance()) && !this.level().isClientSide && this.canFallInLove()) {
            this.usePlayerItem(player, hand, Blocks.SEAGRASS.asItem().getDefaultInstance());
            this.setInLove(player);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
            this.getBreedOffspring((ServerLevel)player.getCommandSenderWorld(), (AgeableMob)this);
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(hand).shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean isFood(ItemStack stack) {
        return CoconutCrabEntity.isTempting(stack);
    }

    private static boolean isTempting(ItemStack stack) {
        return stack.is(Blocks.SEAGRASS.asItem());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        CoconutCrabEntity crabEntity = (CoconutCrabEntity)entity;
        if (crabEntity.isInLove() && this.canMate(crabEntity)) {
            return (CoconutCrabEntity)crabEntity.getType().create((Level)world);
        }
        return entity;
    }

    public void aiStep() {
        super.aiStep();
        this.setTarget((LivingEntity)this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.getDeltaMovement().x() != 0.0 && this.getDeltaMovement().y() != 0.0 && this.getDeltaMovement().z() != 0.0;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    private <P extends GeoAnimatable> PlayState mainPredicate(AnimationState<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (!this.isMovingSlowly()) {
            if (this.hurtMarked) {
                event.getController().setAnimation(NUTON_ANIMATION);
            } else {
                event.getController().setAnimation(IDLE_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    public void setRemainingPersistentAngerTime(int i) {
        this.remainingPersistentAngerTime = i;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.mainController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public double getTick(Object o) {
        return 0.0;
    }
}

