/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.entities.AquaielJellyfishEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeviathanEntity
extends WaterAnimal
implements GeoEntity {
    public static final int TICKS_PER_FLAP = Mth.ceil((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.defineId(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Vec3 moveTargetPoint;
    private BlockPos anchorPoint;
    private AttackPhase attackPhase;
    private static final RawAnimation SWIM_IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.leviathan.swim");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static AttributeSupplier.Builder createLeviathanAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public LeviathanEntity(EntityType<? extends WaterAnimal> arg, Level arg2) {
        super(arg, arg2);
        this.moveTargetPoint = Vec3.ZERO;
        this.anchorPoint = BlockPos.ZERO;
        this.attackPhase = AttackPhase.CIRCLE;
        this.xpReward = 5;
        this.moveControl = new LeviathanEntityMoveControl((Mob)this);
        this.lookControl = new LeviathanEntityLookControl((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LeviathanEntityAttackStrategyGoal());
        this.goalSelector.addGoal(2, (Goal)new LeviathanEntitySweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new LeviathanEntityCircleAroundAnchorGoal());
        this.targetSelector.addGoal(0, (Goal)new LeviathanEntityAttackJellyfishGoal());
        this.targetSelector.addGoal(1, (Goal)new LeviathanEntityAttackPlayerTargetGoal());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float f = Mth.cos((float)((float)(this.getUniqueFlapTickOffset() + this.tickCount) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.cos((float)((float)(this.getUniqueFlapTickOffset() + this.tickCount + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PHANTOM_FLAP, this.getSoundSource(), 0.95f + this.random.nextFloat() * 0.05f, 0.95f + this.random.nextFloat() * 0.05f, false);
            }
            int i = this.getLeviathanEntitySize();
            float f2 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.level().addParticle((ParticleOptions)ParticleTypes.MYCELIUM, this.getX() + (double)f2, this.getY() + (double)f4, this.getZ() + (double)f3, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.MYCELIUM, this.getX() - (double)f2, this.getY() + (double)f4, this.getZ() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    public void setLeviathanEntitySize(int pSize) {
        this.entityData.set(ID_SIZE, (Object)Mth.clamp((int)pSize, (int)0, (int)64));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(ID_SIZE, (Object)0);
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.anchorPoint = this.blockPosition().above(5);
        this.setLeviathanEntitySize(0);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("AX")) {
            this.anchorPoint = new BlockPos(pCompound.getInt("AX"), pCompound.getInt("AY"), pCompound.getInt("AZ"));
        }
        this.setLeviathanEntitySize(pCompound.getInt("Size"));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("AX", this.anchorPoint.getX());
        pCompound.putInt("AY", this.anchorPoint.getY());
        pCompound.putInt("AZ", this.anchorPoint.getZ());
        pCompound.putInt("Size", this.getLeviathanEntitySize());
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PHANTOM_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.PHANTOM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PHANTOM_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public boolean canAttackType(@NotNull EntityType<?> pType) {
        return true;
    }

    public int getLeviathanEntitySize() {
        return (Integer)this.entityData.get(ID_SIZE);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> pKey) {
        if (ID_SIZE.equals(pKey)) {
            this.updateLeviathanEntitySizeInfo();
        }
        super.onSyncedDataUpdated(pKey);
    }

    private void updateLeviathanEntitySizeInfo() {
        this.refreshDimensions();
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue((double)(6 + this.getLeviathanEntitySize()));
    }

    public int getUniqueFlapTickOffset() {
        return this.getId() * 3;
    }

    public boolean isFlapping() {
        return (this.getUniqueFlapTickOffset() + this.tickCount) % TICKS_PER_FLAP == 0;
    }

    @NotNull
    protected BodyRotationControl createBodyControl() {
        return new LeviathanEntityBodyRotationControl((Mob)this);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        event.getController().setAnimation(SWIM_IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public static boolean canSpawn(EntityType<LeviathanEntity> leviathanEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 75 && 105 >= pos.getY() && serverWorldAccess.getBlockState(pos).is(Blocks.WATER);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class LeviathanEntityMoveControl
    extends MoveControl {
        private float speed;

        public LeviathanEntityMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void tick() {
            if (LeviathanEntity.this.horizontalCollision) {
                LeviathanEntity.this.setYRot(LeviathanEntity.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            float f = (float)(LeviathanEntity.this.moveTargetPoint.x - LeviathanEntity.this.getX());
            float g = (float)(LeviathanEntity.this.moveTargetPoint.y - LeviathanEntity.this.getY());
            float h = (float)(LeviathanEntity.this.moveTargetPoint.z - LeviathanEntity.this.getZ());
            double d = Mth.sqrt((float)(f * f + h * h));
            if (Math.abs(d) > (double)1.0E-5f) {
                double e = 1.0 - (double)Mth.abs((float)(g * 0.7f)) / d;
                f = (float)((double)f * e);
                h = (float)((double)h * e);
                d = Mth.sqrt((float)(f * f + h * h));
                double i = Mth.sqrt((float)(f * f + h * h + g * g));
                float j = LeviathanEntity.this.getYRot();
                float k = (float)Mth.atan2((double)h, (double)f);
                float l = Mth.wrapDegrees((float)(LeviathanEntity.this.getYRot() + 90.0f));
                float m = Mth.wrapDegrees((float)(k * 57.295776f));
                LeviathanEntity.this.setYRot(Mth.approachDegrees((float)l, (float)m, (float)4.0f) - 90.0f);
                LeviathanEntity.this.yBodyRot = LeviathanEntity.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs((float)j, (float)LeviathanEntity.this.getYRot()) < 3.0f ? Mth.approach((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.approach((float)this.speed, (float)0.2f, (float)0.025f);
                float n = (float)(-(Mth.atan2((double)(-g), (double)d) * 57.2957763671875));
                LeviathanEntity.this.setXRot(n);
                float o = LeviathanEntity.this.getYRot() + 90.0f;
                double p = (double)(this.speed * Mth.cos((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)f / i);
                double q = (double)(this.speed * Mth.sin((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)h / i);
                double r = (double)(this.speed * Mth.sin((float)(n * ((float)Math.PI / 180)))) * Math.abs((double)g / i);
                Vec3 vec3 = LeviathanEntity.this.getDeltaMovement();
                LeviathanEntity.this.setDeltaMovement(vec3.add(new Vec3(p, r, q).subtract(vec3).scale(0.2)));
            }
        }
    }

    static class LeviathanEntityLookControl
    extends LookControl {
        public LeviathanEntityLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void tick() {
        }
    }

    class LeviathanEntityAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        LeviathanEntityAttackStrategyGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = LeviathanEntity.this.getTarget();
            return livingentity != null && LeviathanEntity.this.canAttack(livingentity, TargetingConditions.DEFAULT);
        }

        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            LeviathanEntity.this.anchorPoint = LeviathanEntity.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, LeviathanEntity.this.anchorPoint).above(10 + LeviathanEntity.this.random.nextInt(20));
        }

        public void tick() {
            if (LeviathanEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    LeviathanEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + LeviathanEntity.this.random.nextInt(4)) * 20);
                    LeviathanEntity.this.playSound(SoundEvents.PHANTOM_SWOOP, 10.0f, 0.95f + LeviathanEntity.this.random.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            if (LeviathanEntity.this.getTarget() != null) {
                LeviathanEntity.this.anchorPoint = LeviathanEntity.this.getTarget().blockPosition().above(20 + LeviathanEntity.this.random.nextInt(20));
                if (LeviathanEntity.this.anchorPoint.getY() < LeviathanEntity.this.level().getSeaLevel()) {
                    LeviathanEntity.this.anchorPoint = new BlockPos(LeviathanEntity.this.anchorPoint.getX(), LeviathanEntity.this.level().getSeaLevel() + 1, LeviathanEntity.this.anchorPoint.getZ());
                }
            }
        }
    }

    class LeviathanEntitySweepAttackGoal
    extends LeviathanEntityMoveTargetGoal {
        LeviathanEntitySweepAttackGoal() {
        }

        public boolean canUse() {
            return LeviathanEntity.this.getTarget() != null && LeviathanEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = LeviathanEntity.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.isSpectator() || player.isCreative()) {
                    return false;
                }
            }
            return this.canUse();
        }

        public void start() {
        }

        public void stop() {
            LeviathanEntity.this.setTarget(null);
            LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void tick() {
            LivingEntity livingentity = LeviathanEntity.this.getTarget();
            if (livingentity != null) {
                LeviathanEntity.this.moveTargetPoint = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
                if (LeviathanEntity.this.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
                    LeviathanEntity.this.doHurtTarget((Entity)livingentity);
                    LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!LeviathanEntity.this.isSilent()) {
                        LeviathanEntity.this.level().levelEvent(1039, LeviathanEntity.this.blockPosition(), 0);
                    }
                } else if (LeviathanEntity.this.horizontalCollision || LeviathanEntity.this.hurtTime > 0) {
                    LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class LeviathanEntityCircleAroundAnchorGoal
    extends LeviathanEntityMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        LeviathanEntityCircleAroundAnchorGoal() {
        }

        public boolean canUse() {
            return LeviathanEntity.this.getTarget() == null || LeviathanEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void start() {
            this.distance = 5.0f + LeviathanEntity.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + LeviathanEntity.this.random.nextFloat() * 9.0f;
            this.clockwise = LeviathanEntity.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (LeviathanEntity.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + LeviathanEntity.this.random.nextFloat() * 9.0f;
            }
            if (LeviathanEntity.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (LeviathanEntity.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = LeviathanEntity.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (LeviathanEntity.this.moveTargetPoint.y < LeviathanEntity.this.getY() && !LeviathanEntity.this.level().isEmptyBlock(LeviathanEntity.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (LeviathanEntity.this.moveTargetPoint.y > LeviathanEntity.this.getY() && !LeviathanEntity.this.level().isEmptyBlock(LeviathanEntity.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)LeviathanEntity.this.anchorPoint)) {
                LeviathanEntity.this.anchorPoint = LeviathanEntity.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            LeviathanEntity.this.moveTargetPoint = Vec3.atLowerCornerOf((Vec3i)LeviathanEntity.this.anchorPoint).add((double)(this.distance * Mth.cos((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    class LeviathanEntityAttackJellyfishGoal
    extends Goal {
        private int nextScanTick = LeviathanEntityAttackJellyfishGoal.reducedTickDelay((int)20);

        LeviathanEntityAttackJellyfishGoal() {
        }

        public boolean canUse() {
            if (LeviathanEntity.this.getTarget() != null) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = LeviathanEntityAttackJellyfishGoal.reducedTickDelay((int)60);
                List list = LeviathanEntity.this.level().getEntitiesOfClass(AquaielJellyfishEntity.class, LeviathanEntity.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::getY).reversed());
                    for (AquaielJellyfishEntity jellyFish : list) {
                        if (!LeviathanEntity.this.canAttack((LivingEntity)jellyFish, TargetingConditions.DEFAULT)) continue;
                        LeviathanEntity.this.setTarget((LivingEntity)jellyFish);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = LeviathanEntity.this.getTarget();
            return livingentity != null && LeviathanEntity.this.canAttack(livingentity, TargetingConditions.DEFAULT);
        }

        public void start() {
            super.start();
            LeviathanEntity.this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 0x7FFFFFFE));
        }

        public void stop() {
            super.stop();
            LeviathanEntity.this.removeEffect(MobEffects.INVISIBILITY);
        }
    }

    class LeviathanEntityAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = LeviathanEntityAttackPlayerTargetGoal.reducedTickDelay((int)20);

        LeviathanEntityAttackPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (LeviathanEntity.this.getTarget() != null) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = LeviathanEntityAttackPlayerTargetGoal.reducedTickDelay((int)60);
                List list = LeviathanEntity.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)LeviathanEntity.this, LeviathanEntity.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::getY).reversed());
                    for (Player player : list) {
                        if (!LeviathanEntity.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT) || !(LeviathanEntity.this.getLastHurtByMob() instanceof Player)) continue;
                        LeviathanEntity.this.setTarget((LivingEntity)player);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = LeviathanEntity.this.getTarget();
            return livingentity != null && LeviathanEntity.this.canAttack(livingentity, TargetingConditions.DEFAULT);
        }

        public void start() {
            super.start();
            LeviathanEntity.this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 0x7FFFFFFE));
        }

        public void stop() {
            super.stop();
            LeviathanEntity.this.removeEffect(MobEffects.INVISIBILITY);
        }
    }

    class LeviathanEntityBodyRotationControl
    extends BodyRotationControl {
        public LeviathanEntityBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void clientTick() {
            LeviathanEntity.this.yHeadRot = LeviathanEntity.this.yBodyRot;
            LeviathanEntity.this.yBodyRot = LeviathanEntity.this.getYRot();
        }
    }

    abstract class LeviathanEntityMoveTargetGoal
    extends Goal {
        public LeviathanEntityMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return LeviathanEntity.this.moveTargetPoint.distanceToSqr(LeviathanEntity.this.getX(), LeviathanEntity.this.getY(), LeviathanEntity.this.getZ()) < 4.0;
        }
    }
}

