/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.entities.GlittertailShrimpEntity;
import com.mystic.atlantis.init.ItemInit;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarfishEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.walk");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.idle");
    private static final RawAnimation EAT_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.eat");
    private static final RawAnimation JUMP_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.jump");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarfishEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public static AttributeSupplier.Builder createStarfishAttributes() {
        return StarfishEntity.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.6);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected boolean canRide(Entity entity) {
        return !entity.isVehicle() && !entity.hasPassenger((Entity)this);
    }

    public void rideTick() {
        Player player;
        Entity entity = this.getVehicle();
        if (entity instanceof Player && (player = (Player)entity).isShiftKeyDown()) {
            this.stopRiding();
        }
        if (!(entity.isAlive() || entity instanceof GlittertailShrimpEntity || entity instanceof Player || this.canRide(entity))) {
            this.stopRiding();
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (entity instanceof Player) {
                player = (Player)entity;
                this.setPos(player.getX(), Math.max(player.getY() + (double)player.getEyeHeight(), player.getY()), player.getZ());
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 5));
                if (player.getHealth() > 1.0f) {
                    player.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
                }
                if (!player.isAlive()) {
                    this.removeVehicle();
                }
            } else if (entity instanceof GlittertailShrimpEntity) {
                GlittertailShrimpEntity shrimp = (GlittertailShrimpEntity)entity;
                this.setPos(shrimp.getX(), Math.max(shrimp.getY() + (double)shrimp.getEyeHeight(), shrimp.getY()), shrimp.getZ());
                shrimp.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 5));
                shrimp.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
                if (!shrimp.isAlive()) {
                    this.removeVehicle();
                }
            }
        }
    }

    public boolean canBeLeashed() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{StarfishEntity.class}));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.SHRIMP.get()}), false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, GlittertailShrimpEntity.class, true));
    }

    public static boolean canSpawn(EntityType<StarfishEntity> starfishEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 75 && 95 >= pos.getY() && serverWorldAccess.getBlockState(pos).is(Blocks.WATER);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() == ItemInit.SHRIMP.get()) {
            if (player instanceof ServerPlayer) {
                if (this.isFood(((Item)ItemInit.SHRIMP.get()).getDefaultInstance())) {
                    if (!this.level().isClientSide && this.canFallInLove()) {
                        this.usePlayerItem(player, hand, ((Item)ItemInit.SHRIMP.get()).getDefaultInstance());
                        this.setInLove(player);
                        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                        this.getBreedOffspring((ServerLevel)player.getCommandSenderWorld(), (AgeableMob)this);
                        if (!player.getAbilities().instabuild) {
                            player.getItemInHand(hand).shrink(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean isFood(ItemStack stack) {
        return StarfishEntity.isTempting(stack);
    }

    private static boolean isTempting(ItemStack stack) {
        return stack.is((Item)ItemInit.SHRIMP.get());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        StarfishEntity starfishEntity = (StarfishEntity)entity;
        if (starfishEntity.isInLove() && this.canMate(starfishEntity)) {
            return (StarfishEntity)starfishEntity.getType().create((Level)world);
        }
        return entity;
    }

    public void aiStep() {
        super.aiStep();
        this.setTarget((LivingEntity)this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.getDeltaMovement().x() != 0.0 && this.getDeltaMovement().y() != 0.0 && this.getDeltaMovement().z() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (this.isPassenger()) {
            event.getController().setAnimation(EAT_ANIMATION);
        } else if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (this.isSwimming()) {
            event.getController().setAnimation(JUMP_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

