/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.mixin.BoatEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SubmarineEntity
extends Boat
implements GeoEntity {
    public boolean pressingForward;
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SubmarineEntity(EntityType<? extends Boat> entityType, Level world) {
        super(entityType, world);
    }

    public Item getDropItem() {
        return (Item)ItemInit.SUBMARINE.get();
    }

    public float maxUpStep() {
        return 1.0f;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.PIG_STEP, 0.15f, 1.0f);
    }

    public void tick() {
        super.tick();
        ((BoatEntityAccessor)((Object)this)).atlantis$setStatusField(Boat.Status.UNDER_WATER);
        ((BoatEntityAccessor)((Object)this)).atlantis$setOutOfControlTicks(0.0f);
        this.floatBoat();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.getFirstPassenger() != null && this.pressingForward) {
            Entity passenger = this.getFirstPassenger();
            this.setXRot(passenger.getXRot() * 0.5f);
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 2;
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.positionRider(pPassenger, pCallback);
        pCallback.accept(pPassenger, this.getX(), this.getY() - 0.5, this.getZ());
        if (this.hasPassenger(pPassenger) && pPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pPassenger;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 2, 1, true, false, false));
        }
    }

    public void setInput(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        super.setInput(pressingLeft, pressingRight, pressingForward, pressingBack);
        this.pressingForward = pressingForward;
    }

    private void floatBoat() {
        Vec3 vec3d = this.getDeltaMovement();
        if (((BoatEntityAccessor)((Object)this)).atlantis$getStatus() == Boat.Status.UNDER_WATER && this.getFirstPassenger() != null && this.pressingForward) {
            this.setDeltaMovement(vec3d.x * 1.5, vec3d.y - (double)this.getXRot() * 0.001, vec3d.z * 1.5);
        }
        Vec3 velocity = this.getDeltaMovement();
        if (this.wasTouchingWater) {
            this.setDeltaMovement(velocity.x, velocity.y, velocity.z);
        } else {
            this.setDeltaMovement(velocity.x * 0.4, -0.75, velocity.z * 0.4);
        }
    }

    public boolean isUnderWater() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "main", 0, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

