/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ThalassianSeahorseEntity
extends WaterAnimal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(ThalassianSeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ThalassianSeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation CORAL_IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.seahorse.coral-idle");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.seahorse.idle");
    private static final RawAnimation SWIM_ANIMATION = RawAnimation.begin().thenLoop("animation.seahorse.swim");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<Block> CORALS = List.of(Blocks.BUBBLE_CORAL, Blocks.BUBBLE_CORAL_BLOCK, Blocks.BUBBLE_CORAL_FAN, Blocks.BUBBLE_CORAL_WALL_FAN, Blocks.BRAIN_CORAL, Blocks.BRAIN_CORAL_BLOCK, Blocks.BRAIN_CORAL_FAN, Blocks.BRAIN_CORAL_WALL_FAN, Blocks.FIRE_CORAL, Blocks.FIRE_CORAL_BLOCK, Blocks.FIRE_CORAL_FAN, Blocks.FIRE_CORAL_WALL_FAN, Blocks.HORN_CORAL, Blocks.HORN_CORAL_BLOCK, Blocks.HORN_CORAL_FAN, Blocks.HORN_CORAL_WALL_FAN, Blocks.TUBE_CORAL, Blocks.TUBE_CORAL_BLOCK, Blocks.TUBE_CORAL_FAN, Blocks.TUBE_CORAL_WALL_FAN);
    private final List<BlockPos> HORIZONAL_DIRECTIONS = List.of(this.blockPosition().north(), this.blockPosition().south(), this.blockPosition().west(), this.blockPosition().east());

    public ThalassianSeahorseEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSeahorseAttributes() {
        return ThalassianSeahorseEntity.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 2.5);
    }

    public static boolean canSpawn(EntityType<ThalassianSeahorseEntity> ThalassianSeahorseEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 75 && 95 >= pos.getY() && serverWorldAccess.getBlockState(pos).is(Blocks.WATER);
    }

    public float getScale() {
        return 0.7f;
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.entityData.set(COLOR, (Object)ThalassianSeahorseEntity.betterNiceColor());
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void load(CompoundTag nbt) {
        this.setColor(nbt.getInt("Color"));
        this.setFromBucket(nbt.getBoolean("FromBucket"));
        super.load(nbt);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)nbt);
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    public CompoundTag saveWithoutId(CompoundTag nbt) {
        nbt.putInt("Color", this.getColor());
        nbt.putBoolean("FromBucket", this.fromBucket());
        return super.saveWithoutId(nbt);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(FROM_BUCKET, (Object)false);
        p_326499_.define(COLOR, (Object)ThalassianSeahorseEntity.betterNiceColor());
    }

    public void createChild(ServerLevel world, ThalassianSeahorseEntity entity) {
        ThalassianSeahorseEntity child = (ThalassianSeahorseEntity)this.getType().create((Level)world);
        if (child != null) {
            child.setPosRaw(this.getX(), this.getY(), this.getZ());
            world.addFreshEntity((Entity)child);
        }
    }

    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming();
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() == Items.SEAGRASS) {
            if (player instanceof ServerPlayer) {
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                this.createChild((ServerLevel)player.getCommandSenderWorld(), this);
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.getItemInHand(hand).getItem() == Items.WATER_BUCKET) {
            return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
        }
        return InteractionResult.FAIL;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 1));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), false));
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    public ItemStack getBucketItemStack() {
        return ((Item)ItemInit.THALASSIAN_SEAHORSE_BUCKET.get()).getDefaultInstance();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public boolean canBeLeashed() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public static int betterNiceColor() {
        return ThreadLocalRandom.current().nextInt(0x1000000);
    }

    public boolean isMovingSlowly() {
        return this.getDeltaMovement().x() != 0.0 && this.getDeltaMovement().y() != 0.0 && this.getDeltaMovement().z() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(SWIM_ANIMATION);
        } else {
            for (BlockPos pos : this.HORIZONAL_DIRECTIONS) {
                for (Block block : this.CORALS) {
                    if (this.level().getBlockState(this.blockPosition().offset((Vec3i)pos)).equals(block.defaultBlockState())) {
                        event.getController().setAnimation(IDLE_ANIMATION);
                        continue;
                    }
                    event.getController().setAnimation(IDLE_ANIMATION);
                }
            }
        }
        return PlayState.CONTINUE;
    }
}

