/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ZombieStarfishEntity
extends Monster
implements GeoEntity {
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.walk");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.idle");
    private static final RawAnimation EAT_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.eat");
    private static final RawAnimation JUMP_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.jump");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ZombieStarfishEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public static AttributeSupplier.Builder createStarfishAttributes() {
        return ZombieStarfishEntity.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 1.2);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected boolean canRide(Entity entity) {
        return !entity.isVehicle() && !entity.hasPassenger((Entity)this);
    }

    public void rideTick() {
        Player player;
        Entity entity = this.getVehicle();
        if (entity instanceof Player && (player = (Player)entity).isShiftKeyDown()) {
            this.stopRiding();
        }
        if (!(entity.isAlive() || entity instanceof Drowned || entity instanceof Player || this.canRide(entity))) {
            this.stopRiding();
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (entity instanceof Drowned) {
                Drowned drowned = (Drowned)entity;
                this.setPos(drowned.getX(), Math.max(drowned.getY() + (double)(drowned.getEyeHeight() * 0.25f), drowned.getY()), drowned.getZ());
                drowned.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 5));
                if (drowned.getHealth() > 1.0f) {
                    drowned.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
                }
                if (!drowned.isAlive()) {
                    this.removeVehicle();
                }
            } else if (entity instanceof Player) {
                Player player2 = (Player)entity;
                this.setPos(player2.getX(), Math.max(player2.getY() + (double)player2.getEyeHeight(), player2.getY()), player2.getZ());
                player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 5));
                player2.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
                if (!player2.isAlive() || player2.isCreative()) {
                    this.removeVehicle();
                }
            }
        }
    }

    public static boolean canSpawn(EntityType<ZombieStarfishEntity> ZombieStarfishEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() >= 75 && 95 >= pos.getY() && serverWorldAccess.getBlockState(pos).is(Blocks.WATER);
    }

    public boolean canBeLeashed() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{ZombieStarfishEntity.class}));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void aiStep() {
        super.aiStep();
        this.setTarget((LivingEntity)this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.getDeltaMovement().x() != 0.0 && this.getDeltaMovement().y() != 0.0 && this.getDeltaMovement().z() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (this.isPassenger()) {
            event.getController().setAnimation(EAT_ANIMATION);
        } else if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (this.isSwimming()) {
            event.getController().setAnimation(JUMP_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

