/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;

public class LatchOntoGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final LivingEntity parentEntity;

    public LatchOntoGoal(Mob livingEntity, Class<T> target, boolean unknown) {
        super(livingEntity, target, unknown);
        this.parentEntity = livingEntity;
    }

    public boolean canUse() {
        PathfinderMob pathfinderMob;
        LivingEntity livingEntity = this.parentEntity;
        return livingEntity instanceof PathfinderMob && !(pathfinderMob = (PathfinderMob)livingEntity).isPassenger() && pathfinderMob.getTarget() != null;
    }

    public void tick() {
        PathfinderMob pathfinderMob;
        LivingEntity livingEntity = this.parentEntity;
        if (livingEntity instanceof PathfinderMob && !(pathfinderMob = (PathfinderMob)livingEntity).isPassenger() && pathfinderMob.getTarget() != null) {
            pathfinderMob.startRiding((Entity)pathfinderMob.getTarget());
        }
    }
}

