/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mystic.atlantis.entities.NymphBoatEntity;
import com.mystic.atlantis.entities.models.NymphBoatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Quaternionf;

public class NymphBoatRenderer
extends EntityRenderer<NymphBoatEntity> {
    private final NymphBoatModel model;

    public NymphBoatRenderer(EntityRendererProvider.Context p_173936_) {
        super(p_173936_);
        this.shadowRadius = 0.8f;
        this.model = new NymphBoatModel(p_173936_.bakeLayer(ModelLayers.createBoatModelName((Boat.Type)Boat.Type.OAK)));
    }

    public void render(NymphBoatEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0, 0.375, 0.0);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.mulPose(new Quaternionf().rotateAxis(Math.toRadians((float)pEntity.getBubbleAngle(pPartialTicks)), 1.0f, 0.0f, 1.0f));
        }
        ResourceLocation resourcelocation = this.getTextureLocation(pEntity);
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        this.model.setupAnim(pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.model.renderType(resourcelocation));
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        if (!pEntity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.waterMask());
            this.model.waterPatch().render(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.NO_OVERLAY);
        }
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @Deprecated
    @NotNull
    public ResourceLocation getTextureLocation(NymphBoatEntity pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"atlantis", (String)"textures/entity/boat/nymph.png");
    }
}

