/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.event;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.datagen.EnchantmentInit;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.init.EffectsInit;
import com.mystic.atlantis.init.ItemInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.enchanting.EnchantmentLevelSetEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class CommonEvents {
    public static final String NOT_FIRST_SPAWN_NBT = "atlantis.not_first_spawn";
    public static ResourceKey<Level> previousDimension;
    public static Map<ResourceLocation, Integer> map;

    public static boolean hasEnchantment(Level level, ItemStack itemStack, ResourceKey<Enchantment> enchantment) {
        return level.registryAccess().holder(enchantment).filter(holder -> itemStack.getEnchantments().getLevel((Holder)holder) > 0).isPresent();
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        ItemEntity item;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (item = (ItemEntity)entity).getItem().getItem() == ItemInit.SEASALT.get()) {
            Level world = item.level();
            ItemEntity item2 = new ItemEntity(world, item.getX(), item.getY(), item.getZ(), new ItemStack((ItemLike)ItemInit.SODIUM_NUGGET.get(), item.getItem().getCount()));
            if (!world.isClientSide) {
                world.addFreshEntity((Entity)item2);
                if (item2.isOnFire()) {
                    item2.clearFire();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPostDamageEffects(LivingDamageEvent.Post event) {
        ItemStack weapon;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.level();
        RandomSource random = player.getRandom();
        Entity attacker = event.getSource().getEntity();
        if (player.hasEffect(EffectsInit.SPIKES) && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            livingAttacker.hurt(player.damageSources().thorns((Entity)player), (float)CommonEvents.getDamage(3, (Random)random));
        }
        if (CommonEvents.hasEnchantment(level, weapon = player.getMainHandItem(), EnchantmentInit.TIDE_CALL) && weapon.getItem().toString().contains("trident") && attacker instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)attacker;
            target.hurt(player.damageSources().trident((Entity)player, (Entity)target), (float)CommonEvents.getDamage(3, (Random)random));
        }
    }

    private static boolean isAquaticEnchantment(Level level, Holder<Enchantment> enchantment) {
        return enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.GILL_BREATH)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.ABYSSAL_ARMOR)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.REEL_BIND)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.CURRENT_GLIDE)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.TIDE_CALL)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.ABYSS_WALKER)) || enchantment.equals(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.DEPTH_PULSE));
    }

    @SubscribeEvent
    public static void onFishCaught(ItemFishedEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        ItemStack rod = player.getMainHandItem();
        if (!rod.is(Items.FISHING_ROD) && !(rod = player.getOffhandItem()).is(Items.FISHING_ROD)) {
            return;
        }
        if (!CommonEvents.hasEnchantment(level, rod, EnchantmentInit.REEL_BIND)) {
            return;
        }
        int enchantLevel = EnchantmentHelper.getTagEnchantmentLevel(EnchantmentInit.getEnchantmentHolder(level, EnchantmentInit.REEL_BIND), (ItemStack)rod);
        RandomSource random = level.getRandom();
        if (random.nextFloat() < 0.1f * (float)enchantLevel) {
            ResourceKey lootKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Atlantis.id("gameplay/reel_bind_bonus"));
            LootTable table = Objects.requireNonNull(level.getServer()).reloadableRegistries().getLootTable(lootKey);
            LootParams params = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.GIFT);
            ObjectArrayList loot = table.getRandomItems(params);
            for (ItemStack stack : loot) {
                level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack));
            }
        }
        int bonusXp = 5 * enchantLevel;
        level.addFreshEntity((Entity)new ExperienceOrb(level, player.getX(), player.getY(), player.getZ(), bonusXp));
    }

    @SubscribeEvent
    public static void onEnchantmentLevelSet(EnchantmentLevelSetEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.isClientSide) {
            return;
        }
        int fishCount = level.getEntitiesOfClass(AbstractFish.class, new AABB(pos).inflate(4.0)).size();
        if (fishCount < 8) {
            return;
        }
        Stream<Holder> allEnchantments = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().filter(holder -> event.getItem().isPrimaryItemFor((Holder)holder)).map(holder -> Holder.direct((Object)((Enchantment)holder.value())));
        List possible = EnchantmentHelper.getAvailableEnchantmentResults((int)event.getEnchantLevel(), (ItemStack)event.getItem(), allEnchantments);
        Optional<EnchantmentInstance> aquatic = fishCount >= 24 ? possible.stream().filter(e -> CommonEvents.isAquaticEnchantment(level, (Holder<Enchantment>)e.enchantment)).max(Comparator.comparingInt(e -> e.level)) : (fishCount >= 16 ? possible.stream().filter(e -> CommonEvents.isAquaticEnchantment(level, (Holder<Enchantment>)e.enchantment)).findFirst() : possible.stream().filter(e -> CommonEvents.isAquaticEnchantment(level, (Holder<Enchantment>)e.enchantment)).findAny());
        aquatic.ifPresent(e -> event.setEnchantLevel(e.level));
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)AtlantisConfig.CONFIG.startInAtlantis.get()).booleanValue() && event.getEntity().getServer() != null) {
            ServerLevel atlantisLevel = event.getEntity().getServer().getLevel(AtlantisDimensions.ATLANTIS_WORLD);
            CompoundTag tag = event.getEntity().getPersistentData();
            CompoundTag persistedTag = tag.getCompound("PlayerPersisted");
            if (AtlantisDimensions.ATLANTIS_WORLD != null) {
                boolean isFirstTimeSpawning;
                boolean bl = isFirstTimeSpawning = !persistedTag.getBoolean(NOT_FIRST_SPAWN_NBT);
                if (isFirstTimeSpawning && atlantisLevel != null) {
                    persistedTag.putBoolean(NOT_FIRST_SPAWN_NBT, true);
                    tag.put("PlayerPersisted", (Tag)persistedTag);
                    Player player = event.getEntity();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CommonEvents.sendPlayerToDimension(serverPlayer, atlantisLevel, new Vec3((double)atlantisLevel.getLevel().getLevelData().getSpawnPos().getX(), 100.0, (double)atlantisLevel.getLevel().getLevelData().getSpawnPos().getZ()));
                    }
                }
            }
        }
    }

    private static void sendPlayerToDimension(ServerPlayer serverPlayer, ServerLevel targetWorld, Vec3 targetVec) {
        targetWorld.getChunk(new BlockPos((int)targetVec.x, (int)targetVec.y, (int)targetVec.z));
        serverPlayer.teleportTo(targetWorld, targetVec.x(), targetVec.y(), targetVec.z(), serverPlayer.getYRot(), serverPlayer.getXRot());
    }

    @SubscribeEvent
    public static void onDeathEvent(LivingDeathEvent event) {
        previousDimension = event.getEntity().level().dimension();
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(EntityInvulnerabilityCheckEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.getArmorSlots()) {
                if (!CommonEvents.hasEnchantment(player.level(), stack, EnchantmentInit.LIGHTNING_PROTECTION) || !event.getSource().is(DamageTypes.LIGHTNING_BOLT)) continue;
                event.setInvulnerable(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onTickFishBasedEnchantments(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        if (CommonEvents.hasEnchantment(level, helmet, EnchantmentInit.GILL_BREATH) && player.isUnderWater()) {
            player.setAirSupply(Math.min(player.getMaxAirSupply(), player.getAirSupply() + 1));
        }
        if (CommonEvents.hasEnchantment(level, feet, EnchantmentInit.CURRENT_GLIDE) && player.isInWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 40, 0, false, false, true));
        }
        if (CommonEvents.hasEnchantment(level, legs, EnchantmentInit.ABYSS_WALKER) && player.isInWater()) {
            player.removeEffect(MobEffects.DIG_SLOWDOWN);
        }
        if (CommonEvents.hasEnchantment(level, chest, EnchantmentInit.ABYSSAL_ARMOR) && player.isInWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 0, false, false, true));
        }
    }

    private static int getDamage(int i, Random random) {
        return i > 10 ? i - 10 : 1 + random.nextInt(4);
    }

    @SubscribeEvent
    public static void onSwimExitDetection(EntityTickEvent.Pre event) {
        boolean isSwimmingNow;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        boolean wasSwimming = data.getBoolean("atlantis_was_swimming");
        boolean bl = isSwimmingNow = player.isSwimming() && player.isInWater();
        if (wasSwimming && !isSwimmingNow) {
            CommonEvents.onSwimExit(player, level);
        }
        data.putBoolean("atlantis_was_swimming", isSwimmingNow);
    }

    private static void onSwimExit(Player player, Level level) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!CommonEvents.hasEnchantment(level, chest, EnchantmentInit.DEPTH_PULSE)) {
            return;
        }
        Vec3 pos = player.position();
        level.getEntities((Entity)player, player.getBoundingBox().inflate(4.0), e -> e instanceof LivingEntity && e != player).forEach(entity -> {
            Vec3 push = entity.position().subtract(pos).normalize().scale(0.6);
            entity.push(push.x, 0.5, push.z);
            entity.hurt(player.damageSources().explosion((Entity)player, entity), 1.0f);
        });
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, pos.x, pos.y, pos.z, 20, 1.0, 1.0, 1.0, 0.2);
        }
        level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

