/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.blockentities.plants.AnemoneBlock;
import com.mystic.atlantis.blocks.blockentities.plants.BlueLilyBlock;
import com.mystic.atlantis.blocks.blockentities.plants.BurntDeepBlock;
import com.mystic.atlantis.blocks.blockentities.plants.SeashroomBlock;
import com.mystic.atlantis.blocks.blockentities.plants.TuberUpBlock;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GardenFoliageFeature
extends Feature<NoneFeatureConfiguration> {
    public GardenFoliageFeature(Codec<NoneFeatureConfiguration> FeatureSpreadConfig) {
        super(FeatureSpreadConfig);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        BlockState blockstate;
        WorldGenLevel reader = config.level();
        RandomSource rand = config.random();
        BlockPos pos = config.origin();
        switch (rand.nextInt(5)) {
            case 1: {
                BlockState blockState = ((TuberUpBlock)((Object)BlockInit.TUBER_UP.get())).defaultBlockState();
                break;
            }
            case 2: {
                BlockState blockState = ((AnemoneBlock)((Object)BlockInit.ANEMONE.get())).defaultBlockState();
                break;
            }
            case 3: {
                BlockState blockState = ((BlueLilyBlock)((Object)BlockInit.BLUE_LILY.get())).defaultBlockState();
                break;
            }
            case 4: {
                BlockState blockState = ((BurntDeepBlock)((Object)BlockInit.BURNT_DEEP.get())).defaultBlockState();
                break;
            }
            default: {
                BlockState blockState = blockstate = ((SeashroomBlock)((Object)BlockInit.SEASHROOM.get())).defaultBlockState();
            }
        }
        if (reader.getBlockState(pos).is(Blocks.WATER) && blockstate.canSurvive((LevelReader)reader, pos)) {
            reader.setBlock(pos, blockstate, 2);
            return true;
        }
        return false;
    }
}

