/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.base.SeabedBlock;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class IslandsFeature
extends Feature<NoneFeatureConfiguration> {
    FastNoiseLite perlin = null;

    public IslandsFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        this.setSeed(context.level().getSeed());
        double radius = 15.0;
        BlockPos pos = context.origin();
        SectionPos chunkPos = SectionPos.of((BlockPos)pos);
        if (context.level().getHeight() < 60) {
            return false;
        }
        if ((chunkPos.getX() & 1) == 1 || (chunkPos.getY() & 1) == context.random().nextInt(2) || (chunkPos.getZ() & 1) == 1) {
            return false;
        }
        if (((Boolean)AtlantisConfig.CONFIG.islandsOn.get()).booleanValue()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (double x = -radius; x <= radius; x += 1.0) {
                for (double y = 1.0; y <= radius; y += 1.0) {
                    for (double z = -radius; z <= radius; z += 1.0) {
                        mutable.set((Vec3i)context.origin()).move((int)x, (int)(y - radius), (int)z);
                        double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.getX(), mutable.getY(), mutable.getZ()));
                        double scaledNoise = noise * (y * 3.0 / (x * x + z * z));
                        if (!(scaledNoise >= 0.5)) continue;
                        if (y == radius) {
                            context.level().setBlock((BlockPos)mutable, ((SeabedBlock)((Object)BlockInit.SEABED.get())).defaultBlockState(), 2);
                            continue;
                        }
                        context.level().setBlock((BlockPos)mutable, Blocks.SANDSTONE.defaultBlockState(), 2);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

