/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.shells.NautilusShellBlock;
import com.mystic.atlantis.blocks.shells.OysterShellBlock;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ShellBlockFeature
extends Feature<NoneFeatureConfiguration> {
    public ShellBlockFeature(Codec<NoneFeatureConfiguration> FeatureSpreadConfig) {
        super(FeatureSpreadConfig);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        WorldGenLevel reader = config.level();
        RandomSource rand = config.random();
        BlockPos pos = config.origin();
        int randomNum = rand.nextInt(DyeColor.values().length + 1);
        DyeColor color = DyeColor.byId((int)randomNum);
        BlockState blockstate = switch (rand.nextInt(12)) {
            case 0 -> ((Block)BlockInit.COLORED_SHELL_BLOCKS.get(color).get()).defaultBlockState();
            case 1 -> ((NautilusShellBlock)((Object)BlockInit.NAUTILUS_SHELL_BLOCK.get())).defaultBlockState();
            case 2 -> ((NautilusShellBlock)((Object)BlockInit.CRACKED_NAUTILUS_SHELL.get())).defaultBlockState();
            case 3 -> ((OysterShellBlock)((Object)BlockInit.CRACKED_OYSTER_SHELL.get())).defaultBlockState();
            case 4 -> ((Block)BlockInit.CRACKED_SHELL_BLOCKS.get(color).get()).defaultBlockState();
            case 5 -> ((OysterShellBlock)((Object)BlockInit.OYSTER_SHELL_BLOCK.get())).defaultBlockState();
            case 6 -> ((NautilusShellBlock)((Object)BlockInit.CRACKED_MOSSY_NAUTILUS_SHELL.get())).defaultBlockState();
            case 7 -> ((NautilusShellBlock)((Object)BlockInit.MOSSY_NAUTILUS_SHELL.get())).defaultBlockState();
            case 8 -> ((OysterShellBlock)((Object)BlockInit.CRACKED_MOSSY_OYSTER_SHELL.get())).defaultBlockState();
            case 9 -> ((OysterShellBlock)((Object)BlockInit.MOSSY_OYSTER_SHELL.get())).defaultBlockState();
            case 10 -> ((Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(color).get()).defaultBlockState();
            case 11 -> ((Block)BlockInit.MOSSY_SHELL_BLOCKS.get(color).get()).defaultBlockState();
            default -> throw new IllegalStateException("Unexpected value: " + rand.nextInt(12));
        };
        if (reader.getBlockState(pos).is(Blocks.WATER) && blockstate.canSurvive((LevelReader)reader, pos)) {
            reader.setBlock(pos, blockstate, 2);
            return true;
        }
        return false;
    }
}

