/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.base.BubbleMagmaBlock;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class VolcanoesFeature
extends Feature<NoneFeatureConfiguration> {
    FastNoiseLite fnlPerlin = null;

    public VolcanoesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        this.setSeed(context.level().getSeed());
        BlockPos pos = context.origin();
        SectionPos chunkPos = SectionPos.of((BlockPos)pos);
        if ((chunkPos.getX() & 1) == 1 || (chunkPos.getY() & 1) == context.random().nextInt(2) || (chunkPos.getZ() & 1) == 1) {
            return false;
        }
        if (!context.level().getBlockState(context.origin().below()).isSolidRender((BlockGetter)context.level(), pos)) {
            return false;
        }
        if (((Boolean)AtlantisConfig.CONFIG.volcanoesOn.get()).booleanValue()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            double baseRadius = 15.0;
            double waterLeakage = 0.7;
            double calciteBase = 0.6;
            int volcanoConeSize = 55;
            int volcanoStartHeight = volcanoConeSize - 5;
            double threshold = 0.5;
            for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
                for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                    for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                        mutable.set((Vec3i)context.origin()).move((int)x, (int)y + volcanoStartHeight, (int)z);
                        float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.getX(), mutable.getZ()));
                        double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                        if (scaledNoise - waterLeakage >= threshold) {
                            if (mutable.getY() <= context.origin().getY() + (volcanoStartHeight - 14)) {
                                context.level().setBlock((BlockPos)mutable, Blocks.WATER.defaultBlockState(), 2);
                                context.level().scheduleTick((BlockPos)mutable, (Fluid)Fluids.WATER, 0);
                            }
                        } else if (scaledNoise >= threshold) {
                            context.level().setBlock((BlockPos)mutable, Blocks.BASALT.defaultBlockState(), 2);
                        }
                        if (!(scaledNoise - calciteBase >= threshold) || mutable.getY() > 70 || mutable.getY() < 40) continue;
                        context.level().setBlock((BlockPos)mutable, ((BubbleMagmaBlock)((Object)BlockInit.BUBBLE_MAGMA.get())).defaultBlockState(), 2);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

