/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.blocks.aquatic_power.SodiumPrimedBombBlock;
import com.mystic.atlantis.entities.AquaielJellyfishEntity;
import com.mystic.atlantis.entities.CoconutCrabEntity;
import com.mystic.atlantis.entities.GlittertailShrimpEntity;
import com.mystic.atlantis.entities.LeviathanEntity;
import com.mystic.atlantis.entities.NymphBoatEntity;
import com.mystic.atlantis.entities.PalmBoatEntity;
import com.mystic.atlantis.entities.RubyclawCrabEntity;
import com.mystic.atlantis.entities.StarfishEntity;
import com.mystic.atlantis.entities.SubmarineEntity;
import com.mystic.atlantis.entities.ThalassianSeahorseEntity;
import com.mystic.atlantis.entities.ZombieStarfishEntity;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AtlantisEntityInit {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"atlantis");
    public static final DeferredHolder<EntityType<?>, EntityType<NymphBoatEntity>> NYMPH_BOAT = AtlantisEntityInit.register("nymph_boat", EntityType.Builder.of(NymphBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<PalmBoatEntity>> PALM_BOAT = AtlantisEntityInit.register("palm_boat", EntityType.Builder.of(PalmBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<RubyclawCrabEntity>> RUBYCLAW_CRAB = AtlantisEntityInit.register("rubyclaw_crab", EntityType.Builder.of(RubyclawCrabEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.2f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<CoconutCrabEntity>> COCONUT_CRAB = AtlantisEntityInit.register("coconut_crab", EntityType.Builder.of(CoconutCrabEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.2f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<AquaielJellyfishEntity>> AQUAIEL_JELLYFISH = AtlantisEntityInit.register("aquaiel_jellyfish", EntityType.Builder.of(AquaielJellyfishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.4f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<GlittertailShrimpEntity>> GLITTERTAIL_SHRIMP = AtlantisEntityInit.register("glittertail_shrimp", EntityType.Builder.of(GlittertailShrimpEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<LeviathanEntity>> LEVIATHAN = AtlantisEntityInit.register("leviathan", EntityType.Builder.of(LeviathanEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.5f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<ThalassianSeahorseEntity>> THALASSIAN_SEAHORSE = AtlantisEntityInit.register("thalassian_seahorse", EntityType.Builder.of(ThalassianSeahorseEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(0.4f, 1.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<StarfishEntity>> STARFISH = AtlantisEntityInit.register("starfish", EntityType.Builder.of(StarfishEntity::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.5f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieStarfishEntity>> ZOMBIE_STARFISH = AtlantisEntityInit.register("zombie_starfish", EntityType.Builder.of(ZombieStarfishEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.5f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<SodiumPrimedBombBlock>> SODIUM_BOMB = AtlantisEntityInit.register("sodium_bomb", EntityType.Builder.of(SodiumPrimedBombBlock::new, (MobCategory)MobCategory.MISC).fireImmune().sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(10));
    public static final DeferredHolder<EntityType<?>, EntityType<SubmarineEntity>> SUBMARINE = AtlantisEntityInit.register("submarine", EntityType.Builder.of(SubmarineEntity::new, (MobCategory)MobCategory.MISC).sized(1.6f, 1.6f).clientTrackingRange(1));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.build(name));
    }

    @SubscribeEvent
    public static void onAttributeModify(EntityAttributeCreationEvent event) {
        event.put((EntityType)COCONUT_CRAB.get(), CoconutCrabEntity.createCoconutCrabAttributes().build());
        event.put((EntityType)RUBYCLAW_CRAB.get(), RubyclawCrabEntity.createCrabAttributes().build());
        event.put((EntityType)AQUAIEL_JELLYFISH.get(), AquaielJellyfishEntity.createJellyfishAttributes().build());
        event.put((EntityType)GLITTERTAIL_SHRIMP.get(), GlittertailShrimpEntity.createShrimpAttributes().build());
        event.put((EntityType)LEVIATHAN.get(), LeviathanEntity.createLeviathanAttributes().build());
        event.put((EntityType)THALASSIAN_SEAHORSE.get(), ThalassianSeahorseEntity.createSeahorseAttributes().build());
        event.put((EntityType)STARFISH.get(), StarfishEntity.createStarfishAttributes().build());
        event.put((EntityType)ZOMBIE_STARFISH.get(), ZombieStarfishEntity.createStarfishAttributes().build());
    }

    public static void init(IEventBus bus) {
        ENTITIES.register(bus);
        bus.addListener(AtlantisEntityInit::onAttributeModify);
    }
}

