/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mystic.atlantis.init.ItemInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AtlantisModifierInit {
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"atlantis");
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<SeaGrassModifier>> SEEDS_DROP = GLM.register("seeds_drop", SeaGrassModifier.CODEC);

    public static void init(IEventBus bus) {
        GLM.register(bus);
    }

    public static class SeaGrassModifier
    extends LootModifier {
        public static final Supplier<MapCodec<SeaGrassModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> SeaGrassModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SeaGrassModifier::new)));

        public SeaGrassModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            BlockState ctxBlockState;
            int silkTouch;
            HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)context.getLevel().registryAccess().lookup(Registries.ENCHANTMENT).get();
            ItemStack ctxTool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
            RandomSource random = context.getRandom();
            if (ctxTool != null && ((silkTouch = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)ctxTool)) > 0 || ctxTool.getItem() instanceof ShearsItem)) {
                return generatedLoot;
            }
            int bonusLevel = ctxTool != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.FORTUNE), (ItemStack)ctxTool) : 0;
            int seedRarity = (int)(0.5f - (float)(bonusLevel * 2));
            if (!(seedRarity >= 1 && random.nextInt(seedRarity) != 0 || (ctxBlockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE)) != Blocks.SEAGRASS.defaultBlockState() && ctxBlockState != Blocks.TALL_SEAGRASS.defaultBlockState())) {
                generatedLoot.add((Object)new ItemStack((ItemLike)ItemInit.FIRE_MELON_SEEDS.get()));
            }
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    public static class DataProvider
    extends GlobalLootModifierProvider {
        public DataProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> registries, String modid) {
            super(gen.getPackOutput(), registries, modid);
        }

        protected void start() {
            this.add("seeds_drop", (IGlobalLootModifier)new SeaGrassModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.SEAGRASS).build()}), new ICondition[0]);
        }
    }
}

