/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.CuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprum;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumDoorBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumFullBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumGrateBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumSlabBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumStairsBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumTrapdoorBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerComparatorBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerDustBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerLampBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerLeverBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerRepeaterBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerStoneBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTorchBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTripwireBlock;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTripwireHook;
import com.mystic.atlantis.blocks.aquatic_power.SodiumBombBlock;
import com.mystic.atlantis.blocks.aquatic_power.WallAquaticPowerTorchBlock;
import com.mystic.atlantis.blocks.base.AlgaeBlock;
import com.mystic.atlantis.blocks.base.AlgaeDetritusStoneBlock;
import com.mystic.atlantis.blocks.base.AncientWoodBlock;
import com.mystic.atlantis.blocks.base.AquamarineBlock;
import com.mystic.atlantis.blocks.base.AtlanteanCoreBlock;
import com.mystic.atlantis.blocks.base.AtlanteanPortalBlock;
import com.mystic.atlantis.blocks.base.AtlanteanPortalFrame;
import com.mystic.atlantis.blocks.base.BubbleMagmaBlock;
import com.mystic.atlantis.blocks.base.CarvedCoconut;
import com.mystic.atlantis.blocks.base.ChiseledAquamarineBlock;
import com.mystic.atlantis.blocks.base.Coconut;
import com.mystic.atlantis.blocks.base.CoconutSlice;
import com.mystic.atlantis.blocks.base.CrackedGlowstoneBlock;
import com.mystic.atlantis.blocks.base.CrystalTransferenceBlock;
import com.mystic.atlantis.blocks.base.DeadGlowstoneBlock;
import com.mystic.atlantis.blocks.base.DetritusSandstoneBlock;
import com.mystic.atlantis.blocks.base.EquipableCarvedCoconut;
import com.mystic.atlantis.blocks.base.EquipableCoconut;
import com.mystic.atlantis.blocks.base.FireMelonFruitBlock;
import com.mystic.atlantis.blocks.base.FireMelonSpikedFruitBlock;
import com.mystic.atlantis.blocks.base.HardenedCalciteBlock;
import com.mystic.atlantis.blocks.base.LinguisticBlock;
import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.blocks.base.LuminescentPrismarine;
import com.mystic.atlantis.blocks.base.NymphLeavesBlock;
import com.mystic.atlantis.blocks.base.NymphLogBlock;
import com.mystic.atlantis.blocks.base.NymphWoodBlock;
import com.mystic.atlantis.blocks.base.OceanLanternBlock;
import com.mystic.atlantis.blocks.base.PalmLeavesBlock;
import com.mystic.atlantis.blocks.base.PalmLogBlock;
import com.mystic.atlantis.blocks.base.PalmWoodBlock;
import com.mystic.atlantis.blocks.base.PearlBlock;
import com.mystic.atlantis.blocks.base.PushBubbleColumnBlock;
import com.mystic.atlantis.blocks.base.SeabedBlock;
import com.mystic.atlantis.blocks.base.SeasaltChunkBlock;
import com.mystic.atlantis.blocks.base.StrippedNymphLog;
import com.mystic.atlantis.blocks.base.StrippedPalmLog;
import com.mystic.atlantis.blocks.base.SunkenGravelBlock;
import com.mystic.atlantis.blocks.base.SurgeLanternBlock;
import com.mystic.atlantis.blocks.base.WaterfallBlock;
import com.mystic.atlantis.blocks.base.WaveBlock;
import com.mystic.atlantis.blocks.base.WritingBlock;
import com.mystic.atlantis.blocks.blockentities.plants.AnemoneBlock;
import com.mystic.atlantis.blocks.blockentities.plants.BlueLilyBlock;
import com.mystic.atlantis.blocks.blockentities.plants.BurntDeepBlock;
import com.mystic.atlantis.blocks.blockentities.plants.SeashroomBlock;
import com.mystic.atlantis.blocks.blockentities.plants.TuberUpBlock;
import com.mystic.atlantis.blocks.plants.AlgaePlantBlock;
import com.mystic.atlantis.blocks.plants.NymphSaplingBlock;
import com.mystic.atlantis.blocks.plants.PalmSaplingBlock;
import com.mystic.atlantis.blocks.plants.PurpleSeashroom;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.blocks.plants.YellowSeashroom;
import com.mystic.atlantis.blocks.pots.BelenPotBlock;
import com.mystic.atlantis.blocks.pots.CelenPotBlock;
import com.mystic.atlantis.blocks.pots.HorpenPotBlock;
import com.mystic.atlantis.blocks.pots.ObemoPotBlock;
import com.mystic.atlantis.blocks.pots.SnownPotBlock;
import com.mystic.atlantis.blocks.pots.ToperPotBlock;
import com.mystic.atlantis.blocks.pots.TubenPotBlock;
import com.mystic.atlantis.blocks.shells.ColoredShellBlock;
import com.mystic.atlantis.blocks.shells.CrackedShellBlock;
import com.mystic.atlantis.blocks.shells.NautilusShellBlock;
import com.mystic.atlantis.blocks.shells.OysterShellBlock;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.FireMelonBody;
import com.mystic.atlantis.init.FireMelonHead;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.GlyphBlock;
import com.mystic.atlantis.init.ItemInit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class BlockInit {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"atlantis");
    public static final Map<LinguisticGlyph, Map<DyeColor, DeferredBlock<Block>>> DYED_LINGUISTICS = new HashMap<LinguisticGlyph, Map<DyeColor, DeferredBlock<Block>>>();
    public static final Map<LinguisticGlyph, DeferredBlock<Block>> NON_LINGUISTICS = new HashMap<LinguisticGlyph, DeferredBlock<Block>>();
    public static final Map<DyeColor, DeferredBlock<Block>> COLORED_SHELL_BLOCKS = new HashMap<DyeColor, DeferredBlock<Block>>();
    public static final Map<DyeColor, DeferredBlock<Block>> CRACKED_SHELL_BLOCKS = new HashMap<DyeColor, DeferredBlock<Block>>();
    public static final Map<DyeColor, DeferredBlock<Block>> CRACKED_MOSSY_SHELL_BLOCKS = new HashMap<DyeColor, DeferredBlock<Block>>();
    public static final Map<DyeColor, DeferredBlock<Block>> MOSSY_SHELL_BLOCKS = new HashMap<DyeColor, DeferredBlock<Block>>();
    public static final Map<DyeColor, BlockType> SEA_GLASS_PATTERNS = new HashMap<DyeColor, BlockType>();
    public static final Map<DyeColor, BlockType> SEA_GLASS_LIST = new HashMap<DyeColor, BlockType>();
    public static final DeferredBlock<Block> WATERFALL_BLOCK = BlockInit.registerBlock("waterfall_block", () -> new WaterfallBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> WAVE_BLOCK = BlockInit.registerBlock("wave_block", () -> new WaveBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> CRYSTAL_TRANSFERENCE_BLOCK = BlockInit.registerBlock("crystal_transference_block", () -> new CrystalTransferenceBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> ATLANTEAN_PORTAL_FRAME = BlockInit.registerBlock("atlantean_portal_frame", AtlanteanPortalFrame::new);
    public static final DeferredBlock<AtlanteanPortalBlock> ATLANTEAN_PORTAL = BlockInit.registerOnlyBlock("atlantean_portal", () -> new AtlanteanPortalBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<LiquidBlock> JETSTREAM_WATER = BLOCKS.register("jetstream_water", () -> new LiquidBlock((FlowingFluid)FluidInit.JETSTREAM_WATER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final DeferredBlock<LiquidBlock> SALTY_SEAWATER = BLOCKS.register("salty_seawater", () -> new LiquidBlock((FlowingFluid)FluidInit.SALTY_SEAWATER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static BlockSetType NYMPH_BLOCK_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("nymph"));
    public static BlockSetType PALM_BLOCK_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("palm"));
    public static final WoodType NYMPH_WOOD_TYPE = WoodType.register((WoodType)new WoodType("nymph", NYMPH_BLOCK_TYPE));
    public static final WoodType PALM_WOOD_TYPE = WoodType.register((WoodType)new WoodType("palm", PALM_BLOCK_TYPE));
    public static final DeferredBlock<Block> TUBEN_POT = BlockInit.registerBlock("tuben_pot", () -> new TubenPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> BELEN_POT = BlockInit.registerBlock("belen_pot", () -> new BelenPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> TOPER_POT = BlockInit.registerBlock("toper_pot", () -> new ToperPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> SNOWN_POT = BlockInit.registerBlock("snown_pot", () -> new SnownPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> HORPEN_POT = BlockInit.registerBlock("horpen_pot", () -> new HorpenPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> CELEN_POT = BlockInit.registerBlock("celen_pot", () -> new CelenPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<Block> OBEMO_POT = BlockInit.registerBlock("obemo_pot", () -> new ObemoPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound(SoundType.DECORATED_POT)));
    public static final DeferredBlock<CoconutSlice> COCONUT_SLICE = BlockInit.registerOnlyBlock("coconut_slice", () -> new CoconutSlice(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Coconut> COCONUT = BlockInit.registerBlock("coconut", () -> new EquipableCoconut(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(1.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<EquipableCarvedCoconut> CARVED_COCONUT = BlockInit.registerBlock("carved_coconut", () -> new EquipableCarvedCoconut(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(1.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<CarvedCoconut> SATIRE_LANTERN = BlockInit.registerBlock("satire_lantern", () -> new CarvedCoconut(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(1.0f).sound(SoundType.WOOD).lightLevel(p_50870_ -> 15)));
    public static final DeferredBlock<PalmLogBlock> PALM_LOG = BlockInit.registerBlock("palm_log", () -> new PalmLogBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<StrippedPalmLog> STRIPPED_PALM_LOG = BlockInit.registerBlock("stripped_palm_log", () -> new StrippedPalmLog(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<StandingSignBlock> PALM_SIGN = BlockInit.registerOnlyBlock("palm_sign", () -> new StandingSignBlock(PALM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    public static final DeferredBlock<WallSignBlock> PALM_WALL_SIGN = BlockInit.registerOnlyBlock("palm_wall_sign", () -> new WallSignBlock(PALM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    public static final BlockType PALM_PLANKS = BlockInit.registerBlockType("palm", PalmWoodBlock::new, BlockBehaviour.Properties.of().sound(SoundType.WOOD).requiresCorrectToolForDrops().strength(2.0f), true, PALM_BLOCK_TYPE, PALM_WOOD_TYPE, 30, true);
    public static final DeferredBlock<NymphLogBlock> NYMPH_LOG = BlockInit.registerBlock("nymph_log", () -> new NymphLogBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<StrippedNymphLog> STRIPPED_NYMPH_LOG = BlockInit.registerBlock("stripped_nymph_log", () -> new StrippedNymphLog(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<StandingSignBlock> NYMPH_SIGN = BlockInit.registerOnlyBlock("nymph_sign", () -> new StandingSignBlock(NYMPH_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallSignBlock> NYMPH_WALL_SIGN = BlockInit.registerOnlyBlock("nymph_wall_sign", () -> new WallSignBlock(NYMPH_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    public static final BlockType NYMPH_PLANKS = BlockInit.registerBlockType("nymph", NymphWoodBlock::new, BlockBehaviour.Properties.of().sound(SoundType.WOOD).requiresCorrectToolForDrops().strength(2.0f), true, NYMPH_BLOCK_TYPE, NYMPH_WOOD_TYPE, 30, true);
    public static final DeferredBlock<SeashroomBlock> SEASHROOM = BlockInit.registerBlock("seashroom", SeashroomBlock::new);
    public static final DeferredBlock<TuberUpBlock> TUBER_UP = BlockInit.registerBlock("tuber_up", TuberUpBlock::new);
    public static final DeferredBlock<BlueLilyBlock> BLUE_LILY = BlockInit.registerBlock("blue_lily", BlueLilyBlock::new);
    public static final DeferredBlock<BurntDeepBlock> BURNT_DEEP = BlockInit.registerBlock("burnt_deep", BurntDeepBlock::new);
    public static final DeferredBlock<AnemoneBlock> ANEMONE = BlockInit.registerBlock("anemone", AnemoneBlock::new);
    public static final BlockType ANCIENT_DARK_OAK = BlockInit.registerBlockType("ancient_dark_oak", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.DARK_OAK, WoodType.DARK_OAK, 30, true);
    public static final BlockType ANCIENT_OAK = BlockInit.registerBlockType("ancient_oak", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.OAK, WoodType.OAK, 30, true);
    public static final BlockType ANCIENT_JUNGLE = BlockInit.registerBlockType("ancient_jungle", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.JUNGLE, WoodType.JUNGLE, 30, true);
    public static final BlockType ANCIENT_ACACIA = BlockInit.registerBlockType("ancient_acacia", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.ACACIA, WoodType.ACACIA, 30, true);
    public static final BlockType ANCIENT_BIRCH = BlockInit.registerBlockType("ancient_birch", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.BIRCH, WoodType.BIRCH, 30, true);
    public static final BlockType ANCIENT_SPRUCE = BlockInit.registerBlockType("ancient_spruce", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.SPRUCE, WoodType.SPRUCE, 30, true);
    public static final BlockType ANCIENT_BAMBOO = BlockInit.registerBlockType("ancient_bamboo", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.BAMBOO, WoodType.BAMBOO, 30, true);
    public static final BlockType ANCIENT_MANGROVE = BlockInit.registerBlockType("ancient_mangrove", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.MANGROVE, WoodType.MANGROVE, 30, true);
    public static final BlockType ANCIENT_CHERRY = BlockInit.registerBlockType("ancient_cherry", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.CHERRY, WoodType.CHERRY, 30, true);
    public static final BlockType ANCIENT_CRIMSON = BlockInit.registerBlockType("ancient_crimson", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.CRIMSON, WoodType.CRIMSON, 30, true);
    public static final BlockType ANCIENT_WARPED = BlockInit.registerBlockType("ancient_warped", AncientWoodBlock::new, BlockBehaviour.Properties.of(), true, BlockSetType.WARPED, WoodType.WARPED, 30, true);
    public static final DeferredBlock<OysterShellBlock> OYSTER_SHELL_BLOCK = BlockInit.registerBlock("oyster_shell_block", () -> new OysterShellBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<NautilusShellBlock> NAUTILUS_SHELL_BLOCK = BlockInit.registerBlock("nautilus_shell_block", () -> new NautilusShellBlock(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.BONE_BLOCK)));
    public static final DeferredBlock<OysterShellBlock> CRACKED_OYSTER_SHELL = BlockInit.registerBlock("cracked_oyster_shell", () -> new OysterShellBlock(BlockBehaviour.Properties.of().strength(1.5f, 5.0f)));
    public static final DeferredBlock<NautilusShellBlock> CRACKED_NAUTILUS_SHELL = BlockInit.registerBlock("cracked_nautilus_shell", () -> new NautilusShellBlock(BlockBehaviour.Properties.of().strength(1.5f, 5.0f).requiresCorrectToolForDrops().sound(SoundType.BONE_BLOCK)));
    public static final DeferredBlock<OysterShellBlock> CRACKED_MOSSY_OYSTER_SHELL = BlockInit.registerBlock("cracked_mossy_oyster_shell", () -> new OysterShellBlock(BlockBehaviour.Properties.of().strength(1.5f, 5.0f)));
    public static final DeferredBlock<NautilusShellBlock> CRACKED_MOSSY_NAUTILUS_SHELL = BlockInit.registerBlock("cracked_mossy_nautilus_shell", () -> new NautilusShellBlock(BlockBehaviour.Properties.of().strength(1.5f, 5.0f).requiresCorrectToolForDrops().sound(SoundType.BONE_BLOCK)));
    public static final DeferredBlock<OysterShellBlock> MOSSY_OYSTER_SHELL = BlockInit.registerBlock("mossy_oyster_shell", () -> new OysterShellBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<NautilusShellBlock> MOSSY_NAUTILUS_SHELL = BlockInit.registerBlock("mossy_nautilus_shell", () -> new NautilusShellBlock(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.BONE_BLOCK)));
    public static final DeferredBlock<SodiumBombBlock> SODIUM_BOMB = BlockInit.registerBlock("sodium_bomb", () -> new SodiumBombBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<SeasaltChunkBlock> SEASALT_CHUNK = BlockInit.registerBlock("seasalt_chunk", () -> new SeasaltChunkBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> SUNKEN_GRAVEL = BlockInit.registerBlock("sunken_gravel", () -> new SunkenGravelBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<CrackedGlowstoneBlock> CRACKED_GLOWSTONE = BlockInit.registerBlock("cracked_glowstone", () -> new CrackedGlowstoneBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<DeadGlowstoneBlock> DEAD_GLOWSTONE = BlockInit.registerBlock("dead_glowstone", () -> new DeadGlowstoneBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AlgaeDetritusStoneBlock> ALGAE_DETRITUS_STONE = BlockInit.registerBlock("algae_detritus_stone", () -> new AlgaeDetritusStoneBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<DetritusSandstoneBlock> DETRITUS_SANDSTONE = BlockInit.registerBlock("detritus_sandstone", () -> new DetritusSandstoneBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<LuminescentPrismarine> LUMINESCENT_PRISMARINE = BlockInit.registerBlock("luminescent_prismarine", () -> new LuminescentPrismarine(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<BubbleMagmaBlock> BUBBLE_MAGMA = BlockInit.registerBlock("bubble_magma", () -> new BubbleMagmaBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PalmLeavesBlock> PALM_LEAVES = BlockInit.registerBlock("palm_leaves", () -> new PalmLeavesBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<NymphLeavesBlock> NYMPH_LEAVES = BlockInit.registerBlock("nymph_leaves", () -> new NymphLeavesBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> AQUAMARINE_ORE = BlockInit.registerBlock("aquamarine_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)1), BlockBehaviour.Properties.of().sound(SoundType.STONE).requiresCorrectToolForDrops().strength(3.0f, 15.0f).lightLevel(state -> 2)));
    public static final DeferredBlock<Block> DEEPSLATE_AQUAMARINE_ORE = BlockInit.registerBlock("deepslate_aquamarine_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)1), BlockBehaviour.Properties.of().sound(SoundType.STONE).requiresCorrectToolForDrops().strength(5.0f, 15.0f).lightLevel(state -> 4)));
    public static final DeferredBlock<SeabedBlock> SEABED = BlockInit.registerBlock("seabed", () -> new SeabedBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<OceanLanternBlock> OCEAN_LANTERN = BlockInit.registerBlock("ocean_lantern", () -> new OceanLanternBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<SurgeLanternBlock> SURGE_LANTERN = BlockInit.registerBlock("surge_lantern", () -> new SurgeLanternBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AtlanteanCoreBlock> ATLANTEAN_CORE = BlockInit.registerBlock("atlantean_core", () -> new AtlanteanCoreBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquamarineBlock> BLOCK_OF_AQUAMARINE = BlockInit.registerBlock("aquamarine_block", () -> new AquamarineBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquamarineBlock> CHISELED_GOLDEN_BLOCK = BlockInit.registerBlock("chiseled_golden_block", () -> new AquamarineBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquamarineBlock> CHISELED_GOLDEN_AQUAMARINE = BlockInit.registerBlock("chiseled_golden_aquamarine", () -> new AquamarineBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> BLACK_PEARL_BLOCK = BlockInit.registerBlock("black_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> BLUE_PEARL_BLOCK = BlockInit.registerBlock("blue_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> BROWN_PEARL_BLOCK = BlockInit.registerBlock("brown_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> CYAN_PEARL_BLOCK = BlockInit.registerBlock("cyan_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> GRAY_PEARL_BLOCK = BlockInit.registerBlock("gray_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> GREEN_PEARL_BLOCK = BlockInit.registerBlock("green_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> LIGHT_BLUE_PEARL_BLOCK = BlockInit.registerBlock("light_blue_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> LIGHT_GRAY_PEARL_BLOCK = BlockInit.registerBlock("light_gray_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> LIME_PEARL_BLOCK = BlockInit.registerBlock("lime_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> MAGENTA_PEARL_BLOCK = BlockInit.registerBlock("magenta_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> ORANGE_PEARL_BLOCK = BlockInit.registerBlock("orange_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> PINK_PEARL_BLOCK = BlockInit.registerBlock("pink_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> PURPLE_PEARL_BLOCK = BlockInit.registerBlock("purple_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> RED_PEARL_BLOCK = BlockInit.registerBlock("red_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> WHITE_PEARL_BLOCK = BlockInit.registerBlock("white_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PearlBlock> YELLOW_PEARL_BLOCK = BlockInit.registerBlock("yellow_pearl_block", () -> new PearlBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Seabloom> SEABLOOM = BlockInit.registerBlock("seabloom", () -> new Seabloom(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Seabloom> RED_SEABLOOM = BlockInit.registerBlock("red_seabloom", () -> new Seabloom(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PurpleSeashroom> PURPLE_SEASHROOM = BlockInit.registerBlock("purple_seashroom", () -> new PurpleSeashroom(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<YellowSeashroom> YELLOW_SEASHROOM = BlockInit.registerBlock("yellow_seashroom", () -> new YellowSeashroom(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Seabloom> YELLOW_SEABLOOM = BlockInit.registerBlock("yellow_seabloom", () -> new Seabloom(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AlgaePlantBlock> ALGAE = BlockInit.registerBlock("algae", () -> new AlgaePlantBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquaticPowerStoneBlock> AQUATIC_POWER_STONE = BlockInit.registerBlock("aquatic_power_stone", () -> new AquaticPowerStoneBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquaticPowerLampBlock> AQUATIC_POWER_LAMP = BlockInit.registerBlock("aquatic_power_lamp", () -> new AquaticPowerLampBlock(BlockBehaviour.Properties.of().strength(0.3f)));
    public static final DeferredBlock<AquaticPowerTorchBlock> AQUATIC_POWER_TORCH = BlockInit.registerOnlyBlock("aquatic_power_torch", () -> new AquaticPowerTorchBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<WallAquaticPowerTorchBlock> WALL_AQUATIC_POWER_TORCH = BlockInit.registerOnlyBlock("aquatic_power_wall_torch", () -> new WallAquaticPowerTorchBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquaticPowerDustBlock> AQUATIC_POWER_DUST_WIRE = BlockInit.registerOnlyBlock("aquatic_power_dust", () -> new AquaticPowerDustBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquaticPowerRepeaterBlock> AQUATIC_POWER_REPEATER = BlockInit.registerBlock("aquatic_power_repeater", () -> new AquaticPowerRepeaterBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AquaticPowerTripwireHook> AQUATIC_POWER_TRIPWIRE_HOOK = BlockInit.registerBlock("aquatic_power_tripwire_hook", () -> new AquaticPowerTripwireHook(BlockBehaviour.Properties.of().noCollission()));
    public static final DeferredBlock<AquaticPowerTripwireBlock> AQUATIC_POWER_TRIPWIRE = BlockInit.registerOnlyBlock("aquatic_power_tripwire", () -> new AquaticPowerTripwireBlock((AquaticPowerTripwireHook)((Object)((Object)((Object)AQUATIC_POWER_TRIPWIRE_HOOK.get()))), BlockBehaviour.Properties.of().noCollission()));
    public static final DeferredBlock<AquaticPowerLeverBlock> AQUATIC_POWER_LEVER = BlockInit.registerBlock("aquatic_power_lever", () -> new AquaticPowerLeverBlock(BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<AquaticPowerComparatorBlock> AQUATIC_POWER_COMPARATOR = BlockInit.registerBlock("aquatic_power_comparator", () -> new AquaticPowerComparatorBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<HardenedCalciteBlock> HARDENED_CALCITE_BLOCK = BlockInit.registerBlock("hardened_calcite_block", () -> new HardenedCalciteBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<PushBubbleColumnBlock> PUSH_BUBBLE_COLUMN = BlockInit.registerOnlyBlock("push_bubble_column", () -> new PushBubbleColumnBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AlgaeBlock> ALGAE_BLOCK = BlockInit.registerBlock("algae_block", () -> new AlgaeBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<ChiseledAquamarineBlock> CHISELED_AQUAMARINE_BLOCK = BlockInit.registerBlock("chiseled_aquamarine_block", () -> new ChiseledAquamarineBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> RAW_ANCIENT_CUPRUM_BLOCK = BlockInit.registerBlock("raw_ancient_cuprum_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> ANCIENT_CUPRUM_ORE = BlockInit.registerBlock("ancient_cuprum_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)5), BlockBehaviour.Properties.of().sound(SoundType.STONE).requiresCorrectToolForDrops().strength(2.0f, 15.0f).lightLevel(state -> 1)));
    public static final DeferredBlock<Block> DEEPSLATE_ANCIENT_CUPRUM_ORE = BlockInit.registerBlock("deepslate_ancient_cuprum_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)5), BlockBehaviour.Properties.of().sound(SoundType.STONE).requiresCorrectToolForDrops().strength(4.0f, 15.0f).lightLevel(state -> 3)));
    public static final DeferredBlock<Block> ORICHALCUM_BLOCK = BlockInit.registerBlock("orichalcum_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<LinguisticBlock> LINGUISTIC_TABLE = BlockInit.registerLinguisticBlock("linguistic_table", () -> new LinguisticBlock(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<WritingBlock> WRITING_TABLE = BlockInit.registerLinguisticBlock("writing_table", () -> new WritingBlock(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<NymphSaplingBlock> NYMPH_SAPLING = BlockInit.registerBlock("nymph_sapling", () -> new NymphSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<PalmSaplingBlock> PALM_SAPLING = BlockInit.registerBlock("palm_sapling", () -> new PalmSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<FireMelonSpikedFruitBlock> FIRE_MELON_FRUIT_SPIKED = BlockInit.registerOnlyBlock("fire_melon_fruit_spiked", () -> new FireMelonSpikedFruitBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<FireMelonFruitBlock> FIRE_MELON_FRUIT = BlockInit.registerOnlyBlock("fire_melon_fruit", () -> new FireMelonFruitBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops()));
    public static final DeferredBlock<FireMelonBody> FIRE_MELON_STEM = BlockInit.registerOnlyBlock("fire_melon_stem", () -> new FireMelonBody(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<FireMelonHead> FIRE_MELON_TOP = BlockInit.registerOnlyBlock("fire_melon_top", () -> new FireMelonHead(BlockBehaviour.Properties.of()));
    public static final BlockType MAGENTA_SEA_GLASS = BlockInit.registerSeaGlass("magenta");
    public static final BlockType LIGHT_GRAY_SEA_GLASS = BlockInit.registerSeaGlass("light_gray");
    public static final BlockType PINK_SEA_GLASS = BlockInit.registerSeaGlass("pink");
    public static final BlockType YELLOW_SEA_GLASS = BlockInit.registerSeaGlass("yellow");
    public static final BlockType PURPLE_SEA_GLASS = BlockInit.registerSeaGlass("purple");
    public static final BlockType SEA_GLASS = BlockInit.registerSeaGlass("");
    public static final BlockType LIGHT_BLUE_SEA_GLASS = BlockInit.registerSeaGlass("light_blue");
    public static final BlockType RED_SEA_GLASS = BlockInit.registerSeaGlass("red");
    public static final BlockType MONOCHROMATIC_SEA_GLASS = BlockInit.registerSeaGlass("monochromatic");
    public static final BlockType GREEN_SEA_GLASS = BlockInit.registerSeaGlass("green");
    public static final BlockType WHITE_SEA_GLASS = BlockInit.registerSeaGlass("white");
    public static final BlockType CYAN_SEA_GLASS = BlockInit.registerSeaGlass("cyan");
    public static final BlockType MULTICOLOR_SEA_GLASS = BlockInit.registerSeaGlass("multicolor");
    public static final BlockType ORANGE_SEA_GLASS = BlockInit.registerSeaGlass("orange");
    public static final BlockType BLACK_SEA_GLASS = BlockInit.registerSeaGlass("black");
    public static final BlockType GRAY_SEA_GLASS = BlockInit.registerSeaGlass("gray");
    public static final BlockType BLUE_SEA_GLASS = BlockInit.registerSeaGlass("blue");
    public static final BlockType BROWN_SEA_GLASS = BlockInit.registerSeaGlass("brown");
    public static final BlockType LIME_SEA_GLASS = BlockInit.registerSeaGlass("lime");
    public static final BlockType MAGENTA_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("magenta");
    public static final BlockType LIGHT_GRAY_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("light_gray");
    public static final BlockType PINK_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("pink");
    public static final BlockType YELLOW_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("yellow");
    public static final BlockType PURPLE_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("purple");
    public static final BlockType LIGHT_BLUE_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("light_blue");
    public static final BlockType RED_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("red");
    public static final BlockType GREEN_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("green");
    public static final BlockType WHITE_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("white");
    public static final BlockType CYAN_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("cyan");
    public static final BlockType ORANGE_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("orange");
    public static final BlockType BLACK_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("black");
    public static final BlockType GRAY_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("gray");
    public static final BlockType BLUE_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("blue");
    public static final BlockType BROWN_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("brown");
    public static final BlockType LIME_PATTERNED_SEA_GLASS = BlockInit.registerSeaGlassPatterned("lime");
    public static final DeferredBlock<RotatedPillarBlock> COQUINA = BlockInit.registerMainTabBlock("coquina", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().sound(SoundType.BONE_BLOCK).requiresCorrectToolForDrops().strength(3.0f, 7.0f).mapColor(MapColor.TERRACOTTA_ORANGE)), DeferredBlock2 -> () -> new BlockItem((Block)DeferredBlock2.get(), new Item.Properties()));
    public static final BlockBehaviour.Properties ANCIENT_CUPRUM_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.METAL);
    public static Map<WeatheringCuprum.WeatherState, TrailsGroup> ANCIENT_CUPRUM = (Map)Util.make(new HashMap(), map -> Arrays.stream(WeatheringCuprum.WeatherState.values()).forEach(state -> map.put(state, BlockInit.registerTrialsGroup("ancient_cuprum", state, ANCIENT_CUPRUM_PROPERTIES))));

    private static <B extends Block> DeferredBlock<B> registerBlock(String name, Supplier<B> block) {
        return BlockInit.registerMainTabBlock(name, block, b -> () -> new BlockItem((Block)b.get(), new Item.Properties()));
    }

    public static <B extends Block> DeferredBlock<B> registerLinguisticBlock(String name, Supplier<B> block) {
        return BlockInit.registerGylphTabBlock(name, block, b -> () -> new BlockItem((Block)b.get(), new Item.Properties()));
    }

    public static <B extends Block> DeferredBlock<B> registerOnlyBlock(String name, Supplier<B> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> BlockType registerBlockType(String name, Function<BlockBehaviour.Properties, Block> block, BlockBehaviour.Properties properties, boolean genDoors, BlockSetType blockSetType, @Nullable WoodType woodType, int pTicksToStayPressed, boolean pArrowsCanPress) {
        DeferredBlock<Block> blockBase = BlockInit.registerMainTabBlock(name + (woodType != null ? "_planks" : ""), () -> (Block)block.apply(properties), tDeferredBlock -> () -> new BlockItem((Block)tDeferredBlock.get(), new Item.Properties()));
        DeferredBlock<SlabBlock> blockSlab = BlockInit.registerMainTabBlock(name + "_slab", blockBase, block1 -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties()));
        DeferredBlock<WallBlock> blockWall = woodType == null ? BlockInit.registerMainTabBlock(name + "_wall", blockBase, block1 -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties())) : null;
        DeferredBlock<FenceBlock> blockFence = woodType != null ? BlockInit.registerMainTabBlock(name + "_fence", blockBase, block1 -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties())) : null;
        DeferredBlock<FenceGateBlock> blockGateBlock = woodType != null ? BlockInit.registerMainTabBlock(name + "_fence_gate", blockBase, block1 -> new FenceGateBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties())) : null;
        DeferredBlock<StairBlock> blockStairs = BlockInit.registerMainTabBlock(name + "_stairs", blockBase, block1 -> new StairBlock(block1.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties()));
        DeferredBlock<DoorBlock> blockDoor = genDoors ? BlockInit.registerMainTabBlock(name + "_door", blockBase, block1 -> new DoorBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties())) : null;
        DeferredBlock<TrapDoorBlock> blockTrapDoor = genDoors ? BlockInit.registerMainTabBlock(name + "_trapdoor", blockBase, block1 -> new TrapDoorBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties())) : null;
        DeferredBlock<ButtonBlock> blockButton = BlockInit.registerMainTabBlock(name + "_button", blockBase, block1 -> new ButtonBlock(blockSetType, pTicksToStayPressed, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties()));
        DeferredBlock<PressurePlateBlock> pressurePlate = BlockInit.registerMainTabBlock(name + "_pressure_plate", blockBase, block1 -> new PressurePlateBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block1)), block2 -> new BlockItem((Block)block2, new Item.Properties()));
        return BlockType.of(blockBase, blockSlab, blockWall, blockFence, blockGateBlock, blockStairs, blockDoor, blockTrapDoor, blockButton, pressurePlate);
    }

    private static BlockType registerSeaGlass(String name) {
        Object blockName = "";
        blockName = name.isEmpty() ? "sea_glass" : name + "_sea_glass";
        BlockType blockType = BlockInit.registerBlockType((String)blockName, HalfTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.GLASS), false, BlockSetType.IRON, null, 40, true);
        if (!(name.equals("monochromatic") || name.equals("multicolor") || name.isEmpty())) {
            BlockInit.addToSeaGlassList(name, blockType);
        }
        return blockType;
    }

    private static BlockType registerSeaGlassPatterned(String name) {
        String blockName = name + "_patterned_sea_glass";
        BlockType blockType = BlockInit.registerBlockType(blockName, HalfTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.GLASS), false, BlockSetType.IRON, null, 40, true);
        BlockInit.addToSeaGlassPatternList(name, blockType);
        return blockType;
    }

    private static void addToSeaGlassPatternList(String name, BlockType blockType) {
        SEA_GLASS_PATTERNS.put(DyeColor.valueOf((String)name.toUpperCase(Locale.ROOT)), blockType);
    }

    private static void addToSeaGlassList(String name, BlockType blockType) {
        SEA_GLASS_LIST.put(DyeColor.valueOf((String)name.toUpperCase(Locale.ROOT)), blockType);
    }

    private static <B extends Block, I extends BlockItem> DeferredBlock<B> registerMainTabBlock(String name, Supplier<B> block, Function<DeferredBlock<B>, Supplier<I>> item) {
        DeferredBlock reg = BLOCKS.register(name, block);
        AtlantisGroupInit.addToMainTab(ItemInit.ITEMS.register(name, () -> (BlockItem)((Supplier)item.apply(reg)).get()));
        return reg;
    }

    private static <B extends Block, C extends Block, I extends BlockItem> DeferredBlock<C> registerMainTabBlock(String name, Supplier<B> block, Function<B, C> blockFunction, Function<C, I> item) {
        DeferredBlock reg = BLOCKS.register(name, () -> (Block)blockFunction.apply((Block)block.get()));
        AtlantisGroupInit.addToMainTab(ItemInit.ITEMS.register(name, () -> (BlockItem)item.apply((Block)reg.get())));
        return reg;
    }

    private static <B extends Block, I extends BlockItem> DeferredBlock<B> registerGylphTabBlock(String name, Supplier<B> block, Function<DeferredBlock<B>, Supplier<I>> item) {
        DeferredBlock reg = BLOCKS.register(name, block);
        AtlantisGroupInit.addToGylphTab(ItemInit.ITEMS.register(name, () -> (BlockItem)((Supplier)item.apply(reg)).get()));
        return reg;
    }

    public static DeferredBlock<Block> getLinguisticBlock(LinguisticGlyph symbol, DyeColor color) {
        if (color != null) {
            if (symbol != null && symbol != LinguisticGlyph.BLANK) {
                return DYED_LINGUISTICS.get((Object)symbol).get(color);
            }
            return DYED_LINGUISTICS.get((Object)LinguisticGlyph.BLANK).get(color);
        }
        if (symbol != null && symbol != LinguisticGlyph.BLANK) {
            return NON_LINGUISTICS.get((Object)symbol);
        }
        return NON_LINGUISTICS.get((Object)LinguisticGlyph.BLANK);
    }

    private static TrailsGroup registerTrialsGroup(String name, WeatheringCuprum.WeatherState state, BlockBehaviour.Properties properties) {
        String prefix = state == WeatheringCuprum.WeatherState.UNAFFECTED ? "" : state.getSerializedName() + "_";
        DeferredBlock<WeatheringCuprumFullBlock> block = BlockInit.registerBlock(prefix + name + "_block", () -> new WeatheringCuprumFullBlock(state, properties));
        DeferredBlock<WeatheringCuprumFullBlock> cut = BlockInit.registerBlock(prefix + "cut_" + name, () -> new WeatheringCuprumFullBlock(state, properties));
        DeferredBlock<WeatheringCuprumFullBlock> chiseled = BlockInit.registerBlock(prefix + "chiseled_" + name, () -> new WeatheringCuprumFullBlock(state, properties));
        DeferredBlock<WeatheringCuprumStairsBlock> cut_stairs = BlockInit.registerBlock(prefix + "cut_" + name + "_stairs", () -> new WeatheringCuprumStairsBlock(state, ((WeatheringCuprumFullBlock)cut.get()).defaultBlockState(), properties));
        DeferredBlock<WeatheringCuprumSlabBlock> cut_slab = BlockInit.registerBlock(prefix + "cut_" + name + "_slab", () -> new WeatheringCuprumSlabBlock(state, properties));
        DeferredBlock<WeatheringCuprumDoorBlock> door = BlockInit.registerBlock(prefix + name + "_door", () -> new WeatheringCuprumDoorBlock(BlockSetType.IRON, state, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).noOcclusion().pushReaction(PushReaction.DESTROY)));
        DeferredBlock<WeatheringCuprumTrapdoorBlock> trapdoor = BlockInit.registerBlock(prefix + name + "_trapdoor", () -> new WeatheringCuprumTrapdoorBlock(state, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> false)));
        DeferredBlock<WeatheringCuprumGrateBlock> grate = BlockInit.registerBlock(prefix + name + "_grate", () -> new WeatheringCuprumGrateBlock(state, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> false).isRedstoneConductor((pState, pLevel, pPos) -> false).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false)));
        DeferredBlock<WeatheringCuprumBulbBlock> bulb = BlockInit.registerBlock(prefix + name + "_bulb", () -> new WeatheringCuprumBulbBlock(state, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).sound(SoundType.GLASS).isRedstoneConductor((pState, pLevel, pPos) -> false).lightLevel(value -> (Boolean)value.getValue((Property)WeatheringCuprumBulbBlock.LIT) != false ? state.lightLevel() : 0)));
        DeferredBlock<Block> waxed_block = BlockInit.registerBlock("waxed_" + prefix + name + "_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get()))));
        DeferredBlock<Block> waxed_cut = BlockInit.registerBlock("waxed_" + prefix + "cut_" + name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)cut.get()))));
        DeferredBlock<Block> waxed_chiseled = BlockInit.registerBlock("waxed_" + prefix + "chiseled_" + name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)chiseled.get()))));
        DeferredBlock<StairBlock> waxed_cut_stairs = BlockInit.registerBlock("waxed_" + prefix + "cut_" + name + "_stairs", () -> new StairBlock(((WeatheringCuprumFullBlock)cut.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)cut_stairs.get()))));
        DeferredBlock<SlabBlock> waxed_cut_slab = BlockInit.registerBlock("waxed_" + prefix + "cut_" + name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)cut_slab.get()))));
        DeferredBlock<DoorBlock> waxed_door = BlockInit.registerBlock("waxed_" + prefix + name + "_door", () -> new DoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)door.get())).noOcclusion().pushReaction(PushReaction.DESTROY)));
        DeferredBlock<TrapDoorBlock> waxed_trapdoor = BlockInit.registerBlock("waxed_" + prefix + name + "_trapdoor", () -> new TrapDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)trapdoor.get())).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> false)));
        DeferredBlock<Block> waxed_grate = BlockInit.registerBlock("waxed_" + prefix + name + "_grate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)grate.get())).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> false).isRedstoneConductor((pState, pLevel, pPos) -> false).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false)));
        DeferredBlock<CuprumBulbBlock> waxed_bulb = BlockInit.registerBlock("waxed_" + prefix + name + "_bulb", () -> new CuprumBulbBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)bulb.get())).sound(SoundType.GLASS).isRedstoneConductor((pState, pLevel, pPos) -> false).lightLevel(value -> (Boolean)value.getValue((Property)CuprumBulbBlock.LIT) != false ? state.lightLevel() : 0)));
        return new TrailsGroup(block, cut, chiseled, cut_stairs, cut_slab, door, trapdoor, grate, bulb, waxed_block, waxed_cut, waxed_chiseled, waxed_cut_stairs, waxed_cut_slab, waxed_door, waxed_trapdoor, waxed_grate, waxed_bulb);
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
    }

    static {
        Function<DyeColor, Supplier> blockSupplier = (glyph, dyeColor) -> () -> new GlyphBlock((LinguisticGlyph)((Object)((Object)glyph)), (DyeColor)dyeColor, BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.5f, 6.0f));
        for (LinguisticGlyph linguisticGlyph : LinguisticGlyph.values()) {
            String name = "linguistic_glyph" + linguisticGlyph.toString();
            for (DyeColor color : DyeColor.values()) {
                DYED_LINGUISTICS.computeIfAbsent(linguisticGlyph, c -> new HashMap()).put(color, BlockInit.registerLinguisticBlock(color.getSerializedName() + "_" + name, (Supplier)blockSupplier.apply((DyeColor)linguisticGlyph, color)));
            }
            NON_LINGUISTICS.put(linguisticGlyph, BlockInit.registerLinguisticBlock(name, (Supplier)blockSupplier.apply((DyeColor)linguisticGlyph, null)));
        }
        blockSupplier = dyeColor -> () -> new ColoredShellBlock(BlockBehaviour.Properties.of());
        for (LinguisticGlyph linguisticGlyph : DyeColor.values()) {
            COLORED_SHELL_BLOCKS.put((DyeColor)linguisticGlyph, BlockInit.registerBlock(linguisticGlyph.getSerializedName() + "_shell_block", blockSupplier.apply((DyeColor)linguisticGlyph)));
        }
        blockSupplier = dyeColor -> () -> new CrackedShellBlock(BlockBehaviour.Properties.of());
        for (LinguisticGlyph linguisticGlyph : DyeColor.values()) {
            CRACKED_SHELL_BLOCKS.put((DyeColor)linguisticGlyph, BlockInit.registerBlock("cracked_" + linguisticGlyph.getSerializedName() + "_shell", blockSupplier.apply((DyeColor)linguisticGlyph)));
        }
        blockSupplier = dyeColor -> () -> new CrackedShellBlock(BlockBehaviour.Properties.of());
        for (LinguisticGlyph linguisticGlyph : DyeColor.values()) {
            CRACKED_MOSSY_SHELL_BLOCKS.put((DyeColor)linguisticGlyph, BlockInit.registerBlock("cracked_mossy_" + linguisticGlyph.getSerializedName() + "_shell", blockSupplier.apply((DyeColor)linguisticGlyph)));
        }
        blockSupplier = dyeColor -> () -> new CrackedShellBlock(BlockBehaviour.Properties.of());
        for (LinguisticGlyph linguisticGlyph : DyeColor.values()) {
            MOSSY_SHELL_BLOCKS.put((DyeColor)linguisticGlyph, BlockInit.registerBlock("mossy_" + linguisticGlyph.getSerializedName() + "_shell", blockSupplier.apply((DyeColor)linguisticGlyph)));
        }
    }
}

