/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.blocks.base.FireMelonSpikedFruitBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireMelonBody
extends GrowingPlantBodyBlock
implements LiquidBlockContainer {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape BLOCK = Shapes.block();

    public FireMelonBody(BlockBehaviour.Properties arg) {
        super(arg.noCollission().noOcclusion().randomTicks(), Direction.UP, BLOCK, true);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        int f;
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos blockpos = blockPos.relative(direction);
        if (level.getBlockState(blockpos.offset(direction.getOpposite().getNormal().multiply(2))) == Blocks.WATER.defaultBlockState() && level.isAreaLoaded(blockPos, 1) && CommonHooks.canCropGrow((Level)level, (BlockPos)blockPos, (BlockState)blockState, (random.nextInt((int)(5.0f / (float)(f = CropBlock.getId((BlockState)this.defaultBlockState()))) + 1) == 5 || random.nextInt((int)(5.0f / (float)f) + 1) == 0 ? 1 : 0) != 0)) {
            if (level.isFluidAtPosition(blockpos, fluidState -> fluidState.is((Fluid)Fluids.WATER))) {
                level.setBlockAndUpdate(blockpos.offset(direction.getOpposite().getNormal().multiply(2)), (BlockState)((FireMelonSpikedFruitBlock)((Object)BlockInit.FIRE_MELON_FRUIT_SPIKED.get())).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> arg) {
        arg.add(new Property[]{AGE, Seabloom.WATERLOGGED});
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BlockInit.FIRE_MELON_TOP.get();
    }

    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return FireMelonBody.simpleCodec(FireMelonBody::new);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ItemInit.FIRE_MELON_SEEDS.get());
    }

    public FluidState getFluidState(BlockState arg) {
        return Fluids.WATER.getSource(false);
    }

    public boolean canAttachTo(@NotNull BlockState arg) {
        return this.getHeadBlock().canAttachTo(arg);
    }

    public boolean canPlaceLiquid(@Nullable Player pPlayer, BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor arg, BlockPos arg2, BlockState arg3, FluidState arg4) {
        return false;
    }
}

