/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mojang.serialization.MapCodec;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireMelonHead
extends GrowingPlantHeadBlock
implements LiquidBlockContainer {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final double GROW_PER_TICK_PROBABILITY = 0.14;

    protected FireMelonHead(BlockBehaviour.Properties arg) {
        super(arg.noCollission().noOcclusion().randomTicks(), Direction.UP, SHAPE, true, 0.14);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(7)));
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return FireMelonHead.simpleCodec(FireMelonHead::new);
    }

    public void randomTick(BlockState arg, ServerLevel arg2, BlockPos arg3, RandomSource random) {
        BlockPos blockpos;
        if ((Integer)arg.getValue((Property)AGE) < 8 && CommonHooks.canCropGrow((Level)arg2, (BlockPos)arg3.relative(this.growthDirection), (BlockState)arg2.getBlockState(arg3.relative(this.growthDirection)), (random.nextDouble() < 0.14 ? 1 : 0) != 0) && this.canGrowInto(arg2.getBlockState(blockpos = arg3.relative(this.growthDirection)))) {
            arg2.setBlockAndUpdate(blockpos, this.getGrowIntoState(arg, arg2.random));
            CommonHooks.fireCropGrowPost((Level)arg2, (BlockPos)blockpos, (BlockState)arg2.getBlockState(blockpos));
        }
    }

    @NotNull
    public BlockState getMaxAgeState(BlockState arg) {
        return (BlockState)arg.setValue((Property)AGE, (Comparable)Integer.valueOf(7));
    }

    public boolean isMaxAge(BlockState arg) {
        return (Integer)arg.getValue((Property)AGE) == 7;
    }

    protected boolean canGrowInto(BlockState arg) {
        return arg.is(Blocks.WATER);
    }

    protected Block getBodyBlock() {
        return (Block)BlockInit.FIRE_MELON_STEM.get();
    }

    public boolean canAttachTo(BlockState arg) {
        return !arg.is(Blocks.MAGMA_BLOCK);
    }

    public boolean canPlaceLiquid(@Nullable Player pPlayer, BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor arg, BlockPos arg2, BlockState arg3, FluidState arg4) {
        return false;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext arg) {
        FluidState fluidState = arg.getLevel().getFluidState(arg.getClickedPos());
        return fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8 ? super.getStateForPlacement(arg) : null;
    }

    public FluidState getFluidState(BlockState arg) {
        return Fluids.WATER.getSource(false);
    }
}

