/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.JukeboxSongsInit;
import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.ToolInit;
import com.mystic.atlantis.items.AtlanteanCrystal;
import com.mystic.atlantis.items.DefaultItem;
import com.mystic.atlantis.items.LinguisticGlyphScrollItem;
import com.mystic.atlantis.items.NymphBoatItem;
import com.mystic.atlantis.items.OrbOfAtlantis;
import com.mystic.atlantis.items.OrichalcumSmithingTemplateItem;
import com.mystic.atlantis.items.PalmBoatItem;
import com.mystic.atlantis.items.SodiumItem;
import com.mystic.atlantis.items.SubmarineItem;
import com.mystic.atlantis.items.armor.AtlantisArmorSet;
import com.mystic.atlantis.items.armor.BasicArmorMaterial;
import com.mystic.atlantis.items.food.CoconutSliceItem;
import com.mystic.atlantis.items.food.CrabLegsItem;
import com.mystic.atlantis.items.food.FireMelonJellyBottle;
import com.mystic.atlantis.items.food.JellyfishJellyBottle;
import com.mystic.atlantis.items.food.WaterPill;
import com.mystic.atlantis.items.tools.AquamarineHammer;
import com.mystic.atlantis.items.tools.AtlanteanAmulet;
import com.mystic.atlantis.items.tools.AtlanteanAxe;
import com.mystic.atlantis.items.tools.AtlanteanHoe;
import com.mystic.atlantis.items.tools.AtlanteanPickaxe;
import com.mystic.atlantis.items.tools.AtlanteanShovel;
import com.mystic.atlantis.items.tools.AtlanteanSpear;
import com.mystic.atlantis.items.tools.AtlanteanSword;
import com.mystic.atlantis.items.tools.OrichalcumHammer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemInit {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"atlantis");
    private static final Map<LinguisticGlyph, DeferredItem<Item>> scrolls = new HashMap<LinguisticGlyph, DeferredItem<Item>>();
    private static final Item.Properties ATLANTIS_SETTINGS = new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON);
    public static final DeferredItem<Item> ATLANTEAN_AMULET = ItemInit.register("atlantean_amulet", () -> new AtlanteanAmulet(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> ATLANTEAN_SPEAR = ItemInit.register("atlantean_spear", () -> new AtlanteanSpear(ToolInit.AQUAMARINE, new Item.Properties()));
    public static final DeferredItem<Item> NYMPH_BOAT = ItemInit.register("nymph_boat", () -> new NymphBoatItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> PALM_BOAT = ItemInit.register("palm_boat", () -> new PalmBoatItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> RUBYCLAW_CRAB_EGG = ItemInit.register("rubyclaw_crab_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.RUBYCLAW_CRAB, 0x800002, 16715589, new Item.Properties()));
    public static final DeferredItem<Item> AQUAIEL_JELLYFISH_EGG = ItemInit.register("aquaiel_jellyfish_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.AQUAIEL_JELLYFISH, 17802, 361215, new Item.Properties()));
    public static final DeferredItem<Item> GLITTERTAIL_SHRIMP_EGG = ItemInit.register("glittertail_shrimp_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.GLITTERTAIL_SHRIMP, 0xFF0000, 0xFF8000, new Item.Properties()));
    public static final DeferredItem<Item> LEVIATHAN_EGG = ItemInit.register("leviathan_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.LEVIATHAN, 0x1DDDDD, 11394779, new Item.Properties()));
    public static final DeferredItem<Item> THALASSIAN_SEAHORSE_EGG = ItemInit.register("thalassian_seahorse_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.THALASSIAN_SEAHORSE, 16182078, 13617243, new Item.Properties()));
    public static final DeferredItem<Item> COCONUT_CRAB_EGG = ItemInit.register("coconut_crab_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.COCONUT_CRAB, 0x800002, 16715589, new Item.Properties()));
    public static final DeferredItem<Item> STARFISH_EGG = ItemInit.register("starfish_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.STARFISH, 16753693, 16179807, new Item.Properties()));
    public static final DeferredItem<Item> ZOMBIE_STARFISH_EGG = ItemInit.register("zombie_starfish_egg", () -> new DeferredSpawnEggItem(AtlantisEntityInit.ZOMBIE_STARFISH, 16646390, 41328, new Item.Properties()));
    public static final DeferredItem<Item> PANBEE = ItemInit.register("panbee", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).jukeboxPlayable(JukeboxSongsInit.PANBEE)));
    public static final DeferredItem<Item> COLUMN_CAVITATION = ItemInit.register("column_cavitation", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).jukeboxPlayable(JukeboxSongsInit.COLUMN)));
    public static final DeferredItem<Item> ANCIENT_CUPRUM_INGOT = ItemInit.register("ancient_cuprum_ingot", DefaultItem::new);
    public static final DeferredItem<Item> RAW_ANCIENT_CUPRUM = ItemInit.register("raw_ancient_cuprum", DefaultItem::new);
    public static final DeferredItem<Item> BROKEN_SHELLS = ItemInit.register("broken_shells", DefaultItem::new);
    public static final DeferredItem<Item> SODIUM_NUGGET = ItemInit.register("sodium_nugget", () -> new SodiumItem(new Item.Properties()));
    public static final DeferredItem<Item> SEASALT = ItemInit.register("seasalt", DefaultItem::new);
    public static final DeferredItem<Item> FIRE_MELON_JELLY_BOTTLE = ItemInit.register("fire_melon_jelly_bottle", () -> new FireMelonJellyBottle(new Item.Properties()));
    public static final DeferredItem<Item> JELLY_BOTTLE = ItemInit.register("jellyfish_jelly_bottle", () -> new JellyfishJellyBottle(new Item.Properties()));
    public static final DeferredItem<Item> AQUAMARINE_GEM = ItemInit.register("aquamarine_gem", DefaultItem::new);
    public static final DeferredItem<Item> ORICHALCUM_INGOT = ItemInit.register("orichalcum_ingot", DefaultItem::new);
    public static final DeferredItem<Item> ORICHALCUM_BLEND = ItemInit.register("orichalcum_blend", DefaultItem::new);
    public static final DeferredItem<Item> ORB_OF_ATLANTIS = ItemInit.register("orb_of_atlantis", OrbOfAtlantis::new);
    public static final DeferredItem<Item> ATLANTEAN_CRYSTAL = ItemInit.register("atlantean_crystal", AtlanteanCrystal::new);
    public static final DeferredItem<Item> OCEAN_STONE = ItemInit.register("ocean_stone", DefaultItem::new);
    public static final DeferredItem<Item> DROP_OF_ATLANTIS = ItemInit.register("drop_of_atlantis", DefaultItem::new);
    public static final DeferredItem<Item> BROWN_WROUGHT_PATCHES = ItemInit.register("brown_wrought_patches", DefaultItem::new);
    public static final DeferredItem<Item> CRAB_LEGS = ItemInit.register("crab_legs", () -> new CrabLegsItem(new Item.Properties()));
    public static final DeferredItem<Item> SHRIMP = ItemInit.register("shrimp", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.2f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 100), 0.05f).build())));
    public static final DeferredItem<Item> COOKED_SHRIMP = ItemInit.register("cooked_shrimp", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).build())));
    public static final DeferredItem<Item> AQUATIC_POWER_TORCH = ItemInit.register("aquatic_power_torch", () -> new StandingAndWallBlockItem((Block)BlockInit.AQUATIC_POWER_TORCH.get(), (Block)BlockInit.WALL_AQUATIC_POWER_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final DeferredItem<Item> AQUATIC_POWER_DUST = ItemInit.register("aquatic_power_dust", () -> new ItemNameBlockItem((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get(), new Item.Properties()));
    public static final DeferredItem<Item> AQUAIEL_STRING = ItemInit.register("aquaiel_string", () -> new ItemNameBlockItem((Block)BlockInit.AQUATIC_POWER_TRIPWIRE.get(), new Item.Properties()));
    public static final DeferredItem<Item> SUBMARINE = ItemInit.register("submarine", () -> new SubmarineItem(new Item.Properties()));
    public static final DeferredItem<Item> WATER_PILL = ItemInit.register("water_pill", WaterPill::new);
    public static final DeferredItem<Item> NYMPH_SIGN = ItemInit.register("nymph_sign", () -> new SignItem(new Item.Properties(), (Block)BlockInit.NYMPH_SIGN.get(), (Block)BlockInit.NYMPH_WALL_SIGN.get()));
    public static final DeferredItem<Item> PALM_SIGN = ItemInit.register("palm_sign", () -> new SignItem(new Item.Properties(), (Block)BlockInit.PALM_SIGN.get(), (Block)BlockInit.PALM_WALL_SIGN.get()));
    public static final DeferredItem<Item> FIRE_MELON_FRUIT = ItemInit.register("fire_melon_fruit", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f).build())));
    public static final DeferredItem<Item> FIRE_MELON_FRUIT_SPIKED = ItemInit.register("fire_melon_fruit_spiked", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f).effect(() -> new MobEffectInstance(MobEffects.HARM, 60), 1.0f).build())));
    public static final DeferredItem<Item> FIRE_MELON_SEEDS = ItemInit.register("fire_melon_fruit_seeds", () -> new ItemNameBlockItem((Block)BlockInit.FIRE_MELON_TOP.get(), new Item.Properties()));
    public static final DeferredItem<Item> FIRE_MELON_SPIKE = ItemInit.register("fire_melon_spike", DefaultItem::new);
    public static final DeferredItem<Item> COCONUT_SLICE = ItemInit.register("coconut_slice", () -> new CoconutSliceItem(new Item.Properties()));
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL = ItemInit.registerGlyph(LinguisticGlyph.BLANK);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_A = ItemInit.registerGlyph(LinguisticGlyph.A);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_B = ItemInit.registerGlyph(LinguisticGlyph.B);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_C = ItemInit.registerGlyph(LinguisticGlyph.C);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_D = ItemInit.registerGlyph(LinguisticGlyph.D);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_E = ItemInit.registerGlyph(LinguisticGlyph.E);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_F = ItemInit.registerGlyph(LinguisticGlyph.F);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_G = ItemInit.registerGlyph(LinguisticGlyph.G);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_H = ItemInit.registerGlyph(LinguisticGlyph.H);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_I = ItemInit.registerGlyph(LinguisticGlyph.I);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_J = ItemInit.registerGlyph(LinguisticGlyph.J);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_K = ItemInit.registerGlyph(LinguisticGlyph.K);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_L = ItemInit.registerGlyph(LinguisticGlyph.L);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_M = ItemInit.registerGlyph(LinguisticGlyph.M);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_N = ItemInit.registerGlyph(LinguisticGlyph.N);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_O = ItemInit.registerGlyph(LinguisticGlyph.O);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_P = ItemInit.registerGlyph(LinguisticGlyph.P);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_Q = ItemInit.registerGlyph(LinguisticGlyph.Q);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_R = ItemInit.registerGlyph(LinguisticGlyph.R);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_S = ItemInit.registerGlyph(LinguisticGlyph.S);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_T = ItemInit.registerGlyph(LinguisticGlyph.T);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_U = ItemInit.registerGlyph(LinguisticGlyph.U);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_V = ItemInit.registerGlyph(LinguisticGlyph.V);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_W = ItemInit.registerGlyph(LinguisticGlyph.W);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_X = ItemInit.registerGlyph(LinguisticGlyph.X);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_Y = ItemInit.registerGlyph(LinguisticGlyph.Y);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_Z = ItemInit.registerGlyph(LinguisticGlyph.Z);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_0 = ItemInit.registerGlyph(LinguisticGlyph.ZERO);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_1 = ItemInit.registerGlyph(LinguisticGlyph.ONE);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_2 = ItemInit.registerGlyph(LinguisticGlyph.TWO);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_3 = ItemInit.registerGlyph(LinguisticGlyph.THREE);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_4 = ItemInit.registerGlyph(LinguisticGlyph.FOUR);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_5 = ItemInit.registerGlyph(LinguisticGlyph.FIVE);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_6 = ItemInit.registerGlyph(LinguisticGlyph.SIX);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_7 = ItemInit.registerGlyph(LinguisticGlyph.SEVEN);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_8 = ItemInit.registerGlyph(LinguisticGlyph.EIGHT);
    public static final DeferredItem<Item> LINGUISTIC_GLYPH_SCROLL_9 = ItemInit.registerGlyph(LinguisticGlyph.NINE);
    public static final DeferredItem<Item> JETSTREAM_WATER_BUCKET = ITEMS.register("jetstream_water_bucket", () -> new BucketItem((Fluid)FluidInit.JETSTREAM_WATER.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final DeferredItem<Item> SALTY_SEAWATER_BUCKET = ITEMS.register("salty_seawater_bucket", () -> new BucketItem((Fluid)FluidInit.SALTY_SEAWATER.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final DeferredItem<Item> RUBYCLAW_CRAB_BUCKET = ItemInit.registerBucket(AtlantisEntityInit.RUBYCLAW_CRAB);
    public static final DeferredItem<Item> AQUAIEL_JELLYFISH_BUCKET = ItemInit.registerBucket(AtlantisEntityInit.AQUAIEL_JELLYFISH);
    public static final DeferredItem<Item> GLITTERTAIL_SHRIMP_BUCKET = ItemInit.registerBucket(AtlantisEntityInit.GLITTERTAIL_SHRIMP);
    public static final DeferredItem<Item> THALASSIAN_SEAHORSE_BUCKET = ItemInit.registerBucket(AtlantisEntityInit.THALASSIAN_SEAHORSE);
    public static final DeferredItem<Item> AQUAMARINE_AXE = ItemInit.register("aquamarine_axe", () -> new AtlanteanAxe(ToolInit.AQUAMARINE, 3));
    public static final DeferredItem<Item> AQUAMARINE_PICKAXE = ItemInit.register("aquamarine_pickaxe", () -> new AtlanteanPickaxe(ToolInit.AQUAMARINE, 2));
    public static final DeferredItem<Item> AQUAMARINE_SHOVEL = ItemInit.register("aquamarine_shovel", () -> new AtlanteanShovel(ToolInit.AQUAMARINE, 1));
    public static final DeferredItem<Item> AQUAMARINE_HOE = ItemInit.register("aquamarine_hoe", () -> new AtlanteanHoe(ToolInit.AQUAMARINE, 2));
    public static final DeferredItem<Item> AQUAMARINE_SWORD = ItemInit.register("aquamarine_sword", () -> new AtlanteanSword(ToolInit.AQUAMARINE, 4));
    public static final DeferredItem<Item> AQUAMARINE_HAMMER = ItemInit.register("aquamarine_hammer", AquamarineHammer::new);
    public static final DeferredItem<Item> ORICHALCUM_AXE = ItemInit.register("orichalcum_axe", () -> new AtlanteanAxe(ToolInit.ORICHALCUM, 3));
    public static final DeferredItem<Item> ORICHALCUM_PICKAXE = ItemInit.register("orichalcum_pickaxe", () -> new AtlanteanPickaxe(ToolInit.ORICHALCUM, 2));
    public static final DeferredItem<Item> ORICHALCUM_SHOVEL = ItemInit.register("orichalcum_shovel", () -> new AtlanteanShovel(ToolInit.ORICHALCUM, 1));
    public static final DeferredItem<Item> ORICHALCUM_HOE = ItemInit.register("orichalcum_hoe", () -> new AtlanteanHoe(ToolInit.ORICHALCUM, 2));
    public static final DeferredItem<Item> ORICHALCUM_SWORD = ItemInit.register("orichalcum_sword", () -> new AtlanteanSword(ToolInit.ORICHALCUM, 4));
    public static final DeferredItem<Item> ORICHALCUM_HAMMER = ItemInit.register("orichalcum_hammer", OrichalcumHammer::new);
    public static final AtlantisArmorSet AQUAMARINE = AtlantisArmorSet.create(ITEMS, "aquamarine", BasicArmorMaterial.ARMOR_AQUAMARINE, (Holder<MobEffect>)MobEffects.DIG_SPEED);
    public static final AtlantisArmorSet BROWN_WROUGHT = AtlantisArmorSet.create(ITEMS, "brown_wrought", BasicArmorMaterial.ARMOR_BROWN_WROUGHT, (Holder<MobEffect>)MobEffects.INVISIBILITY);
    public static final AtlantisArmorSet ORICHALCUM = AtlantisArmorSet.create(ITEMS, "orichalcum", BasicArmorMaterial.ARMOR_ORICHALCUM, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE);
    public static final DeferredItem<Item> ORICHALCUM_UPGRADE_SMITHING_TEMPLATE = ItemInit.register("orichalcum_upgrade_smithing_template", OrichalcumSmithingTemplateItem::new);

    private static <T extends Entity> DeferredItem<Item> registerBucket(DeferredHolder<EntityType<?>, EntityType<T>> type) {
        return ITEMS.register(type.getId().getPath().toLowerCase(Locale.ROOT) + "_bucket", () -> new MobBucketItem((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1)));
    }

    public static <T extends Item> DeferredItem<T> register(String name, Supplier<T> item) {
        DeferredItem register = ITEMS.register(name, item);
        AtlantisGroupInit.addToMainTabItems(register);
        return register;
    }

    public static <T extends Item> DeferredItem<T> registerToGlyph(String name, Supplier<T> item) {
        DeferredItem register = ITEMS.register(name, item);
        AtlantisGroupInit.addToGylphTabItems(register);
        return register;
    }

    static DeferredItem<Item> registerGlyph(LinguisticGlyph symbol) {
        DeferredItem<Item> DeferredItem2 = ItemInit.registerToGlyph("linguistic_glyph_scroll" + symbol.toString(), () -> new LinguisticGlyphScrollItem(symbol));
        scrolls.put(symbol, DeferredItem2);
        return DeferredItem2;
    }

    public static List<Item> getScrolls() {
        return scrolls.values().stream().map(Supplier::get).toList();
    }

    public static DeferredItem<Item> getScroll(LinguisticGlyph a) {
        return scrolls.get((Object)a);
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

