/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.util.Lazy;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum ToolInit implements Tier
{
    AQUAMARINE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 286, 5.0f, 4.0f, 2, 10, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.AQUAMARINE_GEM.get()})),
    ORICHALCUM((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 500, 7.0f, 5.0f, 4, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.ORICHALCUM_INGOT.get()}));

    private final TagKey<Block> incorrectTag;
    private final int maxUses;
    private final float toolEfficiency;
    private final float attackDamage;
    private final int harvestLvl;
    private final int enchantability;
    private final Lazy<Ingredient> repairMaterial;

    private ToolInit(TagKey<Block> incorrectTag, int uses, float efficiency, float damage, int harvest, int enchant, Supplier<Ingredient> material) {
        this.incorrectTag = incorrectTag;
        this.maxUses = uses;
        this.toolEfficiency = efficiency;
        this.attackDamage = damage;
        this.harvestLvl = harvest;
        this.enchantability = enchant;
        this.repairMaterial = new Lazy<Ingredient>(material);
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.toolEfficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectTag;
    }

    public int getHarvestLvl() {
        return this.harvestLvl;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairMaterial.get();
    }

    public static void init() {
    }
}

