/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.inventory;

import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.GlyphBlock;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.items.LinguisticGlyphScrollItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LinguisticMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private Runnable slotUpdateListener = () -> {};
    private final Slot blankSlot;
    private final Slot dyeSlot;
    private final Slot symbolSlot;
    private final Slot resultSlot;
    private long lastSoundTime;
    private final Container inputContainer = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            LinguisticMenu.this.slotsChanged((Container)this);
            LinguisticMenu.this.slotUpdateListener.run();
        }
    };
    private final Container outputContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            LinguisticMenu.this.slotUpdateListener.run();
        }
    };

    public LinguisticMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.NULL);
    }

    public LinguisticMenu(int id, Inventory inventory, ContainerLevelAccess accessLevel) {
        super((MenuType)MenuTypeInit.LINGUISTIC.get(), id);
        int j;
        this.access = accessLevel;
        this.blankSlot = this.addSlot(new Slot(this, this.inputContainer, 0, 28, 28){

            public boolean mayPlace(ItemStack arg) {
                BlockItem blockItem;
                Item item = arg.getItem();
                return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof GlyphBlock;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this, this.inputContainer, 1, 48, 28){

            public boolean mayPlace(ItemStack arg) {
                return arg.getItem() instanceof DyeItem;
            }
        });
        this.symbolSlot = this.addSlot(new Slot(this, this.inputContainer, 2, 38, 48){

            public boolean mayPlace(ItemStack arg) {
                return arg.getItem() instanceof LinguisticGlyphScrollItem;
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 122, 38){

            public boolean mayPlace(ItemStack arg) {
                return false;
            }

            public void onTake(Player arg, ItemStack arg2) {
                LinguisticMenu.this.blankSlot.remove(1);
                LinguisticMenu.this.dyeSlot.remove(1);
                LinguisticMenu.this.symbolSlot.remove(1);
                LinguisticMenu.this.access.execute((argx, arg2xxx) -> {
                    long l = argx.getGameTime();
                    if (LinguisticMenu.this.lastSoundTime != l) {
                        argx.playSound(null, arg2xxx, SoundEvents.UI_LOOM_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        LinguisticMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(arg, arg2);
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + j * 9 + 9, 12 + k * 18, 88 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 12 + j * 18, 146));
        }
    }

    public boolean stillValid(Player usingPlayer) {
        return LinguisticMenu.stillValid((ContainerLevelAccess)this.access, (Player)usingPlayer, (Block)((Block)BlockInit.LINGUISTIC_TABLE.get()));
    }

    public void slotsChanged(Container curContainer) {
        ItemStack blankStack = this.blankSlot.getItem();
        ItemStack dyetack = this.dyeSlot.getItem();
        ItemStack systemStack = this.symbolSlot.getItem();
        ItemStack resultStack = this.resultSlot.getItem();
        if (!resultStack.isEmpty() && (blankStack.isEmpty() || dyetack.isEmpty()) && systemStack.isEmpty()) {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.setupResultSlot();
        this.broadcastChanges();
    }

    public void registerUpdateListener(Runnable updateListener) {
        this.slotUpdateListener = updateListener;
    }

    public ItemStack quickMoveStack(Player usingPlayer, int index) {
        ItemStack emptyStack = ItemStack.EMPTY;
        Slot targetSlot = (Slot)this.slots.get(index);
        if (targetSlot != null && targetSlot.hasItem()) {
            ItemStack targetStack = targetSlot.getItem();
            emptyStack = targetStack.copy();
            if (index == this.resultSlot.index) {
                if (!this.moveItemStackTo(targetStack, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                targetSlot.onQuickCraft(targetStack, emptyStack);
            } else if (index != this.dyeSlot.index && index != this.blankSlot.index && index != this.symbolSlot.index ? (BlockInit.getLinguisticBlock(LinguisticGlyph.BLANK, null).asOptional().map(Block::asItem).filter(a -> a == targetStack.getItem()).isPresent() ? !this.moveItemStackTo(targetStack, this.blankSlot.index, this.blankSlot.index + 1, false) : (targetStack.getItem() instanceof DyeItem ? !this.moveItemStackTo(targetStack, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (targetStack.getItem() instanceof LinguisticGlyphScrollItem ? !this.moveItemStackTo(targetStack, this.symbolSlot.index, this.symbolSlot.index + 1, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(targetStack, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(targetStack, 4, 31, false))))) : !this.moveItemStackTo(targetStack, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (targetStack.isEmpty()) {
                targetSlot.set(ItemStack.EMPTY);
            } else {
                targetSlot.setChanged();
            }
            if (targetStack.getCount() == emptyStack.getCount()) {
                return ItemStack.EMPTY;
            }
            targetSlot.onTake(usingPlayer, targetStack);
        }
        return emptyStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((arg2, arg3) -> this.clearContainer(player, this.inputContainer));
    }

    private void setupResultSlot() {
        DyeColor curDyeColor = this.dyeSlot.hasItem() ? ((DyeItem)this.dyeSlot.getItem().getItem()).getDyeColor() : null;
        LinguisticGlyph curSymbol = this.symbolSlot.hasItem() ? ((LinguisticGlyphScrollItem)this.symbolSlot.getItem().getItem()).getSymbol() : LinguisticGlyph.BLANK;
        ItemStack result = ItemStack.EMPTY;
        if (this.blankSlot.hasItem()) {
            result = new ItemStack((ItemLike)BlockInit.getLinguisticBlock(curSymbol, curDyeColor).get());
        }
        if (!ItemStack.matches((ItemStack)result, (ItemStack)this.resultSlot.getItem())) {
            this.resultSlot.set(result);
        }
    }

    public Slot getBlankSlot() {
        return this.blankSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getSymbolSlot() {
        return this.symbolSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

