/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items;

import com.mystic.atlantis.entities.PalmBoatEntity;
import com.mystic.atlantis.init.AtlantisEntityInit;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PalmBoatItem
extends Item {
    private static final Predicate<Entity> RIDERS = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);

    public PalmBoatItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = PalmBoatItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        BlockHitResult blockHitResult = hitResult;
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!(world.getBlockState(blockPos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (world.mayInteract(user, blockPos) && user.mayUseItemAt(blockPos, blockHitResult.getDirection(), itemStack)) {
            PalmBoatEntity boatEntity = new PalmBoatEntity((EntityType<? extends Boat>)((EntityType)AtlantisEntityInit.PALM_BOAT.get()), world);
            boatEntity.setPos(hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
            boatEntity.setYRot(user.getYRot());
            world.addFreshEntity((Entity)boatEntity);
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, new BlockPos((int)hitResult.getLocation().x, (int)hitResult.getLocation().y, (int)hitResult.getLocation().z));
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, blockPos);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public InteractionResultHolder<ItemStack> usee(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = PalmBoatItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Vec3 vec3d = user.getViewVector(1.0f);
        List list = world.getEntities((Entity)user, user.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), RIDERS);
        if (!list.isEmpty()) {
            Vec3 vec3d2 = user.getEyePosition();
            for (Entity entity : list) {
                AABB box = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!box.contains(vec3d2)) continue;
                return InteractionResultHolder.pass((Object)itemStack);
            }
        }
        PalmBoatEntity boatEntity = new PalmBoatEntity((EntityType<? extends Boat>)((EntityType)AtlantisEntityInit.PALM_BOAT.get()), world);
        boatEntity.setPos(hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
        boatEntity.setYRot(user.getYRot());
        if (!world.isClientSide) {
            world.addFreshEntity((Entity)boatEntity);
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, new BlockPos((int)hitResult.getLocation().x, (int)hitResult.getLocation().y, (int)hitResult.getLocation().z));
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }
}

