/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items.armor;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public record AtlantisArmorSet(Holder<ArmorMaterial> material, Holder<MobEffect> effect, DeferredItem<Item> helmet, DeferredItem<Item> chestplate, DeferredItem<Item> leggings, DeferredItem<Item> boots) {
    public static final Map<Holder<ArmorMaterial>, AtlantisArmorSet> SETS = new HashMap<Holder<ArmorMaterial>, AtlantisArmorSet>();

    public static AtlantisArmorSet create(DeferredRegister.Items register, String name, Holder<ArmorMaterial> material, Holder<MobEffect> effect) {
        Item.Properties properties = new Item.Properties();
        return new AtlantisArmorSet(material, effect, (DeferredItem<Item>)register.register(name + "_helmet", () -> new Armor(material, ArmorItem.Type.HELMET, properties)), (DeferredItem<Item>)register.register(name + "_chestplate", () -> new Armor(material, ArmorItem.Type.CHESTPLATE, properties)), (DeferredItem<Item>)register.register(name + "_leggings", () -> new Armor(material, ArmorItem.Type.LEGGINGS, properties)), (DeferredItem<Item>)register.register(name + "_boots", () -> new Armor(material, ArmorItem.Type.BOOTS, properties)));
    }

    protected void evaluateArmorEffects(Player player) {
        if (this.hasCorrectArmorOn(player)) {
            this.addStatusEffectForMaterial(player);
        }
    }

    private void addStatusEffectForMaterial(Player player) {
        boolean hasPlayerEffect = player.hasEffect(this.effect);
        if (this.hasCorrectArmorOn(player) && !hasPlayerEffect) {
            player.addEffect(new MobEffectInstance(this.effect, 2001, 1, false, false));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.getInventory().getArmor(0);
        ItemStack leggings = player.getInventory().getArmor(1);
        ItemStack breastplate = player.getInventory().getArmor(2);
        ItemStack helmet = player.getInventory().getArmor(3);
        return !helmet.isEmpty() && !breastplate.isEmpty() && !leggings.isEmpty() && !boots.isEmpty();
    }

    private boolean hasCorrectArmorOn(Player player) {
        for (ItemStack armor : player.getInventory().armor) {
            Item item = armor.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (!armorItem.getMaterial().equals(this.material)) continue;
                return false;
            }
            return false;
        }
        ItemStack boots = player.getInventory().getArmor(0);
        ItemStack leggings = player.getInventory().getArmor(1);
        ItemStack breastplate = player.getInventory().getArmor(2);
        ItemStack helmet = player.getInventory().getArmor(3);
        return helmet.is(this.helmet()) && breastplate.is(this.chestplate()) && leggings.is(this.leggings()) && boots.is(this.boots());
    }

    private static class Armor
    extends ArmorItem {
        public Armor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
        }

        public void inventoryTick(@NotNull ItemStack stack, Level world, @NotNull Entity entity, int slot, boolean selected) {
            if (!world.isClientSide() && entity instanceof Player) {
                Player player = (Player)entity;
                SETS.get(this.material).evaluateArmorEffects(player);
            }
            super.inventoryTick(stack, world, entity, slot, selected);
        }
    }
}

