/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items.tools;

import com.mystic.atlantis.items.tools.HammerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="atlantis", bus=EventBusSubscriber.Bus.GAME)
public class HammerAoEHandler {
    private static final ThreadLocal<Boolean> IN_AOE = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (Boolean.TRUE.equals(IN_AOE.get())) {
            return;
        }
        ItemStack held = sp.getMainHandItem();
        Item item = held.getItem();
        if (!(item instanceof HammerItem)) {
            return;
        }
        HammerItem hammer = (HammerItem)item;
        ServerLevel level = sp.serverLevel();
        BlockPos origin = e.getPos();
        Direction face = HammerAoEHandler.getHitFaceServer(sp, origin);
        if (face == null) {
            face = sp.getDirection().getOpposite();
        }
        try {
            IN_AOE.set(true);
            hammer.minePlaneAround(level, origin, face, sp, held);
        }
        finally {
            IN_AOE.set(false);
        }
    }

    private static Direction getHitFaceServer(ServerPlayer sp, BlockPos origin) {
        HitResult hr = sp.pick(6.0, 0.0f, false);
        if (hr instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hr;
            if (hr.getType() == HitResult.Type.BLOCK && bhr.getBlockPos().equals((Object)origin)) {
                return bhr.getDirection();
            }
        }
        return null;
    }
}

