/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items.tools;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class HammerItem
extends PickaxeItem {
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;

    public HammerItem(Tier tier, int sizeX, int sizeY, int sizeZ, Item.Properties props) {
        super(tier, props);
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void minePlaneAround(ServerLevel level, BlockPos origin, Direction face, ServerPlayer player, ItemStack tool) {
        Direction normal = face.getOpposite();
        PlaneAxes axes = this.planeAxesForFace(face);
        int uStart = -(axes.sizeU % 2 == 0 ? axes.sizeU / 2 - 1 : axes.sizeU / 2);
        int vStart = -(axes.sizeV % 2 == 0 ? axes.sizeV / 2 - 1 : axes.sizeV / 2);
        int forwardDepth = switch (normal) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> this.sizeY;
            case Direction.NORTH, Direction.SOUTH -> this.sizeZ;
            case Direction.WEST, Direction.EAST -> this.sizeX;
        };
        for (int du = 0; du < axes.sizeU; ++du) {
            for (int dv = 0; dv < axes.sizeV; ++dv) {
                for (int dn = 0; dn < forwardDepth; ++dn) {
                    BlockState state;
                    int offU = uStart + du;
                    int offV = vStart + dv;
                    BlockPos target = this.offsetInPlane(origin, axes, offU, offV, normal, dn);
                    if (target.equals((Object)origin) || !level.isLoaded(target) || (state = level.getBlockState(target)).isAir() || state.getDestroySpeed((BlockGetter)level, target) < 0.0f || !tool.isCorrectToolForDrops(state) || !player.gameMode.destroyBlock(target)) continue;
                    tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, target, GameEvent.Context.of((Entity)player, (BlockState)state));
                }
            }
        }
    }

    private PlaneAxes planeAxesForFace(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> new PlaneAxes(Direction.EAST, Direction.SOUTH, this.sizeX, this.sizeZ);
            case Direction.NORTH, Direction.SOUTH -> new PlaneAxes(Direction.EAST, Direction.UP, this.sizeX, this.sizeY);
            case Direction.WEST, Direction.EAST -> new PlaneAxes(Direction.SOUTH, Direction.UP, this.sizeZ, this.sizeY);
        };
    }

    private BlockPos offsetInPlane(BlockPos origin, PlaneAxes axes, int offU, int offV, Direction normal, int depth) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        x += offU * axes.uAxis.getStepX();
        y += offU * axes.uAxis.getStepY();
        z += offU * axes.uAxis.getStepZ();
        x += offV * axes.vAxis.getStepX();
        y += offV * axes.vAxis.getStepY();
        z += offV * axes.vAxis.getStepZ();
        return new BlockPos(x += depth * normal.getStepX(), y += depth * normal.getStepY(), z += depth * normal.getStepZ());
    }

    private record PlaneAxes(Direction uAxis, Direction vAxis, int sizeU, int sizeV) {
    }
}

