/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.blocks.base.ExtendedBlockEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntityType.class})
public abstract class BlockEntityTypeMixin
implements ExtendedBlockEntity {
    @Unique
    private final Set<Block> additionalValidBLock = new HashSet<Block>();

    @Override
    public void addAdditionalValidBlock(Block ... blocks) {
        this.additionalValidBLock.addAll(Set.of(blocks));
    }

    @Inject(method={"isValid"}, at={@At(value="RETURN")}, cancellable=true)
    private void isValid(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            cir.setReturnValue((Object)this.additionalValidBLock.contains(state.getBlock()));
        }
    }
}

