/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.mixin.ItemMixin;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class}, priority=1100)
public class BucketItemMixin
extends ItemMixin {
    @Shadow
    @Final
    private Fluid content;

    @Inject(method={"use"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z")}, cancellable=true)
    public void onBucketUse(Level level, Player player, InteractionHand usedHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        BlockHitResult blockhitresult = BucketItemMixin.getPlayerPOVHitResult(level, player, this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        BlockPos blockpos = blockhitresult.getBlockPos();
        ItemStack itemStack = player.getItemInHand(usedHand);
        BlockState blockstate1 = level.getBlockState(blockpos);
        if (AtlantisDimensions.isAtlantisDimension(level)) {
            ItemStack itemstack1;
            cir.cancel();
            if (blockstate1.getBlock() instanceof BucketPickup && !(itemstack1 = ((BucketPickup)blockstate1.getBlock()).pickupBlock(player, (LevelAccessor)level, blockpos, blockstate1)).isEmpty()) {
                if (itemstack1.getItem() != Blocks.WATER.asItem()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.FILLED_BUCKET.trigger(serverPlayer, itemstack1);
                        cir.setReturnValue((Object)InteractionResultHolder.success((Object)itemStack));
                    } else {
                        cir.setReturnValue((Object)InteractionResultHolder.pass((Object)itemStack));
                    }
                }
            } else {
                cir.setReturnValue((Object)InteractionResultHolder.pass((Object)itemStack));
            }
        }
    }
}

